<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.66.10.207
Name: KEZO Contactverslag
Description: Bouwsteen: Contactverslag Verdere informatie
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" id="template-2.16.840.1.113883.2.4.3.11.60.66.10.207-2015-06-01T000000">
   <title>KEZO Contactverslag</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.207
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]
Item: (KEZO Contactverslag)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.207
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]
Item: (KEZO Contactverslag)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]" id="d152e9528-false-d48801e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="string(@classCode) = ('ACT')">(KEZO Contactverslag): de waarde van classCode MOET 'ACT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="string(@moodCode) = ('EVN')">(KEZO Contactverslag): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']) &gt;= 1">(KEZO Contactverslag): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207'] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']) &lt;= 1">(KEZO Contactverslag): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207'] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(KEZO Contactverslag): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="count(hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(KEZO Contactverslag): element hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="count(hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(KEZO Contactverslag): element hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(KEZO Contactverslag): element hl7:statusCode[@code = 'completed'] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(KEZO Contactverslag): element hl7:statusCode[@code = 'completed'] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="count(hl7:effectiveTime[not(@nullFlavor)]) &gt;= 1">(KEZO Contactverslag): element hl7:effectiveTime[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="count(hl7:effectiveTime[not(@nullFlavor)]) &lt;= 1">(KEZO Contactverslag): element hl7:effectiveTime[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="count(hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]) &lt;= 1">(KEZO Contactverslag): element hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="count(hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]]) &lt;= 1">(KEZO Contactverslag): element hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="count(hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.209']]]) &lt;= 1">(KEZO Contactverslag): element hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.209']]] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="count(hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]]) &lt;= 1">(KEZO Contactverslag): element hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="count(hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.211']]]) &lt;= 1">(KEZO Contactverslag): element hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.211']]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.207
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']
Item: (KEZO Contactverslag)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']" id="d152e9534-false-d48973e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(KEZO Contactverslag): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.66.10.207')">(KEZO Contactverslag): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.66.10.207' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.207
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:id[not(@nullFlavor)]
Item: (KEZO Contactverslag)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:id[not(@nullFlavor)]" id="d152e9539-false-d48991e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(KEZO Contactverslag): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.207
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (KEZO Contactverslag)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')]" id="d152e9541-false-d49003e0">
      <extends rule="CV"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(KEZO Contactverslag): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="@nullFlavor or (@code='34900-1' and @codeSystem='2.16.840.1.113883.6.1')">(KEZO Contactverslag): de elementwaarde MOET een zijn van 'code '34900-1' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.207
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:statusCode[@code = 'completed']
Item: (KEZO Contactverslag)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:statusCode[@code = 'completed']" id="d152e9547-false-d49022e0">
      <extends rule="CS"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(KEZO Contactverslag): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="@nullFlavor or (@code='completed')">(KEZO Contactverslag): de elementwaarde MOET een zijn van 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.207
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:effectiveTime[not(@nullFlavor)]
Item: (KEZO Contactverslag)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:effectiveTime[not(@nullFlavor)]" id="d152e9552-false-d49041e0">
      <extends rule="TS.DATE.MIN"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(KEZO Contactverslag): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="not(*)">(KEZO Contactverslag): <value-of select="local-name()"/> met datatype TS.DATE.MIN, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.207
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]
Item: (KEZO Contactverslag)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]" id="d152e9558-false-d49060e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="string(@typeCode) = ('RESP') or not(@typeCode)">(KEZO Contactverslag): de waarde van typeCode MOET 'RESP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="count(hl7:time) &lt;= 1">(KEZO Contactverslag): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="count(hl7:participantRole[@classCode = 'ASSIGNED']) &gt;= 1">(KEZO Contactverslag): element hl7:participantRole[@classCode = 'ASSIGNED'] is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="count(hl7:participantRole[@classCode = 'ASSIGNED']) &lt;= 1">(KEZO Contactverslag): element hl7:participantRole[@classCode = 'ASSIGNED'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:time
Item: (KEZO PART CDA Responsible Party (Body))
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:time" id="d49099e30-false-d49106e0">
      <extends rule="IVL_TS"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']
Item: (KEZO PART CDA Responsible Party (Body))
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']" id="d49099e35-false-d49118e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="string(@classCode) = ('ASSIGNED')">(KEZO PART CDA Responsible Party (Body)): de waarde van classCode MOET 'ASSIGNED' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @nullFlavor]) &lt;= 1">(KEZO PART CDA Responsible Party (Body)): element hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="count(hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']) &lt;= 1">(KEZO PART CDA Responsible Party (Body)): element hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE'] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="count(hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(KEZO PART CDA Responsible Party (Body)): element hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:id
Item: (KEZO PART CDA Responsible Party (Body))
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:id" id="d49099e39-false-d49171e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @nullFlavor]
Item: (KEZO PART CDA Responsible Party (Body))
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @nullFlavor]" id="d49099e45-false-d49183e0">
      <extends rule="CE"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="@nullFlavor or (@codeSystem='2.16.840.1.113883.2.4.15.111')">(KEZO PART CDA Responsible Party (Body)): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.2.4.15.111''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:addr
Item: (KEZO PART CDA Responsible Party (Body))
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:addr" id="d49099e52-false-d49202e0">
      <extends rule="AD"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')">(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:telecom
Item: (KEZO PART CDA Responsible Party (Body))
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:telecom" id="d49099e54-false-d49214e0">
      <extends rule="TEL"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']
Item: (KEZO PART CDA Responsible Party (Body))
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']" id="d49099e57-false-d49226e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="string(@classCode) = ('PSN')">(KEZO PART CDA Responsible Party (Body)): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="string(@determinerCode) = ('INSTANCE')">(KEZO PART CDA Responsible Party (Body)): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(KEZO PART CDA Responsible Party (Body)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (KEZO PART CDA Responsible Party (Body))
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]" id="d49099e66-false-d49263e0">
      <extends rule="CE"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(KEZO PART CDA Responsible Party (Body)): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.2 RoleCodeNL - zorgverlenertype (personen) (DYNAMISCH)'.</assert>
      <report fpi="CD-DEPR-BSP" role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem])">(KEZO PART CDA Responsible Party (Body)): element hl7:code is gecodeerd met bindingssterkte 'required' en bevat een code die verouderd is.</report>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name
Item: (KEZO PART CDA Responsible Party (Body))
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name" id="d49099e71-false-d49291e0">
      <extends rule="PN"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (KEZO PART CDA Responsible Party (Body))
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']" id="d49099e74-false-d49303e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="string(@classCode) = ('ORG')">(KEZO PART CDA Responsible Party (Body)): de waarde van classCode MOET 'ORG' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="string(@determinerCode) = ('INSTANCE')">(KEZO PART CDA Responsible Party (Body)): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]) &lt;= 1">(KEZO PART CDA Responsible Party (Body)): element hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="count(hl7:desc) &lt;= 1">(KEZO PART CDA Responsible Party (Body)): element hl7:desc komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (KEZO PART CDA Responsible Party (Body))
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id" id="d49099e83-false-d49345e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]
Item: (KEZO PART CDA Responsible Party (Body))
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]" id="d49099e85-false-d49357e0">
      <extends rule="CE"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="@nullFlavor or (@codeSystem='2.16.840.1.113883.2.4.15.1060')">(KEZO PART CDA Responsible Party (Body)): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.2.4.15.1060''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:desc
Item: (KEZO PART CDA Responsible Party (Body))
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:desc" id="d49099e91-false-d49376e0">
      <extends rule="ST"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.32
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter]
Item: (part Encounter reference)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter]" id="d49383e6-false-d49388e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.32" test="string(@typeCode) = ('REFR')">(part Encounter reference): de waarde van typeCode MOET 'REFR' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.32" test="count(hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN']) &gt;= 1">(part Encounter reference): element hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN'] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.32" test="count(hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN']) &lt;= 1">(part Encounter reference): element hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.32
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter]/hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN']
Item: (part Encounter reference)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter]/hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN']" id="d49383e20-false-d49417e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.32" test="string(@classCode) = ('ENC')">(part Encounter reference): de waarde van classCode MOET 'ENC' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.32" test="string(@moodCode) = ('EVN')">(part Encounter reference): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.32" test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(part Encounter reference): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.32" test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(part Encounter reference): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.32
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter]/hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN']/hl7:id[not(@nullFlavor)]
Item: (part Encounter reference)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter]/hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN']/hl7:id[not(@nullFlavor)]" id="d49383e32-false-d49452e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.32" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(part Encounter reference): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.33
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]
Item: (part Concern reference)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]" id="d49459e6-false-d49464e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="string(@typeCode) = ('REFR')">(part Concern reference): de waarde van typeCode MOET 'REFR' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="count(hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]) &gt;= 1">(part Concern reference): element hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="count(hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]) &lt;= 1">(part Concern reference): element hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.33
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]
Item: (part Concern reference)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]" id="d49459e21-false-d49493e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="string(@classCode) = ('ACT')">(part Concern reference): de waarde van classCode MOET 'ACT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="string(@moodCode) = ('EVN')">(part Concern reference): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(part Concern reference): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(part Concern reference): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="count(hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]) &gt;= 1">(part Concern reference): element hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="count(hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]) &lt;= 1">(part Concern reference): element hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.33
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]/hl7:id[not(@nullFlavor)]
Item: (part Concern reference)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]/hl7:id[not(@nullFlavor)]" id="d49459e33-false-d49543e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(part Concern reference): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.33
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]/hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]
Item: (part Concern reference)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]/hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]" id="d49459e43-false-d49555e0">
      <extends rule="CV"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(part Concern reference): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="@nullFlavor or (@code='CONC' and @codeSystem='2.16.840.1.113883.5.6')">(part Concern reference): de elementwaarde MOET een zijn van 'code 'CONC' codeSystem '2.16.840.1.113883.5.6''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.207
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]]
Item: (KEZO Contactverslag)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="string(@typeCode) = ('COMP')">(KEZO Contactverslag): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.207
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.209']]]
Item: (KEZO Contactverslag)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.209']]]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="string(@typeCode) = ('COMP')">(KEZO Contactverslag): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.207
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]]
Item: (KEZO Contactverslag)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="string(@typeCode) = ('COMP')">(KEZO Contactverslag): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.207
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.211']]]
Item: (KEZO Contactverslag)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.211']]]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207" test="string(@typeCode) = ('COMP')">(KEZO Contactverslag): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
</pattern>