<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.66.10.215
Name: KEZO Allergy Concern
Description: Bouwsteen: Allergie / Intolerantie Verdere informatie
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" id="template-2.16.840.1.113883.2.4.3.11.60.66.10.215-2015-07-15T000000">
   <title>KEZO Allergy Concern</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.215
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]
Item: (KEZO Allergy Concern)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.215
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]
Item: (KEZO Allergy Concern)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]" id="d152e10163-false-d53077e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="string(@classCode) = ('ACT')">(KEZO Allergy Concern): de waarde van classCode MOET 'ACT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="string(@moodCode) = ('EVN')">(KEZO Allergy Concern): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']) &gt;= 1">(KEZO Allergy Concern): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215'] is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']) &lt;= 1">(KEZO Allergy Concern): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215'] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(KEZO Allergy Concern): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="count(hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]) &gt;= 1">(KEZO Allergy Concern): element hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="count(hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]) &lt;= 1">(KEZO Allergy Concern): element hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.11.20.9.19-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]) &gt;= 1">(KEZO Allergy Concern): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.11.20.9.19-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.11.20.9.19-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]) &lt;= 1">(KEZO Allergy Concern): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.11.20.9.19-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="count(hl7:effectiveTime[hl7:low]) &lt;= 1">(KEZO Allergy Concern): element hl7:effectiveTime[hl7:low] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.216']]]) &gt;= 1">(KEZO Allergy Concern): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.216']]] is required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.215
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']
Item: (KEZO Allergy Concern)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']" id="d152e10169-false-d53241e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(KEZO Allergy Concern): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.66.10.215')">(KEZO Allergy Concern): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.66.10.215' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.215
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:id[not(@nullFlavor)]
Item: (KEZO Allergy Concern)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:id[not(@nullFlavor)]" id="d152e10174-false-d53259e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(KEZO Allergy Concern): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.215
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]
Item: (KEZO Allergy Concern)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]" id="d152e10176-false-d53271e0">
      <extends rule="CE"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(KEZO Allergy Concern): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="@nullFlavor or (@code='CONC' and @codeSystem='2.16.840.1.113883.5.6')">(KEZO Allergy Concern): de elementwaarde MOET een zijn van 'code 'CONC' codeSystem '2.16.840.1.113883.5.6''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.215
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.11.20.9.19-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]
Item: (KEZO Allergy Concern)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.11.20.9.19-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]" id="d152e10182-false-d53292e0">
      <extends rule="CS"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(KEZO Allergy Concern): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.11.20.9.19-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(KEZO Allergy Concern): de elementwaarde MOET een zijn van '2.16.840.1.113883.11.20.9.19 ProblemActStatusCode (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.215
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:effectiveTime[hl7:low]
Item: (KEZO Allergy Concern)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:effectiveTime[hl7:low]" id="d152e10187-false-d53315e0">
      <extends rule="IVL_TS"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(KEZO Allergy Concern): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="count(hl7:low) &gt;= 1">(KEZO Allergy Concern): element hl7:low is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="count(hl7:low) &lt;= 1">(KEZO Allergy Concern): element hl7:low komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="count(hl7:high) &lt;= 1">(KEZO Allergy Concern): element hl7:high komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.215
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:effectiveTime[hl7:low]/hl7:low
Item: (KEZO Allergy Concern)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.215
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:effectiveTime[hl7:low]/hl7:high
Item: (KEZO Allergy Concern)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.215
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]
Item: (KEZO Allergy Concern)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]" id="d152e10197-false-d53387e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="string(@typeCode) = ('AUT') or not(@typeCode)">(KEZO Allergy Concern): de waarde van typeCode MOET 'AUT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(KEZO Allergy Concern): de waarde van contextControlCode MOET 'OP' zijn. Gevonden: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="count(hl7:functionCode) &lt;= 1">(KEZO Allergy Concern): element hl7:functionCode komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="count(hl7:time) &gt;= 1">(KEZO Allergy Concern): element hl7:time is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="count(hl7:time) &lt;= 1">(KEZO Allergy Concern): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="count(hl7:assignedAuthor) &gt;= 1">(KEZO Allergy Concern): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="count(hl7:assignedAuthor) &lt;= 1">(KEZO Allergy Concern): element hl7:assignedAuthor komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9025
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode
Item: (KEZO PART CDA Author (Body))
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode" id="d53463e8-false-d53470e0">
      <extends rule="CD"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(KEZO PART CDA Author (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9025
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (KEZO PART CDA Author (Body))
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:time" id="d53463e12-false-d53482e0">
      <extends rule="TS"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(KEZO PART CDA Author (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025" test="not(*)">(KEZO PART CDA Author (Body)): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9025
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (KEZO PART CDA Author (Body))
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor" id="d53463e17-false-d53514e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025" test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(KEZO PART CDA Author (Body)): de waarde van classCode MOET 'ASSIGNED' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025" test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(KEZO PART CDA Author (Body)): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025" test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(KEZO PART CDA Author (Body)): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025" test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(KEZO PART CDA Author (Body)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025" test="count(hl7:assignedPerson) &lt;= 1">(KEZO PART CDA Author (Body)): element hl7:assignedPerson komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025" test="count(hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]) &lt;= 1">(KEZO PART CDA Author (Body)): element hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025" test="hl7:assignedPerson | hl7:representedOrganization">(KEZO PART CDA Author (Body)): Er moet tenminste een persoon of vertegenwoordigende organisatie zijn. Element assignedPerson of representedOrganization moet voorkomen</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id[not(@nullFlavor)]
Item: (KEZO PART CDA Assigned Entity)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id[not(@nullFlavor)]" id="d53590e5-false-d53597e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(KEZO PART CDA Assigned Entity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (KEZO PART CDA Assigned Entity)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]" id="d53590e10-false-d53611e0">
      <extends rule="CV"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(KEZO PART CDA Assigned Entity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(KEZO PART CDA Assigned Entity): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.2 RoleCodeNL - zorgverlenertype (personen) (DYNAMISCH)'.</assert>
      <report fpi="CD-DEPR-BSP" role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem])">(KEZO PART CDA Assigned Entity): element hl7:code is gecodeerd met bindingssterkte 'required' en bevat een code die verouderd is.</report>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr
Item: (KEZO PART CDA Assigned Entity)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr" id="d53590e17-false-d53639e0">
      <extends rule="AD"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')">(KEZO PART CDA Assigned Entity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom
Item: (KEZO PART CDA Assigned Entity)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom" id="d53590e18-false-d53651e0">
      <extends rule="TEL"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(KEZO PART CDA Assigned Entity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (KEZO PART CDA Assigned Entity)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson" id="d53590e25-false-d53665e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="string(@classCode) = ('PSN') or not(@classCode)">(KEZO PART CDA Assigned Entity): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(KEZO PART CDA Assigned Entity): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9001
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (PART CDA Person)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name" id="d53690e7-false-d53697e0">
      <extends rule="PN"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9001" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(PART CDA Person): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]
Item: (KEZO PART CDA Assigned Entity)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]" id="d53590e35-false-d53716e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="string(@classCode) = ('ORG') or not(@classCode)">(KEZO PART CDA Assigned Entity): de waarde van classCode MOET 'ORG' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(KEZO PART CDA Assigned Entity): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="count(hl7:id[@root = '2.16.528.1.1007.3.3']) &gt;= 1">(KEZO PART CDA Assigned Entity): element hl7:id[@root = '2.16.528.1.1007.3.3'] is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="count(hl7:id[@root = '2.16.528.1.1007.3.3']) &lt;= 1">(KEZO PART CDA Assigned Entity): element hl7:id[@root = '2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="count(hl7:name) &gt;= 1">(KEZO PART CDA Assigned Entity): element hl7:name is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="count(hl7:name) &lt;= 1">(KEZO PART CDA Assigned Entity): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="count(hl7:addr) &lt;= 1">(KEZO PART CDA Assigned Entity): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="count(hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(KEZO PART CDA Assigned Entity): element hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id[@root = '2.16.528.1.1007.3.3']
Item: (PART CDA Organization)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id[@root = '2.16.528.1.1007.3.3']" id="d53795e7-false-d53802e0">
      <extends rule="II.NL.URA"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(PART CDA Organization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="string(@root) = ('2.16.528.1.1007.3.3')">(PART CDA Organization): de waarde van root MOET '2.16.528.1.1007.3.3' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id
Item: (PART CDA Organization)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id" id="d53795e14-false-d53820e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(PART CDA Organization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:name
Item: (PART CDA Organization)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:name" id="d53795e19-false-d53832e0">
      <extends rule="ON"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ON')">(PART CDA Organization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:telecom
Item: (PART CDA Organization)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:telecom" id="d53795e20-false-d53844e0">
      <extends rule="TEL"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(PART CDA Organization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:addr
Item: (PART CDA Organization)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:addr" id="d53795e21-false-d53856e0">
      <extends rule="AD"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')">(PART CDA Organization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (PART CDA Organization)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]" id="d53795e22-false-d53870e0">
      <extends rule="CE"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(PART CDA Organization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(PART CDA Organization): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3 OrganisatieTypeCodelijst (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.215
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.216']]]
Item: (KEZO Allergy Concern)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.216']]]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.215" test="string(@typeCode) = ('SUBJ')">(KEZO Allergy Concern): de waarde van typeCode MOET 'SUBJ' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
</pattern>