<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<axsl:stylesheet xmlns:axsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:saxon="http://saxon.sf.net/" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:iso="http://purl.oclc.org/dsdl/schematron" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:hl7="urn:hl7-org:v3" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->

   <axsl:param name="archiveDirParameter"/>
   <axsl:param name="archiveNameParameter"/>
   <axsl:param name="fileNameParameter"/>
   <axsl:param name="fileDirParameter"/>
   <axsl:variable name="document-uri">
      <axsl:value-of select="document-uri(/)"/>
   </axsl:variable>

<!--PHASES-->


<!--PROLOG-->

   <axsl:output xmlns:svrl="http://purl.oclc.org/dsdl/svrl" method="xml" omit-xml-declaration="no" standalone="yes" indent="yes"/>

<!--XSD TYPES FOR XSLT2-->


<!--KEYS AND FUNCTIONS-->


<!--DEFAULT RULES-->


<!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->

   <axsl:template match="*" mode="schematron-select-full-path">
      <axsl:apply-templates select="." mode="schematron-get-full-path"/>
   </axsl:template>

<!--MODE: SCHEMATRON-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->

   <axsl:template match="*" mode="schematron-get-full-path">
      <axsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <axsl:text>/</axsl:text>
      <axsl:choose>
         <axsl:when test="namespace-uri()=''">
            <axsl:value-of select="name()"/>
         </axsl:when>
         <axsl:otherwise>
            <axsl:text>*:</axsl:text>
            <axsl:value-of select="local-name()"/>
            <axsl:text>[namespace-uri()='</axsl:text>
            <axsl:value-of select="namespace-uri()"/>
            <axsl:text>']</axsl:text>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="preceding" select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <axsl:text>[</axsl:text>
      <axsl:value-of select="1+ $preceding"/>
      <axsl:text>]</axsl:text>
   </axsl:template>
   <axsl:template match="@*" mode="schematron-get-full-path">
      <axsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <axsl:text>/</axsl:text>
      <axsl:choose>
         <axsl:when test="namespace-uri()=''">@<axsl:value-of select="name()"/>
         </axsl:when>
         <axsl:otherwise>
            <axsl:text>@*[local-name()='</axsl:text>
            <axsl:value-of select="local-name()"/>
            <axsl:text>' and namespace-uri()='</axsl:text>
            <axsl:value-of select="namespace-uri()"/>
            <axsl:text>']</axsl:text>
         </axsl:otherwise>
      </axsl:choose>
   </axsl:template>

<!--MODE: SCHEMATRON-FULL-PATH-2-->
<!--This mode can be used to generate prefixed XPath for humans-->

   <axsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <axsl:for-each select="ancestor-or-self::*">
         <axsl:text>/</axsl:text>
         <axsl:value-of select="name(.)"/>
         <axsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <axsl:text>[</axsl:text>
            <axsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <axsl:text>]</axsl:text>
         </axsl:if>
      </axsl:for-each>
      <axsl:if test="not(self::*)">
         <axsl:text/>/@<axsl:value-of select="name(.)"/>
      </axsl:if>
   </axsl:template><!--MODE: SCHEMATRON-FULL-PATH-3-->
<!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->

   <axsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <axsl:for-each select="ancestor-or-self::*">
         <axsl:text>/</axsl:text>
         <axsl:value-of select="name(.)"/>
         <axsl:if test="parent::*">
            <axsl:text>[</axsl:text>
            <axsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <axsl:text>]</axsl:text>
         </axsl:if>
      </axsl:for-each>
      <axsl:if test="not(self::*)">
         <axsl:text/>/@<axsl:value-of select="name(.)"/>
      </axsl:if>
   </axsl:template>

<!--MODE: GENERATE-ID-FROM-PATH -->

   <axsl:template match="/" mode="generate-id-from-path"/>
   <axsl:template match="text()" mode="generate-id-from-path">
      <axsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <axsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </axsl:template>
   <axsl:template match="comment()" mode="generate-id-from-path">
      <axsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <axsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </axsl:template>
   <axsl:template match="processing-instruction()" mode="generate-id-from-path">
      <axsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <axsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </axsl:template>
   <axsl:template match="@*" mode="generate-id-from-path">
      <axsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <axsl:value-of select="concat('.@', name())"/>
   </axsl:template>
   <axsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <axsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <axsl:text>.</axsl:text>
      <axsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </axsl:template>

<!--MODE: GENERATE-ID-2 -->

   <axsl:template match="/" mode="generate-id-2">U</axsl:template>
   <axsl:template match="*" mode="generate-id-2" priority="2">
      <axsl:text>U</axsl:text>
      <axsl:number level="multiple" count="*"/>
   </axsl:template>
   <axsl:template match="node()" mode="generate-id-2">
      <axsl:text>U.</axsl:text>
      <axsl:number level="multiple" count="*"/>
      <axsl:text>n</axsl:text>
      <axsl:number count="node()"/>
   </axsl:template>
   <axsl:template match="@*" mode="generate-id-2">
      <axsl:text>U.</axsl:text>
      <axsl:number level="multiple" count="*"/>
      <axsl:text>_</axsl:text>
      <axsl:value-of select="string-length(local-name(.))"/>
      <axsl:text>_</axsl:text>
      <axsl:value-of select="translate(name(),':','.')"/>
   </axsl:template><!--Strip characters-->
   <axsl:template match="text()" priority="-1"/>

<!--SCHEMA SETUP-->

   <axsl:template match="/">
      <svrl:schematron-output xmlns:svrl="http://purl.oclc.org/dsdl/svrl" title="Schematronvalidatie van MCCI_IN000002 - Accept Acknowledgement" schemaVersion="">
         <axsl:comment>
            <axsl:value-of select="$archiveDirParameter"/>   
		 <axsl:value-of select="$archiveNameParameter"/>  
		 <axsl:value-of select="$fileNameParameter"/>  
		 <axsl:value-of select="$fileDirParameter"/>
         </axsl:comment>
         <svrl:ns-prefix-in-attribute-values uri="urn:hl7-org:v3" prefix="hl7"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
         <svrl:active-pattern>
            <axsl:attribute name="document">
               <axsl:value-of select="document-uri(/)"/>
            </axsl:attribute>
            <axsl:attribute name="id">xml</axsl:attribute>
            <axsl:attribute name="name">Attributen</axsl:attribute>
            <axsl:apply-templates/>
         </svrl:active-pattern>
         <axsl:apply-templates select="/" mode="M3"/>
         <svrl:active-pattern>
            <axsl:attribute name="document">
               <axsl:value-of select="document-uri(/)"/>
            </axsl:attribute>
            <axsl:attribute name="id">MCCI_IN000002-wrapper</axsl:attribute>
            <axsl:attribute name="name">Transmission Wrapper, geen batch MCCI_IN200101</axsl:attribute>
            <axsl:apply-templates/>
         </svrl:active-pattern>
         <axsl:apply-templates select="/" mode="M4"/>
         <svrl:active-pattern>
            <axsl:attribute name="document">
               <axsl:value-of select="document-uri(/)"/>
            </axsl:attribute>
            <axsl:apply-templates/>
         </svrl:active-pattern>
         <axsl:apply-templates select="/" mode="M5"/>
      </svrl:schematron-output>
   </axsl:template>

<!--SCHEMATRON PATTERNS-->

   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Schematronvalidatie van MCCI_IN000002 - Accept Acknowledgement</svrl:text>

<!--PATTERN xmlTest op processing instructions anders dan xml-->

   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Test op processing instructions anders dan xml</svrl:text>

	<!--RULE -->

   <axsl:template match="*[count(ancestor::*)=0]" priority="1006" mode="M3">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="*[count(ancestor::*)=0]"/>
      <axsl:variable name="unparsed" select="unparsed-text(document-uri(/))"/>
      <axsl:variable name="firstprocessinginstruction" select="substring-after(substring-before($unparsed, '?&gt;'),'&lt;?')"/>
      <axsl:variable name="declaration" select="if (starts-with($firstprocessinginstruction,'xml')) then ($firstprocessinginstruction) else ()"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(contains($declaration,' version=')) or matches($declaration, 'version=.1\.0.')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(contains($declaration,' version=')) or matches($declaration, 'version=.1\.0.')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>xml: het XML-prologattribuut moet versie 1.0 zijn.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(contains($declaration,' encoding=')) or matches($declaration, 'encoding=.(utf-8)|(UTF-8).')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(contains($declaration,' encoding=')) or matches($declaration, 'encoding=.(utf-8)|(UTF-8).')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>xml: het XML-prologattribuut encoding moet worden weggelaten of expliciet "UTF-8" zijn.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="/processing-instruction('nictiz') or not(contains($declaration,' standalone='))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="/processing-instruction('nictiz') or not(contains($declaration,' standalone='))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>xml: het XML-prologattribuut standalone mag niet worden gebruikt.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(//processing-instruction()) = 0 or /processing-instruction('nictiz')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(//processing-instruction()) = 0 or /processing-instruction('nictiz')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>xml: de XML-prolog is de enig toegestane processing instruction. Bijvoorbeeld koppelingen naar stylesheets zijn niet toegestaan.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M3"/>
   </axsl:template>
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Test op gekoppelde XML Schema's</svrl:text>

	<!--RULE -->

   <axsl:template match="*[@xsi:schemaLocation]" priority="1004" mode="M3">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="*[@xsi:schemaLocation]"/>

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="/processing-instruction('nictiz') or not(.)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="/processing-instruction('nictiz') or not(.)">
               <axsl:attribute name="role">warning</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>xml: er mogen geen XML Schema's zijn gekoppeld. Gevonden '<axsl:text/>
                  <axsl:value-of select="@xsi:schemaLocation"/>
                  <axsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M3"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="*[@xsi:noNamespaceSchemaLocation]" priority="1003" mode="M3">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="*[@xsi:noNamespaceSchemaLocation]"/>

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="/processing-instruction('nictiz') or not(.)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="/processing-instruction('nictiz') or not(.)">
               <axsl:attribute name="role">warning</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>xml: er mogen geen XML Schema's zijn gekoppeld. Gevonden '<axsl:text/>
                  <axsl:value-of select="@xsi:noNamespaceSchemaLocation"/>
                  <axsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M3"/>
   </axsl:template>
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Elementen</svrl:text>
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Attributen</svrl:text>

	<!--RULE -->

   <axsl:template match="*[@*[normalize-space()='']]" priority="1000" mode="M3">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="*[@*[normalize-space()='']]"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>xml: attributen moeten een waarde hebben</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M3"/>
   </axsl:template>
   <axsl:template match="text()" priority="-1" mode="M3"/>
   <axsl:template match="@*|node()" priority="-2" mode="M3">
      <axsl:apply-templates select="*" mode="M3"/>
   </axsl:template>

<!--PATTERN MCCI_IN000002-wrapperTransmission Wrapper Algemeen-->

   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Transmission Wrapper Algemeen</svrl:text>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:id" priority="1024" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:id"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@nullFlavor or (not(@nullFlavor) and @root)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-1-II: @root is required if @nullFlavor is not present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@root))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-2-II: @root may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-4-II: @identifierName may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@displayable))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-5-II: @displayable may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@reliability))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-6-II: @reliability may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@root) &lt;= 128)">
         <svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(string-length(@root) &lt;= 128)">
            <axsl:attribute name="role">warning</axsl:attribute>
            <axsl:attribute name="location">
               <axsl:apply-templates select="." mode="schematron-select-full-path"/>
            </axsl:attribute>
            <svrl:text>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient</svrl:text>
         </svrl:successful-report>
      </axsl:if>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@extension) &lt;= 64)">
         <svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(string-length(@extension) &lt;= 64)">
            <axsl:attribute name="role">warning</axsl:attribute>
            <axsl:attribute name="location">
               <axsl:apply-templates select="." mode="schematron-select-full-path"/>
            </axsl:attribute>
            <svrl:text>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient</svrl:text>
         </svrl:successful-report>
      </axsl:if>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="codeValue" select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="codeValue" select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: AGB-code moet 8 cijfers lang zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="codeValue" select="@extension"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: @extension moet een geldige interactie-id bevatten</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@root and @extension"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root and @extension">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: id element mist root of extension</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:creationTime" priority="1023" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:creationTime"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-1-QTY: no uncertainty</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-2-QTY: no history or updateMode</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-1-TS: null or value or child element in case of extension</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@xsi:type) or @xsi:type='TS' or ends-with(@xsi:type,':TS')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@xsi:type) or @xsi:type='TS' or ends-with(@xsi:type,':TS')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: creationTime moet datatype TS hebben. Gevonden '<axsl:text/>
                  <axsl:value-of select="@xsi:type"/>
                  <axsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string-length(@value)&gt;13"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string-length(@value)&gt;13">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: creationTime moet minimaal op de seconde nauwkeurig zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:versionCode" priority="1022" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:versionCode"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@codeSystem)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@codeSystem)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-2-CS: cannot have codeSystem</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@codeSystemName)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@codeSystemName)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-3-CS: cannot have codeSystemName</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@codeSystemVersion)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@codeSystemVersion)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-4-CS: cannot have codeSystemVersion</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@displayName)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@displayName)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-5-CS: cannot have displayName</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:originalText)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:originalText)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-6-CS: cannot have originalText</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:qualifier)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:qualifier)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-7-CS: cannot have qualifier</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:translation)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-8-CS: cannot have translation</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@code='NICTIZEd2005-Okt'"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code='NICTIZEd2005-Okt'">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: versionCode '<axsl:text/>
                  <axsl:value-of select="@code"/>
                  <axsl:text/>' moet 'NICTIZEd2005-Okt' zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:interactionId" priority="1021" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:interactionId"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@nullFlavor or (not(@nullFlavor) and @root)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-1-II: @root is required if @nullFlavor is not present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@root))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-2-II: @root may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-4-II: @identifierName may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@displayable))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-5-II: @displayable may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@reliability))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-6-II: @reliability may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@root) &lt;= 128)">
         <svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(string-length(@root) &lt;= 128)">
            <axsl:attribute name="role">warning</axsl:attribute>
            <axsl:attribute name="location">
               <axsl:apply-templates select="." mode="schematron-select-full-path"/>
            </axsl:attribute>
            <svrl:text>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient</svrl:text>
         </svrl:successful-report>
      </axsl:if>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@extension) &lt;= 64)">
         <svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(string-length(@extension) &lt;= 64)">
            <axsl:attribute name="role">warning</axsl:attribute>
            <axsl:attribute name="location">
               <axsl:apply-templates select="." mode="schematron-select-full-path"/>
            </axsl:attribute>
            <svrl:text>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient</svrl:text>
         </svrl:successful-report>
      </axsl:if>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="codeValue" select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="codeValue" select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: AGB-code moet 8 cijfers lang zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="codeValue" select="@extension"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: @extension moet een geldige interactie-id bevatten</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="interactionId" select="self::node()[@root='2.16.840.1.113883.1.6']/@extension"/>
      <axsl:variable name="interactionVocabFile" select="'../vocab/2.16.840.1.113883.1.6.xml'"/>
      <axsl:variable name="interactionName" select="if (doc-available($interactionVocabFile)) then (document($interactionVocabFile)/*/hl7:code[@code=$interactionId]/@displayName) else ()"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@root='2.16.840.1.113883.1.6'"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root='2.16.840.1.113883.1.6'">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: @root moet '2.16.840.1.113883.1.6' zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.1.6') or local-name(..)=@extension"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.1.6') or local-name(..)=@extension">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: @extension moet overeenkomen met het startelement van het bericht</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(contains(@extension,':'))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(contains(@extension,':'))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: @extension mag geen namespace prefix bevatten</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(doc-available($interactionVocabFile)) or              not(document($interactionVocabFile)/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='Actief']/@value='false')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(doc-available($interactionVocabFile)) or not(document($interactionVocabFile)/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='Actief']/@value='false')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: interaction-id <axsl:text/>
                  <axsl:value-of select="$interactionId"/>
                  <axsl:text/> (<axsl:text/>
                  <axsl:value-of select="$interactionName"/>
                  <axsl:text/>) is niet (meer) Actief in <axsl:text/>
                  <axsl:value-of select="$interactionVocabFile"/>
                  <axsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:profileId" priority="1020" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:profileId"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@nullFlavor or (not(@nullFlavor) and @root)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-1-II: @root is required if @nullFlavor is not present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@root))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-2-II: @root may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-4-II: @identifierName may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@displayable))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-5-II: @displayable may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@reliability))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-6-II: @reliability may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@root) &lt;= 128)">
         <svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(string-length(@root) &lt;= 128)">
            <axsl:attribute name="role">warning</axsl:attribute>
            <axsl:attribute name="location">
               <axsl:apply-templates select="." mode="schematron-select-full-path"/>
            </axsl:attribute>
            <svrl:text>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient</svrl:text>
         </svrl:successful-report>
      </axsl:if>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@extension) &lt;= 64)">
         <svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(string-length(@extension) &lt;= 64)">
            <axsl:attribute name="role">warning</axsl:attribute>
            <axsl:attribute name="location">
               <axsl:apply-templates select="." mode="schematron-select-full-path"/>
            </axsl:attribute>
            <svrl:text>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient</svrl:text>
         </svrl:successful-report>
      </axsl:if>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="codeValue" select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="codeValue" select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: AGB-code moet 8 cijfers lang zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="codeValue" select="@extension"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: @extension moet een geldige interactie-id bevatten</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@root='2.16.840.1.113883.2.4.3.11.1' and (@extension='810')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root='2.16.840.1.113883.2.4.3.11.1' and (@extension='810')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: profileId '<axsl:text/>
                  <axsl:value-of select="@extension"/>
                  <axsl:text/>' moet gelijk zijn aan 810. </svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(following-sibling::hl7:profileId)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(following-sibling::hl7:profileId)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: er mag maar één profileId worden gebruikt</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:acknowledgement" priority="1019" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:acknowledgement"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="local-name(..)='MCCI_IN000002' or @typeCode='AA' or @typeCode='AE' or @typeCode='AR'"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="local-name(..)='MCCI_IN000002' or @typeCode='AA' or @typeCode='AE' or @typeCode='AR'">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: applicatieantwoorden moeten acknowledgement/@typeCode AA, AE of AR hebben</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(local-name(..)='MCCI_IN000002') or @typeCode='CA' or @typeCode='CE' or @typeCode='CR'"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(local-name(..)='MCCI_IN000002') or @typeCode='CA' or @typeCode='CE' or @typeCode='CR'">
               <axsl:attribute name="role">warning</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: ontvangstbevestigingen moeten acknowledgement/@typeCode CA, CE of CR hebben. In slechts sommige gevallen worden 
            toch inhoudelijke antwoorden toegestaan (@typeCode is 'AA', 'AE' or 'AR').</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="hl7:targetMessage/hl7:id[@root and @extension] or hl7:targetTransmission/hl7:id[@root and @extension]"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="hl7:targetMessage/hl7:id[@root and @extension] or hl7:targetTransmission/hl7:id[@root and @extension]">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: in antwoordinteracties moet de interactie waarop wordt geantwoord, worden geïdentificeerd in het element targetTransmission/id</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="@typeCode='AA' or @typeCode='CA' or hl7:acknowledgementDetail or ../hl7:ControlActProcess/hl7:reason or ../hl7:ControlActProcess/hl7:reasonOf"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@typeCode='AA' or @typeCode='CA' or hl7:acknowledgementDetail or ../hl7:ControlActProcess/hl7:reason or ../hl7:ControlActProcess/hl7:reasonOf">
               <axsl:attribute name="role">warning</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: negatieve antwoordberichten moeten ook een reden hebben waarom</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:acknowledgement/hl7:acknowledgementDetail" priority="1018" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:acknowledgement/hl7:acknowledgementDetail"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@typeCode) or @typeCode='E'"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@typeCode) or @typeCode='E'">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: acknowledgementDetail/@typeCode moet indien aanwezig E (Error) zijn. W (Warning) of I (Information) zijn niet toegestaan</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="hl7:code"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="hl7:code">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: acknowledgementDetail/code moet een waarde hebben.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="hl7:code[@code and @displayName] or hl7:text"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="hl7:code[@code and @displayName] or hl7:text">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: er moet een toelichting op de fout/waarschuwing zijn in hl7:code/@displayName of text</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:acknowledgement/hl7:acknowledgementDetail/hl7:code" priority="1017" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:acknowledgement/hl7:acknowledgementDetail/hl7:code"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-1-CD: null or code and/or originalText</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@code)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem or not(@code)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-2-CD: code requires codeSystem</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@codeSystemName)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem or not(@codeSystemName)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-3-CD: codeSystemName only if codeSystem</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem or not(@codeSystemVersion)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-4-CD: codeSystemVersion only if codeSystem</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@code or not(@displayName)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code or not(@displayName)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-5-CD: displayName only if code</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@code))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-6-CD: no code if null</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@displayName))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-7-CD: no displayName if null</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation/hl7:originalText)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:translation/hl7:originalText)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-8-CD: no originalText on translations</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation/@nullFlavor)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:translation/@nullFlavor)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-10-CD: no null on translations</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="hl7:translation/@codeSystem or not(hl7:translation/@code)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-11-CD: translation code requires codeSystem</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-12-CD: translation codeSystemName only if codeSystem</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-13-CD: translation codeSystemVersion only if codeSystem</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="hl7:translation/@code or not(hl7:translation/@displayName)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-14-CD: translation displayName only if code</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="matches(@displayName,'[\r\n\t]')">
         <svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="matches(@displayName,'[\r\n\t]')">
            <axsl:attribute name="role">warning</axsl:attribute>
            <axsl:attribute name="location">
               <axsl:apply-templates select="." mode="schematron-select-full-path"/>
            </axsl:attribute>
            <svrl:text>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems.</svrl:text>
         </svrl:successful-report>
      </axsl:if>
      <axsl:variable name="code" select="@code"/>

		<!--REPORT warning-->

      <axsl:if test="@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))">
         <svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))">
            <axsl:attribute name="role">warning</axsl:attribute>
            <axsl:attribute name="location">
               <axsl:apply-templates select="." mode="schematron-select-full-path"/>
            </axsl:attribute>
            <svrl:text>Datatype CD: waarschuwing: onbekend codeSystem '<axsl:text/>
               <axsl:value-of select="@codeSystem"/>
               <axsl:text/>' gevonden met codeSystemName 
        '<axsl:text/>
               <axsl:value-of select="./@codeSystemName"/>
               <axsl:text/>'. Bestand '<axsl:text/>
               <axsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
               <axsl:text/>' ontbreekt.</svrl:text>
         </svrl:successful-report>
      </axsl:if>

		<!--REPORT warning-->

      <axsl:if test="hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))]">
         <svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))]">
            <axsl:attribute name="role">warning</axsl:attribute>
            <axsl:attribute name="location">
               <axsl:apply-templates select="." mode="schematron-select-full-path"/>
            </axsl:attribute>
            <svrl:text>Datatype CD: waarschuwing: onbekend codeSystem '<axsl:text/>
               <axsl:value-of select="hl7:translation/@codeSystem"/>
               <axsl:text/>' in translation</svrl:text>
         </svrl:successful-report>
      </axsl:if>

		<!--REPORT warning-->

      <axsl:if test="if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and (         document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or         not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then (          not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 )">
         <svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and ( document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then ( not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 )">
            <axsl:attribute name="role">warning</axsl:attribute>
            <axsl:attribute name="location">
               <axsl:apply-templates select="." mode="schematron-select-full-path"/>
            </axsl:attribute>
            <svrl:text>Datatype CD: waarschuwing: onbekende code '<axsl:text/>
               <axsl:value-of select="$code"/>
               <axsl:text/>' gevonden in codeSystem '<axsl:text/>
               <axsl:value-of select="@codeSystem"/>
               <axsl:text/>'
        gevonden met displayName '<axsl:text/>
               <axsl:value-of select="./@displayName"/>
               <axsl:text/>'. Waarde ontbreekt in 
        '<axsl:text/>
               <axsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
               <axsl:text/>' (<axsl:text/>
               <axsl:value-of select="document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:name"/>
               <axsl:text/>).</svrl:text>
         </svrl:successful-report>
      </axsl:if>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation/hl7:originalText)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:translation/hl7:originalText)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype CD: no originalText on translations</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation/hl7:translation)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:translation/hl7:translation)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype CD: no translation on translations</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation/@nullFlavor)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:translation/@nullFlavor)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype CD: no null on translations</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="hl7:translation/@codeSystem or not(hl7:translation/@code)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype CD: translation code requires codeSystem</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype CD: translation codeSystemName only if codeSystem</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype CD: translation codeSystemVersion only if codeSystem</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="hl7:translation/@code or not(hl7:translation/@displayName)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype CD: translation displayName only if code</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="codeValue" select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(../hl7:id/@root='2.16.528.1.1007.3.1') or          document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(../hl7:id/@root='2.16.528.1.1007.3.1') or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype CD: UZI rolcode attribuut code moet een geldige RoleCodeNL bevatten</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="codeValue" select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or          document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype CD: organisatie rolcode attribuut code moet een geldige AssignedRoleType bevatten</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:qualifier)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:qualifier)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-1-CE: cannot have qualifier</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nulFlavor)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nulFlavor)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: code moet een waarde hebben.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:translation)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: code mag geen translation bevatten.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="not(@codeSystem='2.16.840.1.113883.5.1100' or @codeSystem='2.16.840.1.113883.2.4.6.6.1.1000' or @codeSystem='2.16.840.1.113883.5.4') and not(@displayName)">
         <svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@codeSystem='2.16.840.1.113883.5.1100' or @codeSystem='2.16.840.1.113883.2.4.6.6.1.1000' or @codeSystem='2.16.840.1.113883.5.4') and not(@displayName)">
            <axsl:attribute name="role">warning</axsl:attribute>
            <axsl:attribute name="location">
               <axsl:apply-templates select="." mode="schematron-select-full-path"/>
            </axsl:attribute>
            <svrl:text>Transmission: als de code niet uit een van de standaardcodesystemen '2.16.840.1.113883.5.1100', '2.16.840.1.113883.2.4.6.6.1.1000', of '2.16.840.1.113883.5.4' komt is het @displayName attribuut verplicht</svrl:text>
         </svrl:successful-report>
      </axsl:if>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:receiver" priority="1016" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:receiver"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@typeCode) or @typeCode='RCV'"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@typeCode) or @typeCode='RCV'">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: receiver/@typeCode moet 'RCV' zijn indien aanwezig</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(../hl7:receiver)=1"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(../hl7:receiver)=1">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: receiver mag slechts éénmaal voorkomen</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:respondTo" priority="1015" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:respondTo"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@typeCode) or @typeCode='RSP'"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@typeCode) or @typeCode='RSP'">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: respondTo/@typeCode moet 'RSP' zijn indien aanwezig</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(../hl7:respondTo)=1"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(../hl7:respondTo)=1">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: respondTo mag slechts éénmaal voorkomen</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:entityRsp)=1"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:entityRsp)=1">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: respondTo/entityRsp mag slechts éénmaal voorkomen</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="entityRspRoot" select="hl7:entityRsp/hl7:id/@root"/>

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(hl7:entityRsp/hl7:id/@extension=../hl7:sender/hl7:device/hl7:id[@root=$entityRspRoot]/@extension)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:entityRsp/hl7:id/@extension=../hl7:sender/hl7:device/hl7:id[@root=$entityRspRoot]/@extension)">
               <axsl:attribute name="role">warning</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: waarschuwing: het antwoord moet worden verstuurd aan dezelfde applicatie als de zendende applicatie. In dit geval is respondTo redundant.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:sender" priority="1014" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:sender"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@typeCode) or @typeCode='SND'"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@typeCode) or @typeCode='SND'">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: sender/@typeCode moet 'SND' zijn indien aanwezig</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:attentionLine" priority="1013" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:attentionLine"/>
      <axsl:variable name="interactionId" select="../hl7:interactionId[@root='2.16.840.1.113883.1.6']/@extension"/>
      <axsl:variable name="interactionVocabFile" select="'../vocab/2.16.840.1.113883.1.6.xml'"/>
      <axsl:variable name="interactionName" select="if (doc-available($interactionVocabFile)) then (document($interactionVocabFile)/*/hl7:code[@code=$interactionId]/@displayName) else ()"/>

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(doc-available($interactionVocabFile)) or              document($interactionVocabFile)/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='AttentionLineMetBsn']/@value='true' or             ../hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'] or             ../hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.6']"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(doc-available($interactionVocabFile)) or document($interactionVocabFile)/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='AttentionLineMetBsn']/@value='true' or ../hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'] or ../hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.6']">
               <axsl:attribute name="role">warning</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: interaction-id <axsl:text/>
                  <axsl:value-of select="$interactionId"/>
                  <axsl:text/> (<axsl:text/>
                  <axsl:value-of select="$interactionName"/>
                  <axsl:text/>) is niet geconfigureerd voor gebruik van het element <axsl:text/>
                  <axsl:value-of select="local-name()"/>
                  <axsl:text/> in <axsl:text/>
                  <axsl:value-of select="$interactionVocabFile"/>
                  <axsl:text/> en afzender is niet GBK of GBP</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:id | hl7:respondTo/hl7:entityRsp/hl7:id" priority="1012" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:id | hl7:respondTo/hl7:entityRsp/hl7:id"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@nullFlavor or (not(@nullFlavor) and @root)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-1-II: @root is required if @nullFlavor is not present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@root))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-2-II: @root may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-4-II: @identifierName may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@displayable))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-5-II: @displayable may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@reliability))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-6-II: @reliability may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@root) &lt;= 128)">
         <svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(string-length(@root) &lt;= 128)">
            <axsl:attribute name="role">warning</axsl:attribute>
            <axsl:attribute name="location">
               <axsl:apply-templates select="." mode="schematron-select-full-path"/>
            </axsl:attribute>
            <svrl:text>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient</svrl:text>
         </svrl:successful-report>
      </axsl:if>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@extension) &lt;= 64)">
         <svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(string-length(@extension) &lt;= 64)">
            <axsl:attribute name="role">warning</axsl:attribute>
            <axsl:attribute name="location">
               <axsl:apply-templates select="." mode="schematron-select-full-path"/>
            </axsl:attribute>
            <svrl:text>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient</svrl:text>
         </svrl:successful-report>
      </axsl:if>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="codeValue" select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="codeValue" select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: AGB-code moet 8 cijfers lang zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="codeValue" select="@extension"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: @extension moet een geldige interactie-id bevatten</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@root='2.16.840.1.113883.2.4.6.6' and @extension"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root='2.16.840.1.113883.2.4.6.6' and @extension">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: <axsl:text/>
                  <axsl:value-of select="local-name(../..)"/>
                  <axsl:text/>/<axsl:text/>
                  <axsl:value-of select="local-name(..)"/>
                  <axsl:text/>/id/@root moet 2.16.840.1.113883.2.4.6.6 zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:desc" priority="1011" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:desc"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: <axsl:text/>
                  <axsl:value-of select="local-name(..)"/>
                  <axsl:text/>/device/descr mag niet gebruikt worden.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:existenceTime" priority="1010" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:existenceTime"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: <axsl:text/>
                  <axsl:value-of select="local-name(..)"/>
                  <axsl:text/>/device/existenceTime mag niet gebruikt worden.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:manufacturerModelName" priority="1009" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:manufacturerModelName"/>

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <axsl:attribute name="role">warning</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: <axsl:text/>
                  <axsl:value-of select="local-name(..)"/>
                  <axsl:text/>/device/manufacturerModelName niet gebruiken.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:agencyFor" priority="1008" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:agencyFor"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@classCode) or @classCode='AGNT'"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@classCode) or @classCode='AGNT'">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: <axsl:text/>
                  <axsl:value-of select="local-name(../..)"/>
                  <axsl:text/>/<axsl:text/>
                  <axsl:value-of select="local-name(..)"/>
                  <axsl:text/>/agencyFor/@classCode moet, indien aanwezig de waarde "AGNT" bevatten</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:agencyFor/hl7:representedOrganization" priority="1007" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:agencyFor/hl7:representedOrganization"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@classCode) or @classCode='ORG'"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@classCode) or @classCode='ORG'">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: <axsl:text/>
                  <axsl:value-of select="local-name(../../..)"/>
                  <axsl:text/>/<axsl:text/>
                  <axsl:value-of select="local-name(../..)"/>
                  <axsl:text/>/agencyFor/representedOrganization/@classCode moet, indien aanwezig de waarde "ORG" bevatten</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@determinerCode) or @determinerCode='INSTANCE'"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@determinerCode) or @determinerCode='INSTANCE'">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: <axsl:text/>
                  <axsl:value-of select="local-name(../../..)"/>
                  <axsl:text/>/<axsl:text/>
                  <axsl:value-of select="local-name(../..)"/>
                  <axsl:text/>/agencyFor/representedOrganization/@determinerCode moet, indien aanwezig de waarde "INSTANCE" bevatten</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:id)=1"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id)=1">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: <axsl:text/>
                  <axsl:value-of select="local-name(../../..)"/>
                  <axsl:text/>/<axsl:text/>
                  <axsl:value-of select="local-name(../..)"/>
                  <axsl:text/>/agencyFor/representedOrganization/id mag maar één maal voorkomen</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:agencyFor/hl7:representedOrganization/hl7:name" priority="1006" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:agencyFor/hl7:representedOrganization/hl7:name"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-1-EN: entity name shall be null or text only or element only (no mixed content)</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="*[not(@nullFlavor)][normalize-space(.)='']">
         <svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="*[not(@nullFlavor)][normalize-space(.)='']">
            <axsl:attribute name="role">warning</axsl:attribute>
            <axsl:attribute name="location">
               <axsl:apply-templates select="." mode="schematron-select-full-path"/>
            </axsl:attribute>
            <svrl:text>dtr1-3-EN: empty name particles should not be present.</svrl:text>
         </svrl:successful-report>
      </axsl:if>

		<!--REPORT warning-->

      <axsl:if test="substring(normalize-space(.),1,1)='&#34;'">
         <svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="substring(normalize-space(.),1,1)='&#34;'">
            <axsl:attribute name="role">warning</axsl:attribute>
            <axsl:attribute name="location">
               <axsl:apply-templates select="." mode="schematron-select-full-path"/>
            </axsl:attribute>
            <svrl:text>dtr1-4-EN: Use of quotes at the beginning of a name are probably not correct.</svrl:text>
         </svrl:successful-report>
      </axsl:if>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:family)=0 and count(hl7:given)=0"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family)=0 and count(hl7:given)=0">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-1-ON: no parts may be person name type particles</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(*)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(*)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-2-ON: organization names SHALL be element content</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:agencyFor/hl7:representedOrganization/hl7:telecom" priority="1005" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:agencyFor/hl7:representedOrganization/hl7:telecom"/>
      <axsl:variable name="urlScheme" select="substring-before(@value,':')"/>
      <axsl:variable name="urlStr" select="substring-after(@value,':')"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@value"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-1-URL: elements of type URL SHALL have a @value attribute.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@value=iri-to-uri(@value)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value=iri-to-uri(@value)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-2-URL: @value must be a valid URI, e.g. '<axsl:text/>
                  <axsl:value-of select="iri-to-uri(@value)"/>
                  <axsl:text/>'.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@value"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype URL: Telecom elementen moeten een value attribuut hebben.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@value=iri-to-uri(@value)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value=iri-to-uri(@value)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype URL: Een telecom value moet een geldige URI zijn, bijvoorbeeld '<axsl:text/>
                  <axsl:value-of select="iri-to-uri(@value)"/>
                  <axsl:text/>'.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="urlScheme" select="substring-before(@value,':')"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@value and document('../vocab/URL-urlScheme.xml')/*/hl7:code[@code=$urlScheme]"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value and document('../vocab/URL-urlScheme.xml')/*/hl7:code[@code=$urlScheme]">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype URL: Telecom value moet een in Nederland geldig URL scheme hebben. Gevonden '<axsl:text/>
                  <axsl:value-of select="$urlScheme"/>
                  <axsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="urlStr" select="substring-after(@value,':')"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="if ($urlScheme='tel' or $urlScheme='fax') then (         matches($urlStr,'^(\+?([\d()./-]|(%[a-f\d]{2}))+)*(;(phone-context=((\+?([\d()./-]|(%[a-f\d]{2}))+)|(([a-z\d-]|(%[a-f\d]{2}))+(\.([a-z\d-]|(%[a-f\d]{2}))+)*))|(ext=[\d./-]+)|(isub=(([a-z\d();/?:@&amp;=+$,_.!~*-])|(%[a-f\d]{2}))+)|([a-z\d-]+=([a-z\d\[\]/:&amp;+$_.!~*()-]|(%[a-f\d]{2}))+)))*$')         ) else (1=1)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="if ($urlScheme='tel' or $urlScheme='fax') then ( matches($urlStr,'^(\+?([\d()./-]|(%[a-f\d]{2}))+)*(;(phone-context=((\+?([\d()./-]|(%[a-f\d]{2}))+)|(([a-z\d-]|(%[a-f\d]{2}))+(\.([a-z\d-]|(%[a-f\d]{2}))+)*))|(ext=[\d./-]+)|(isub=(([a-z\d();/?:@&amp;=+$,_.!~*-])|(%[a-f\d]{2}))+)|([a-z\d-]+=([a-z\d\[\]/:&amp;+$_.!~*()-]|(%[a-f\d]{2}))+)))*$') ) else (1=1)">
               <axsl:attribute name="see">http://tools.ietf.org/html/rfc3966</axsl:attribute>
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype URL: URI's met URL Scheme <axsl:text/>
                  <axsl:value-of select="$urlScheme"/>
                  <axsl:text/> moeten voldoen aan RFC 3966</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="if ($urlScheme='file') then (         matches($urlStr,'^///{0,2}((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="if ($urlScheme='file') then ( matches($urlStr,'^///{0,2}((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1)">
               <axsl:attribute name="see">http://tools.ietf.org/html/rfc1738</axsl:attribute>
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype URL: URI's met URL Scheme <axsl:text/>
                  <axsl:value-of select="$urlScheme"/>
                  <axsl:text/> moeten voldoen aan RFC 1738.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="if ($urlScheme='nfs') then (         matches($urlStr,'^//((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))/?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="if ($urlScheme='nfs') then ( matches($urlStr,'^//((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))/?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1)">
               <axsl:attribute name="see">http://tools.ietf.org/html/rfc2224</axsl:attribute>
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype URL: URI's met URL Scheme <axsl:text/>
                  <axsl:value-of select="$urlScheme"/>
                  <axsl:text/> moeten voldoen aan RFC 2224.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="if ($urlScheme='ftp' or $urlScheme='ftps') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;=~_-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z][\w-]*))?)?(/(([a-z\d$\.+!*(),?&amp;_~=-])|(%[a-f\d]{2}))*)*(;type=[aid])?$','i')         ) else (1=1)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="if ($urlScheme='ftp' or $urlScheme='ftps') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;=~_-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z][\w-]*))?)?(/(([a-z\d$\.+!*(),?&amp;_~=-])|(%[a-f\d]{2}))*)*(;type=[aid])?$','i') ) else (1=1)">
               <axsl:attribute name="see">http://tools.ietf.org/html/rfc1738</axsl:attribute>
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype URL: URI's met URL Scheme <axsl:text/>
                  <axsl:value-of select="$urlScheme"/>
                  <axsl:text/> moeten voldoen aan RFC 1738.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="if ($urlScheme='http' or $urlScheme='https') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*(\?(([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*(&amp;((([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*)?)*)?(#([\w~!$+|.,*:=~_]|%[a-f\d]{2})*)?$', 'i')         ) else (1=1)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="if ($urlScheme='http' or $urlScheme='https') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*(\?(([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*(&amp;((([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*)?)*)?(#([\w~!$+|.,*:=~_]|%[a-f\d]{2})*)?$', 'i') ) else (1=1)">
               <axsl:attribute name="see">http://tools.ietf.org/html/rfc1738</axsl:attribute>
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype URL: URI's met URL Scheme <axsl:text/>
                  <axsl:value-of select="$urlScheme"/>
                  <axsl:text/> moeten voldoen aan RFC 1738</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="if ($urlScheme='telnet') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="if ($urlScheme='telnet') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1)">
               <axsl:attribute name="see">http://tools.ietf.org/html/rfc1738</axsl:attribute>
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype URL: URI's met URL Scheme <axsl:text/>
                  <axsl:value-of select="$urlScheme"/>
                  <axsl:text/> moeten voldoen aan RFC 1738.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="if ($urlScheme='mailto') then (         matches($urlStr,'^[\w$\.+!*(),?&amp;~_=-]+(\.[\w$\.+!*(),?&amp;~_=-]+)*@([\w$+!*(),?&amp;~_=-]+\.)+([a-z]{2,4})$','i')         ) else (1=1)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="if ($urlScheme='mailto') then ( matches($urlStr,'^[\w$\.+!*(),?&amp;~_=-]+(\.[\w$\.+!*(),?&amp;~_=-]+)*@([\w$+!*(),?&amp;~_=-]+\.)+([a-z]{2,4})$','i') ) else (1=1)">
               <axsl:attribute name="see">http://tools.ietf.org/html/rfc2368</axsl:attribute>
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype URL: URI's met URL Scheme <axsl:text/>
                  <axsl:value-of select="$urlScheme"/>
                  <axsl:text/> moeten voldoen aan RFC 2368. Merk op dat het niet toegestaan is extra headers op te nemen</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="if ($urlScheme='x-hl7-applicatie') then (         matches($urlStr,'^2\.16\.840\.1\.113883\.2\.4\.6\.6\.[1-9]\d+$')         ) else (1=1)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="if ($urlScheme='x-hl7-applicatie') then ( matches($urlStr,'^2\.16\.840\.1\.113883\.2\.4\.6\.6\.[1-9]\d+$') ) else (1=1)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype URL: URI's met URL Scheme <axsl:text/>
                  <axsl:value-of select="$urlScheme"/>
                  <axsl:text/> moeten beginnen met "2.16.840.1.113883.2.4.6.6." gevolgd door een numeriek deel</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="if ($urlScheme='mllp') then (         matches($urlStr,'^//(([1-2]\d{0,2})(\.([1-2]\d{0,2})){3}|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2}))):(([1-9]\d{0,4})|([A-Za-z]\w*))/$')         ) else (1=1)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="if ($urlScheme='mllp') then ( matches($urlStr,'^//(([1-2]\d{0,2})(\.([1-2]\d{0,2})){3}|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2}))):(([1-9]\d{0,4})|([A-Za-z]\w*))/$') ) else (1=1)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype URL: URI's met URL Scheme <axsl:text/>
                  <axsl:value-of select="$urlScheme"/>
                  <axsl:text/> moeten voldoen aan mllp://host:port/ waarbij 'host' een naam of IP kan zijn en 'port' een benoemde poort of een nummer</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:usablePeriod)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor and hl7:usablePeriod)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-1-TEL: not null and usablePeriod</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:location" priority="1004" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:location"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: <axsl:text/>
                  <axsl:value-of select="local-name(..)"/>
                  <axsl:text/>/device/location mag niet gebruikt worden.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Transmission Wrapper, geen batch MCCI_IN200101</svrl:text>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:processingCode" priority="1002" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:processingCode"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@codeSystem)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@codeSystem)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-2-CS: cannot have codeSystem</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@codeSystemName)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@codeSystemName)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-3-CS: cannot have codeSystemName</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@codeSystemVersion)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@codeSystemVersion)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-4-CS: cannot have codeSystemVersion</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@displayName)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@displayName)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-5-CS: cannot have displayName</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:originalText)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:originalText)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-6-CS: cannot have originalText</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:qualifier)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:qualifier)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-7-CS: cannot have qualifier</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:translation)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-8-CS: cannot have translation</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="@code='P' or document(document-uri(/))/processing-instruction('nictiz')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code='P' or document(document-uri(/))/processing-instruction('nictiz')">
               <axsl:attribute name="role">warning</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: processingCode moet in productie altijd gelijk zijn aan P (productie). D (debug) en T (training) zijn dan niet toegestaan</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@code='P' or @code='T' or @code='D'"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code='P' or @code='T' or @code='D'">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: processingCode moet de waarde P (productie). D (debug) of T (training) bevatten</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:processingModeCode" priority="1001" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:processingModeCode"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@codeSystem)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@codeSystem)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-2-CS: cannot have codeSystem</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@codeSystemName)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@codeSystemName)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-3-CS: cannot have codeSystemName</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@codeSystemVersion)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@codeSystemVersion)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-4-CS: cannot have codeSystemVersion</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@displayName)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@displayName)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-5-CS: cannot have displayName</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:originalText)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:originalText)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-6-CS: cannot have originalText</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:qualifier)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:qualifier)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-7-CS: cannot have qualifier</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:translation)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-8-CS: cannot have translation</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@code='T'"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code='T'">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: processingModeCode moet gelijk zijn aan T (Current processing). A (Archive), I (Initial load), en R (Restore from archive) zijn niet toegestaan</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:acceptAckCode" priority="1000" mode="M4">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:acceptAckCode"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@codeSystem)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@codeSystem)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-2-CS: cannot have codeSystem</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@codeSystemName)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@codeSystemName)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-3-CS: cannot have codeSystemName</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@codeSystemVersion)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@codeSystemVersion)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-4-CS: cannot have codeSystemVersion</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@displayName)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@displayName)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-5-CS: cannot have displayName</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:originalText)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:originalText)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-6-CS: cannot have originalText</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:qualifier)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:qualifier)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-7-CS: cannot have qualifier</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:translation)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-8-CS: cannot have translation</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@code='NE' or @code='AL'"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code='NE' or @code='AL'">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Transmission: acceptAckCode moet gelijk zijn aan NE (never) of AL (always)</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>
   <axsl:template match="text()" priority="-1" mode="M4"/>
   <axsl:template match="@*|node()" priority="-2" mode="M4">
      <axsl:apply-templates select="*" mode="M4"/>
   </axsl:template>

<!--PATTERN -->


	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:profileId" priority="1002" mode="M5">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:profileId"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@nullFlavor or (not(@nullFlavor) and @root)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-1-II: @root is required if @nullFlavor is not present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@root))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-2-II: @root may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-4-II: @identifierName may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@displayable))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-5-II: @displayable may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@reliability))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-6-II: @reliability may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@root) &lt;= 128)">
         <svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(string-length(@root) &lt;= 128)">
            <axsl:attribute name="role">warning</axsl:attribute>
            <axsl:attribute name="location">
               <axsl:apply-templates select="." mode="schematron-select-full-path"/>
            </axsl:attribute>
            <svrl:text>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient</svrl:text>
         </svrl:successful-report>
      </axsl:if>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@extension) &lt;= 64)">
         <svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(string-length(@extension) &lt;= 64)">
            <axsl:attribute name="role">warning</axsl:attribute>
            <axsl:attribute name="location">
               <axsl:apply-templates select="." mode="schematron-select-full-path"/>
            </axsl:attribute>
            <svrl:text>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient</svrl:text>
         </svrl:successful-report>
      </axsl:if>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="codeValue" select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="codeValue" select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: AGB-code moet 8 cijfers lang zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="codeValue" select="@extension"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Datatype II: @extension moet een geldige interactie-id bevatten</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M5"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:acceptAckCode" priority="1001" mode="M5">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:acceptAckCode"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@codeSystem)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@codeSystem)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-2-CS: cannot have codeSystem</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@codeSystemName)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@codeSystemName)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-3-CS: cannot have codeSystemName</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@codeSystemVersion)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@codeSystemVersion)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-4-CS: cannot have codeSystemVersion</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@displayName)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@displayName)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-5-CS: cannot have displayName</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:originalText)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:originalText)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-6-CS: cannot have originalText</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:qualifier)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:qualifier)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-7-CS: cannot have qualifier</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(hl7:translation)">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>dtr1-8-CS: cannot have translation</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@code='NE'"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code='NE'">
               <axsl:attribute name="role">error</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M5"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="hl7:MCCI_IN000002/hl7:attentionLine" priority="1000" mode="M5">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="hl7:MCCI_IN000002/hl7:attentionLine"/>

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)">
               <axsl:attribute name="role">warning</axsl:attribute>
               <axsl:attribute name="location">
                  <axsl:apply-templates select="." mode="schematron-select-full-path"/>
               </axsl:attribute>
               <svrl:text>Het gebruik van attentionLine wordt nog niet gespecificeerd in deze interactie.</svrl:text>
            </svrl:failed-assert>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M5"/>
   </axsl:template>
   <axsl:template match="text()" priority="-1" mode="M5"/>
   <axsl:template match="@*|node()" priority="-2" mode="M5">
      <axsl:apply-templates select="*" mode="M5"/>
   </axsl:template>
</axsl:stylesheet>