<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.66.10.12
Name: VZVZ Opleveren Medicatievoorschriften
Description: Opleveren Medicatievoorschriften: Deze interactie wordt door bronsystemen gebruikt om medicatievoorschriften op te leveren naar aanleiding van een bevraging door het LSP. 
                 Verdere informatie 
            
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000">
   <title>VZVZ Opleveren Medicatievoorschriften</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.12
Context: //hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]
Item: (opleverenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]"
         id="d15e16309-false-d89113e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="count(hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]) &gt;= 1">(opleverenVoorschriftenLijst): element hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject] is required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.12
Context: //hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]
Item: (opleverenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]"
         id="d15e16311-false-d89158e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="string(@moodCode) = ('EVN')">(opleverenVoorschriftenLijst): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.1.18' or @nullFlavor]) &lt;= 1">(opleverenVoorschriftenLijst): element hl7:code[@codeSystem = '2.16.840.1.113883.1.18' or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(opleverenVoorschriftenLijst): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="count(hl7:subject[hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]]) &gt;= 1">(opleverenVoorschriftenLijst): element hl7:subject[hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]] is required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.12
Context: //hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]/hl7:code[@codeSystem = '2.16.840.1.113883.1.18' or @nullFlavor]
Item: (opleverenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]/hl7:code[@codeSystem = '2.16.840.1.113883.1.18' or @nullFlavor]"
         id="d15e16315-false-d89214e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opleverenVoorschriftenLijst): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.1.18')">(opleverenVoorschriftenLijst): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.1.18''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.12
Context: //hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]/hl7:effectiveTime
Item: (opleverenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]/hl7:effectiveTime"
         id="d15e16323-false-d89234e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opleverenVoorschriftenLijst): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="not(*)">(opleverenVoorschriftenLijst): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.12
Context: //hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]/hl7:subject[hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]]
Item: (opleverenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]/hl7:subject[hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]]"
         id="d15e16332-false-d89264e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="count(hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]) &gt;= 1">(opleverenVoorschriftenLijst): element hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']] is required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.12
Context: //hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]/hl7:subject[hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]]/hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]
Item: (opleverenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]/hl7:subject[hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]]/hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]"
         id="d15e16334-false-d89309e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="string(@classCode) = ('LIST') or not(@classCode)">(opleverenVoorschriftenLijst): de waarde van classCode MOET 'LIST' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(opleverenVoorschriftenLijst): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']) &gt;= 1">(opleverenVoorschriftenLijst): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']) &lt;= 1">(opleverenVoorschriftenLijst): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="count(hl7:code[(@code = 'MEDLIST' and @codeSystem = '2.16.840.1.113883.5.4')]) &gt;= 1">(opleverenVoorschriftenLijst): element hl7:code[(@code = 'MEDLIST' and @codeSystem = '2.16.840.1.113883.5.4')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="count(hl7:code[(@code = 'MEDLIST' and @codeSystem = '2.16.840.1.113883.5.4')]) &lt;= 1">(opleverenVoorschriftenLijst): element hl7:code[(@code = 'MEDLIST' and @codeSystem = '2.16.840.1.113883.5.4')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="count(hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patient[@classCode = 'PAT']]) &gt;= 1">(opleverenVoorschriftenLijst): element hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patient[@classCode = 'PAT']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="count(hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patient[@classCode = 'PAT']]) &lt;= 1">(opleverenVoorschriftenLijst): element hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patient[@classCode = 'PAT']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.12
Context: //hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]/hl7:subject[hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]]/hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']
Item: (opleverenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]/hl7:subject[hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]]/hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']"
         id="d15e16345-false-d89392e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opleverenVoorschriftenLijst): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.66.10.12')">(opleverenVoorschriftenLijst): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.66.10.12' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.12
Context: //hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]/hl7:subject[hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]]/hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]/hl7:code[(@code = 'MEDLIST' and @codeSystem = '2.16.840.1.113883.5.4')]
Item: (opleverenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]/hl7:subject[hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]]/hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]/hl7:code[(@code = 'MEDLIST' and @codeSystem = '2.16.840.1.113883.5.4')]"
         id="d15e16358-false-d89411e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opleverenVoorschriftenLijst): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="@nullFlavor or (@code='MEDLIST' and @codeSystem='2.16.840.1.113883.5.4')">(opleverenVoorschriftenLijst): de elementwaarde MOET een zijn van 'code 'MEDLIST' codeSystem '2.16.840.1.113883.5.4''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.12
Context: //hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]/hl7:subject[hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]]/hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patient[@classCode = 'PAT']]
Item: (opleverenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]/hl7:subject[hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]]/hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patient[@classCode = 'PAT']]"
         id="d15e16369-false-d89431e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="string(@typeCode) = ('RCT')">(opleverenVoorschriftenLijst): de waarde van typeCode MOET 'RCT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="string(@contextControlCode) = ('OP')">(opleverenVoorschriftenLijst): de waarde van contextControlCode MOET 'OP' zijn. Gevonden: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="count(hl7:patient[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]) &gt;= 1">(opleverenVoorschriftenLijst): element hl7:patient[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="count(hl7:patient[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]) &lt;= 1">(opleverenVoorschriftenLijst): element hl7:patient[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.12
Context: //hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]/hl7:subject[hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]]/hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patient[@classCode = 'PAT']]/hl7:patient[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]
Item: (opleverenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]/hl7:subject[hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]]/hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patient[@classCode = 'PAT']]/hl7:patient[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]"
         id="d15e16386-false-d89467e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="string(@classCode) = ('PAT')">(opleverenVoorschriftenLijst): de waarde van classCode MOET 'PAT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.4.6.3']) &gt;= 1">(opleverenVoorschriftenLijst): element hl7:id[@root = '2.16.840.1.113883.2.4.6.3'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.4.6.3']) &lt;= 1">(opleverenVoorschriftenLijst): element hl7:id[@root = '2.16.840.1.113883.2.4.6.3'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.12
Context: //hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]/hl7:subject[hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]]/hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patient[@classCode = 'PAT']]/hl7:patient[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:id[@root = '2.16.840.1.113883.2.4.6.3']
Item: (opleverenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]/hl7:subject[hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]]/hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patient[@classCode = 'PAT']]/hl7:patient[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:id[@root = '2.16.840.1.113883.2.4.6.3']"
         id="d15e16401-false-d89497e0">
      <extends rule="II.NL.BSN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opleverenVoorschriftenLijst): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.6.3')">(opleverenVoorschriftenLijst): de waarde van root MOET '2.16.840.1.113883.2.4.6.3' zijn. Gevonden: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="@extension">(opleverenVoorschriftenLijst): attribute @extension MOET aanwezig zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.12
Context: //hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]/hl7:subject[hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]]/hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]/hl7:component[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.204']]]
Item: (opleverenVoorschriftenLijst)
-->
   <rule context="//hl7:QURX_IN990103NL02[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[@moodCode = 'EVN'][hl7:subject]/hl7:subject[hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]]/hl7:MedicationPrescriptionList[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.12']]/hl7:component[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.204']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.12-2014-01-13T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(opleverenVoorschriftenLijst): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
</pattern>
