<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.66.10.13
Name: VZVZ Opvragen Contactverslagen
Description: Opvragen Contactverslagen 
                 Verdere informatie 
            
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000">
   <title>VZVZ Opvragen Contactverslagen</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.13
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]
Item: (opvragenContactverslagen)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]"
         id="d15e16721-false-d96036e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]) &gt;= 1">(opvragenContactverslagen): element hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]) &lt;= 1">(opvragenContactverslagen): element hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9022
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]
Item: (AttentionLineContextCode)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]"
         id="d96068e15-false-d96074e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="count(hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor]) &gt;= 1">(AttentionLineContextCode): element hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="count(hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor]) &lt;= 1">(AttentionLineContextCode): element hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(AttentionLineContextCode): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(AttentionLineContextCode): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9022
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]/hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor]
Item: (AttentionLineContextCode)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]/hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor]"
         id="d96068e17-false-d96115e0">
      <extends rule="SC"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='SC' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AttentionLineContextCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:SC" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="@nullFlavor or not(@code) or (@code='CONTEXT' and @codeSystem='2.16.840.1.113883.2.4.15.1')">(AttentionLineContextCode): de elementwaarde MOET een zijn van 'code 'CONTEXT' codeSystem '2.16.840.1.113883.2.4.15.1''.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="text()='ContextCode'">(AttentionLineContextCode): de elementinhoud van hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor] MOET ''ContextCode'' zijn. Gevonden: "<value-of select="."/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9022
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (AttentionLineContextCode)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d96068e25-false-d96143e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AttentionLineContextCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(AttentionLineContextCode): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.66.11.116 AORTA Context Code (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.13
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]
Item: (opvragenContactverslagen)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]"
         id="d15e16727-false-d96173e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="string(@moodCode) = ('EVN')">(opvragenContactverslagen): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.1.18' or @nullFlavor]) &lt;= 1">(opvragenContactverslagen): element hl7:code[@codeSystem = '2.16.840.1.113883.1.18' or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(opvragenContactverslagen): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:overseer[hl7:assignedEntity]) &gt;= 1">(opvragenContactverslagen): element hl7:overseer[hl7:assignedEntity] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:overseer[hl7:assignedEntity]) &lt;= 1">(opvragenContactverslagen): element hl7:overseer[hl7:assignedEntity] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]) &gt;= 1">(opvragenContactverslagen): element hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]) &lt;= 1">(opvragenContactverslagen): element hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.13
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:code[@codeSystem = '2.16.840.1.113883.1.18' or @nullFlavor]
Item: (opvragenContactverslagen)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:code[@codeSystem = '2.16.840.1.113883.1.18' or @nullFlavor]"
         id="d15e16731-false-d96246e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenContactverslagen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.1.18')">(opvragenContactverslagen): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.1.18''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.13
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:effectiveTime
Item: (opvragenContactverslagen)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:effectiveTime"
         id="d15e16739-false-d96266e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenContactverslagen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="not(*)">(opvragenContactverslagen): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]"
         id="d96277e4-false-d96285e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="string(@typeCode) = ('RESP') or not(@typeCode)">(ControlActOverseerPerson): de waarde van typeCode MOET 'RESP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]) &gt;= 1">(ControlActOverseerPerson): element hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]) &lt;= 1">(ControlActOverseerPerson): element hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]"
         id="d96277e67-false-d96315e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.1']) &gt;= 1">(ControlActOverseerPerson): element hl7:id[@root = '2.16.528.1.1007.3.1'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.1']) &lt;= 1">(ControlActOverseerPerson): element hl7:id[@root = '2.16.528.1.1007.3.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:code[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:code[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:code[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:code[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]) &gt;= 1">(ControlActOverseerPerson): element hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]) &lt;= 1">(ControlActOverseerPerson): element hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:Organization[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:Organization[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:Organization[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:Organization[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:id[@root = '2.16.528.1.1007.3.1']
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:id[@root = '2.16.528.1.1007.3.1']"
         id="d96277e69-false-d96384e0">
      <extends rule="II.NL.UZI"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="string(@root) = ('2.16.528.1.1007.3.1')">(ControlActOverseerPerson): de waarde van root MOET '2.16.528.1.1007.3.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:code[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:code[not(@nullFlavor)]"
         id="d96277e77-false-d96403e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="@codeSystem='2.16.840.1.113883.2.4.15.111' and not(@code='00.000')">(ControlActOverseerPerson): Control Act: / moet een UZI-register rolcode bevatten en deze mag niet 00.000 zijn</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]"
         id="d96277e86-false-d96416e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedPerson[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:assignedPerson[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedPerson[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:assignedPerson[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]"
         id="d96277e88-false-d96440e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]"
         id="d96277e93-false-d96464e0">
      <extends rule="PN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]"
         id="d96277e101-false-d96477e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]) &lt;= 1">(ControlActOverseerPerson): element hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:addr[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:addr[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:addr[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:addr[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]"
         id="d96277e106-false-d96540e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="@root='2.16.528.1.1007.3.3' and @extension">(ControlActOverseerPerson): Control Act: / moet een URA bevatten</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]"
         id="d96277e115-false-d96553e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.2.4.15.1060')">(ControlActOverseerPerson): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.2.4.15.1060''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]"
         id="d96277e123-false-d96573e0">
      <extends rule="ON"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]"
         id="d96277e129-false-d96586e0">
      <extends rule="AD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="hl7:city">(ControlActOverseerPerson): Control Act: / moet tenminste de vestigingsplaats bevatten</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.13
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]
Item: (opvragenContactverslagen)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]"
         id="d15e16750-false-d96603e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:queryId[not(@nullFlavor)]) &gt;= 1">(opvragenContactverslagen): element hl7:queryId[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:queryId[not(@nullFlavor)]) &lt;= 1">(opvragenContactverslagen): element hl7:queryId[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:statusCode[@code = 'executing']) &gt;= 1">(opvragenContactverslagen): element hl7:statusCode[@code = 'executing'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:statusCode[@code = 'executing']) &lt;= 1">(opvragenContactverslagen): element hl7:statusCode[@code = 'executing'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:responseModalityCode[@code = 'R']) &gt;= 1">(opvragenContactverslagen): element hl7:responseModalityCode[@code = 'R'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:responseModalityCode[@code = 'R']) &lt;= 1">(opvragenContactverslagen): element hl7:responseModalityCode[@code = 'R'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:responsePriorityCode[@code = 'I']) &gt;= 1">(opvragenContactverslagen): element hl7:responsePriorityCode[@code = 'I'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:responsePriorityCode[@code = 'I']) &lt;= 1">(opvragenContactverslagen): element hl7:responsePriorityCode[@code = 'I'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:executionAndDeliveryTime[not(@nullFlavor)]) &gt;= 1">(opvragenContactverslagen): element hl7:executionAndDeliveryTime[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:executionAndDeliveryTime[not(@nullFlavor)]) &lt;= 1">(opvragenContactverslagen): element hl7:executionAndDeliveryTime[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]) &gt;= 1">(opvragenContactverslagen): element hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]) &lt;= 1">(opvragenContactverslagen): element hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:effectiveTimeInterval) &lt;= 1">(opvragenContactverslagen): element hl7:effectiveTimeInterval komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']) &gt;= 1">(opvragenContactverslagen): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']) &lt;= 1">(opvragenContactverslagen): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.13
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:queryId[not(@nullFlavor)]
Item: (opvragenContactverslagen)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:queryId[not(@nullFlavor)]"
         id="d15e16752-false-d96738e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenContactverslagen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.13
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:statusCode[@code = 'executing']
Item: (opvragenContactverslagen)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:statusCode[@code = 'executing']"
         id="d15e16763-false-d96751e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenContactverslagen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="@nullFlavor or (@code='executing')">(opvragenContactverslagen): de elementwaarde MOET een zijn van 'code 'executing''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.13
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:responseModalityCode[@code = 'R']
Item: (opvragenContactverslagen)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:responseModalityCode[@code = 'R']"
         id="d15e16776-false-d96771e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenContactverslagen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="@nullFlavor or (@code='R')">(opvragenContactverslagen): de elementwaarde MOET een zijn van 'code 'R''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.13
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:responsePriorityCode[@code = 'I']
Item: (opvragenContactverslagen)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:responsePriorityCode[@code = 'I']"
         id="d15e16789-false-d96791e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenContactverslagen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="@nullFlavor or (@code='I')">(opvragenContactverslagen): de elementwaarde MOET een zijn van 'code 'I''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.13
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:executionAndDeliveryTime[not(@nullFlavor)]
Item: (opvragenContactverslagen)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:executionAndDeliveryTime[not(@nullFlavor)]"
         id="d15e16802-false-d96811e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenContactverslagen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="not(*)">(opvragenContactverslagen): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9035
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]
Item: (kezo-QRYpatientId)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]"
         id="d96822e15-false-d96830e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9035-2015-06-01T000000.html"
              test="count(hl7:value[@root = '2.16.840.1.113883.2.4.6.3']) &gt;= 1">(kezo-QRYpatientId): element hl7:value[@root = '2.16.840.1.113883.2.4.6.3'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9035-2015-06-01T000000.html"
              test="count(hl7:value[@root = '2.16.840.1.113883.2.4.6.3']) &lt;= 1">(kezo-QRYpatientId): element hl7:value[@root = '2.16.840.1.113883.2.4.6.3'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9035
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:value[@root = '2.16.840.1.113883.2.4.6.3']
Item: (kezo-QRYpatientId)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:value[@root = '2.16.840.1.113883.2.4.6.3']"
         id="d96822e20-false-d96854e0">
      <extends rule="II.NL.BSN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9035-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-QRYpatientId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9035-2015-06-01T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.6.3')">(kezo-QRYpatientId): de waarde van root MOET '2.16.840.1.113883.2.4.6.3' zijn. Gevonden: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9035-2015-06-01T000000.html"
              test="@extension">(kezo-QRYpatientId): attribute @extension MOET aanwezig zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9034
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:effectiveTimeInterval
Item: (kezo-QRYeffectiveTimeInterval)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:effectiveTimeInterval"
         id="d96872e31-false-d96880e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="count(hl7:value[not(@nullFlavor)]) &gt;= 1">(kezo-QRYeffectiveTimeInterval): element hl7:value[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="count(hl7:value[not(@nullFlavor)]) &lt;= 1">(kezo-QRYeffectiveTimeInterval): element hl7:value[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9034
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:effectiveTimeInterval/hl7:value[not(@nullFlavor)]
Item: (kezo-QRYeffectiveTimeInterval)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:effectiveTimeInterval/hl7:value[not(@nullFlavor)]"
         id="d96872e39-false-d96904e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-QRYeffectiveTimeInterval): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="not(hl7:low) or string-length(hl7:low/@value)&gt;=12">(kezo-QRYeffectiveTimeInterval): Onder- en bovengrens (low, high) is tot op de minuut te specificeren</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="not(hl7:high) or string-length(hl7:high/@value)&gt;=12">(kezo-QRYeffectiveTimeInterval): Onder- en bovengrens (low, high) is tot op de minuut te specificeren</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="count(hl7:low[not(@nullFlavor)]) &gt;= 1">(kezo-QRYeffectiveTimeInterval): element hl7:low[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="count(hl7:low[not(@nullFlavor)]) &lt;= 1">(kezo-QRYeffectiveTimeInterval): element hl7:low[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="count(hl7:high) &lt;= 1">(kezo-QRYeffectiveTimeInterval): element hl7:high komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9034
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:effectiveTimeInterval/hl7:value[not(@nullFlavor)]/hl7:low[not(@nullFlavor)]
Item: (kezo-QRYeffectiveTimeInterval)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:effectiveTimeInterval/hl7:value[not(@nullFlavor)]/hl7:low[not(@nullFlavor)]"
         id="d96872e44-false-d96941e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-QRYeffectiveTimeInterval): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="not(*)">(kezo-QRYeffectiveTimeInterval): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9034
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:effectiveTimeInterval/hl7:value[not(@nullFlavor)]/hl7:high
Item: (kezo-QRYeffectiveTimeInterval)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:effectiveTimeInterval/hl7:value[not(@nullFlavor)]/hl7:high"
         id="d96872e46-false-d96958e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-QRYeffectiveTimeInterval): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="not(*)">(kezo-QRYeffectiveTimeInterval): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.13
Context: //hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']
Item: (opvragenContactverslagen)
-->

   <rule context="//hl7:REPC_IN990100NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.13']"
         id="d15e16820-false-d96975e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenContactverslagen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.13-2015-06-01T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.66.10.13')">(opvragenContactverslagen): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.66.10.13' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
</pattern>
