<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.66.10.17
Name: VZVZ Opvragen Alerts
Description: Opvragen Alerts 
                 Verdere informatie 
            
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000">
   <title>VZVZ Opvragen Alerts</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.17
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]
Item: (opvragenAlerts)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]"
         id="d15e18020-false-d133739e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]) &gt;= 1">(opvragenAlerts): element hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]) &lt;= 1">(opvragenAlerts): element hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9022
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]
Item: (AttentionLineContextCode)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]"
         id="d133771e15-false-d133777e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="count(hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor]) &gt;= 1">(AttentionLineContextCode): element hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="count(hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor]) &lt;= 1">(AttentionLineContextCode): element hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(AttentionLineContextCode): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(AttentionLineContextCode): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9022
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]/hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor]
Item: (AttentionLineContextCode)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]/hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor]"
         id="d133771e17-false-d133818e0">
      <extends rule="SC"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='SC' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AttentionLineContextCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:SC" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="@nullFlavor or not(@code) or (@code='CONTEXT' and @codeSystem='2.16.840.1.113883.2.4.15.1')">(AttentionLineContextCode): de elementwaarde MOET een zijn van 'code 'CONTEXT' codeSystem '2.16.840.1.113883.2.4.15.1''.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="text()='ContextCode'">(AttentionLineContextCode): de elementinhoud van hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor] MOET ''ContextCode'' zijn. Gevonden: "<value-of select="."/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9022
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (AttentionLineContextCode)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d133771e25-false-d133846e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AttentionLineContextCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(AttentionLineContextCode): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.66.11.116 AORTA Context Code (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.17
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]
Item: (opvragenAlerts)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]"
         id="d15e18026-false-d133876e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="string(@moodCode) = ('EVN')">(opvragenAlerts): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.1.18' or @nullFlavor]) &lt;= 1">(opvragenAlerts): element hl7:code[@codeSystem = '2.16.840.1.113883.1.18' or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(opvragenAlerts): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:overseer[hl7:assignedEntity]) &gt;= 1">(opvragenAlerts): element hl7:overseer[hl7:assignedEntity] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:overseer[hl7:assignedEntity]) &lt;= 1">(opvragenAlerts): element hl7:overseer[hl7:assignedEntity] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]) &gt;= 1">(opvragenAlerts): element hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]) &lt;= 1">(opvragenAlerts): element hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.17
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:code[@codeSystem = '2.16.840.1.113883.1.18' or @nullFlavor]
Item: (opvragenAlerts)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:code[@codeSystem = '2.16.840.1.113883.1.18' or @nullFlavor]"
         id="d15e18030-false-d133949e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenAlerts): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.1.18')">(opvragenAlerts): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.1.18''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.17
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:effectiveTime
Item: (opvragenAlerts)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:effectiveTime"
         id="d15e18038-false-d133969e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenAlerts): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="not(*)">(opvragenAlerts): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]"
         id="d133980e4-false-d133988e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="string(@typeCode) = ('RESP') or not(@typeCode)">(ControlActOverseerPerson): de waarde van typeCode MOET 'RESP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]) &gt;= 1">(ControlActOverseerPerson): element hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]) &lt;= 1">(ControlActOverseerPerson): element hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]"
         id="d133980e67-false-d134018e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.1']) &gt;= 1">(ControlActOverseerPerson): element hl7:id[@root = '2.16.528.1.1007.3.1'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.1']) &lt;= 1">(ControlActOverseerPerson): element hl7:id[@root = '2.16.528.1.1007.3.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:code[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:code[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:code[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:code[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]) &gt;= 1">(ControlActOverseerPerson): element hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]) &lt;= 1">(ControlActOverseerPerson): element hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:Organization[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:Organization[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:Organization[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:Organization[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:id[@root = '2.16.528.1.1007.3.1']
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:id[@root = '2.16.528.1.1007.3.1']"
         id="d133980e69-false-d134087e0">
      <extends rule="II.NL.UZI"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="string(@root) = ('2.16.528.1.1007.3.1')">(ControlActOverseerPerson): de waarde van root MOET '2.16.528.1.1007.3.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:code[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:code[not(@nullFlavor)]"
         id="d133980e77-false-d134106e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="@codeSystem='2.16.840.1.113883.2.4.15.111' and not(@code='00.000')">(ControlActOverseerPerson): Control Act: / moet een UZI-register rolcode bevatten en deze mag niet 00.000 zijn</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]"
         id="d133980e86-false-d134119e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedPerson[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:assignedPerson[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedPerson[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:assignedPerson[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]"
         id="d133980e88-false-d134143e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]"
         id="d133980e93-false-d134167e0">
      <extends rule="PN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]"
         id="d133980e101-false-d134180e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]) &lt;= 1">(ControlActOverseerPerson): element hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:addr[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:addr[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:addr[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:addr[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]"
         id="d133980e106-false-d134243e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="@root='2.16.528.1.1007.3.3' and @extension">(ControlActOverseerPerson): Control Act: / moet een URA bevatten</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]"
         id="d133980e115-false-d134256e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.2.4.15.1060')">(ControlActOverseerPerson): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.2.4.15.1060''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]"
         id="d133980e123-false-d134276e0">
      <extends rule="ON"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]"
         id="d133980e129-false-d134289e0">
      <extends rule="AD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="hl7:city">(ControlActOverseerPerson): Control Act: / moet tenminste de vestigingsplaats bevatten</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.17
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]
Item: (opvragenAlerts)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]"
         id="d15e18049-false-d134306e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:queryId[not(@nullFlavor)]) &gt;= 1">(opvragenAlerts): element hl7:queryId[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:queryId[not(@nullFlavor)]) &lt;= 1">(opvragenAlerts): element hl7:queryId[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:statusCode[@code = 'executing']) &gt;= 1">(opvragenAlerts): element hl7:statusCode[@code = 'executing'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:statusCode[@code = 'executing']) &lt;= 1">(opvragenAlerts): element hl7:statusCode[@code = 'executing'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:responseModalityCode[@code = 'R']) &gt;= 1">(opvragenAlerts): element hl7:responseModalityCode[@code = 'R'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:responseModalityCode[@code = 'R']) &lt;= 1">(opvragenAlerts): element hl7:responseModalityCode[@code = 'R'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:responsePriorityCode[@code = 'I']) &gt;= 1">(opvragenAlerts): element hl7:responsePriorityCode[@code = 'I'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:responsePriorityCode[@code = 'I']) &lt;= 1">(opvragenAlerts): element hl7:responsePriorityCode[@code = 'I'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:executionAndDeliveryTime[not(@nullFlavor)]) &gt;= 1">(opvragenAlerts): element hl7:executionAndDeliveryTime[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:executionAndDeliveryTime[not(@nullFlavor)]) &lt;= 1">(opvragenAlerts): element hl7:executionAndDeliveryTime[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]) &gt;= 1">(opvragenAlerts): element hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]) &lt;= 1">(opvragenAlerts): element hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:effectiveTimeInterval) &lt;= 1">(opvragenAlerts): element hl7:effectiveTimeInterval komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']) &gt;= 1">(opvragenAlerts): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']) &lt;= 1">(opvragenAlerts): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.17
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:queryId[not(@nullFlavor)]
Item: (opvragenAlerts)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:queryId[not(@nullFlavor)]"
         id="d15e18051-false-d134441e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenAlerts): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.17
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:statusCode[@code = 'executing']
Item: (opvragenAlerts)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:statusCode[@code = 'executing']"
         id="d15e18062-false-d134454e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenAlerts): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="@nullFlavor or (@code='executing')">(opvragenAlerts): de elementwaarde MOET een zijn van 'code 'executing''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.17
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:responseModalityCode[@code = 'R']
Item: (opvragenAlerts)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:responseModalityCode[@code = 'R']"
         id="d15e18075-false-d134474e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenAlerts): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="@nullFlavor or (@code='R')">(opvragenAlerts): de elementwaarde MOET een zijn van 'code 'R''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.17
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:responsePriorityCode[@code = 'I']
Item: (opvragenAlerts)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:responsePriorityCode[@code = 'I']"
         id="d15e18088-false-d134494e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenAlerts): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="@nullFlavor or (@code='I')">(opvragenAlerts): de elementwaarde MOET een zijn van 'code 'I''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.17
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:executionAndDeliveryTime[not(@nullFlavor)]
Item: (opvragenAlerts)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:executionAndDeliveryTime[not(@nullFlavor)]"
         id="d15e18101-false-d134514e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenAlerts): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="not(*)">(opvragenAlerts): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9035
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]
Item: (kezo-QRYpatientId)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]"
         id="d134525e15-false-d134533e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9035-2015-06-01T000000.html"
              test="count(hl7:value[@root = '2.16.840.1.113883.2.4.6.3']) &gt;= 1">(kezo-QRYpatientId): element hl7:value[@root = '2.16.840.1.113883.2.4.6.3'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9035-2015-06-01T000000.html"
              test="count(hl7:value[@root = '2.16.840.1.113883.2.4.6.3']) &lt;= 1">(kezo-QRYpatientId): element hl7:value[@root = '2.16.840.1.113883.2.4.6.3'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9035
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:value[@root = '2.16.840.1.113883.2.4.6.3']
Item: (kezo-QRYpatientId)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:value[@root = '2.16.840.1.113883.2.4.6.3']"
         id="d134525e20-false-d134557e0">
      <extends rule="II.NL.BSN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9035-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-QRYpatientId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9035-2015-06-01T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.6.3')">(kezo-QRYpatientId): de waarde van root MOET '2.16.840.1.113883.2.4.6.3' zijn. Gevonden: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9035-2015-06-01T000000.html"
              test="@extension">(kezo-QRYpatientId): attribute @extension MOET aanwezig zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9034
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:effectiveTimeInterval
Item: (kezo-QRYeffectiveTimeInterval)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:effectiveTimeInterval"
         id="d134575e31-false-d134583e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="count(hl7:value[not(@nullFlavor)]) &gt;= 1">(kezo-QRYeffectiveTimeInterval): element hl7:value[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="count(hl7:value[not(@nullFlavor)]) &lt;= 1">(kezo-QRYeffectiveTimeInterval): element hl7:value[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9034
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:effectiveTimeInterval/hl7:value[not(@nullFlavor)]
Item: (kezo-QRYeffectiveTimeInterval)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:effectiveTimeInterval/hl7:value[not(@nullFlavor)]"
         id="d134575e39-false-d134607e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-QRYeffectiveTimeInterval): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="not(hl7:low) or string-length(hl7:low/@value)&gt;=12">(kezo-QRYeffectiveTimeInterval): Onder- en bovengrens (low, high) is tot op de minuut te specificeren</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="not(hl7:high) or string-length(hl7:high/@value)&gt;=12">(kezo-QRYeffectiveTimeInterval): Onder- en bovengrens (low, high) is tot op de minuut te specificeren</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="count(hl7:low[not(@nullFlavor)]) &gt;= 1">(kezo-QRYeffectiveTimeInterval): element hl7:low[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="count(hl7:low[not(@nullFlavor)]) &lt;= 1">(kezo-QRYeffectiveTimeInterval): element hl7:low[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="count(hl7:high) &lt;= 1">(kezo-QRYeffectiveTimeInterval): element hl7:high komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9034
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:effectiveTimeInterval/hl7:value[not(@nullFlavor)]/hl7:low[not(@nullFlavor)]
Item: (kezo-QRYeffectiveTimeInterval)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:effectiveTimeInterval/hl7:value[not(@nullFlavor)]/hl7:low[not(@nullFlavor)]"
         id="d134575e44-false-d134644e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-QRYeffectiveTimeInterval): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="not(*)">(kezo-QRYeffectiveTimeInterval): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9034
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:effectiveTimeInterval/hl7:value[not(@nullFlavor)]/hl7:high
Item: (kezo-QRYeffectiveTimeInterval)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:effectiveTimeInterval/hl7:value[not(@nullFlavor)]/hl7:high"
         id="d134575e46-false-d134661e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-QRYeffectiveTimeInterval): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="not(*)">(kezo-QRYeffectiveTimeInterval): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.17
Context: //hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']
Item: (opvragenAlerts)
-->

   <rule context="//hl7:REPC_IN990120NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.17']"
         id="d15e18119-false-d134678e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenAlerts): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.17-2015-06-01T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.66.10.17')">(opvragenAlerts): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.66.10.17' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
</pattern>
