<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.66.10.19
Name: VZVZ Opvragen Allergie intoleranties
Description: Opvragen Allergie intoleranties 
                 Verdere informatie 
            
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000">
   <title>VZVZ Opvragen Allergie intoleranties</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.19
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]
Item: (opvragenAllergieintoleranties)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]"
         id="d15e18637-false-d150962e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]) &gt;= 1">(opvragenAllergieintoleranties): element hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]) &lt;= 1">(opvragenAllergieintoleranties): element hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9022
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]
Item: (AttentionLineContextCode)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]"
         id="d150994e15-false-d151000e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="count(hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor]) &gt;= 1">(AttentionLineContextCode): element hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="count(hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor]) &lt;= 1">(AttentionLineContextCode): element hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(AttentionLineContextCode): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(AttentionLineContextCode): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9022
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]/hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor]
Item: (AttentionLineContextCode)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]/hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor]"
         id="d150994e17-false-d151041e0">
      <extends rule="SC"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='SC' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AttentionLineContextCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:SC" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="@nullFlavor or not(@code) or (@code='CONTEXT' and @codeSystem='2.16.840.1.113883.2.4.15.1')">(AttentionLineContextCode): de elementwaarde MOET een zijn van 'code 'CONTEXT' codeSystem '2.16.840.1.113883.2.4.15.1''.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="text()='ContextCode'">(AttentionLineContextCode): de elementinhoud van hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor] MOET ''ContextCode'' zijn. Gevonden: "<value-of select="."/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9022
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (AttentionLineContextCode)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d150994e25-false-d151069e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AttentionLineContextCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(AttentionLineContextCode): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.66.11.116 AORTA Context Code (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.19
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]
Item: (opvragenAllergieintoleranties)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]"
         id="d15e18643-false-d151099e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="string(@moodCode) = ('EVN')">(opvragenAllergieintoleranties): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.1.18' or @nullFlavor]) &lt;= 1">(opvragenAllergieintoleranties): element hl7:code[@codeSystem = '2.16.840.1.113883.1.18' or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(opvragenAllergieintoleranties): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:overseer[hl7:assignedEntity]) &gt;= 1">(opvragenAllergieintoleranties): element hl7:overseer[hl7:assignedEntity] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:overseer[hl7:assignedEntity]) &lt;= 1">(opvragenAllergieintoleranties): element hl7:overseer[hl7:assignedEntity] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]) &gt;= 1">(opvragenAllergieintoleranties): element hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]) &lt;= 1">(opvragenAllergieintoleranties): element hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.19
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:code[@codeSystem = '2.16.840.1.113883.1.18' or @nullFlavor]
Item: (opvragenAllergieintoleranties)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:code[@codeSystem = '2.16.840.1.113883.1.18' or @nullFlavor]"
         id="d15e18647-false-d151172e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenAllergieintoleranties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.1.18')">(opvragenAllergieintoleranties): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.1.18''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.19
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:effectiveTime
Item: (opvragenAllergieintoleranties)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:effectiveTime"
         id="d15e18655-false-d151192e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenAllergieintoleranties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="not(*)">(opvragenAllergieintoleranties): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]"
         id="d151203e4-false-d151211e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="string(@typeCode) = ('RESP') or not(@typeCode)">(ControlActOverseerPerson): de waarde van typeCode MOET 'RESP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]) &gt;= 1">(ControlActOverseerPerson): element hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]) &lt;= 1">(ControlActOverseerPerson): element hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]"
         id="d151203e67-false-d151241e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.1']) &gt;= 1">(ControlActOverseerPerson): element hl7:id[@root = '2.16.528.1.1007.3.1'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.1']) &lt;= 1">(ControlActOverseerPerson): element hl7:id[@root = '2.16.528.1.1007.3.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:code[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:code[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:code[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:code[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]) &gt;= 1">(ControlActOverseerPerson): element hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]) &lt;= 1">(ControlActOverseerPerson): element hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:Organization[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:Organization[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:Organization[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:Organization[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:id[@root = '2.16.528.1.1007.3.1']
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:id[@root = '2.16.528.1.1007.3.1']"
         id="d151203e69-false-d151310e0">
      <extends rule="II.NL.UZI"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="string(@root) = ('2.16.528.1.1007.3.1')">(ControlActOverseerPerson): de waarde van root MOET '2.16.528.1.1007.3.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:code[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:code[not(@nullFlavor)]"
         id="d151203e77-false-d151329e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="@codeSystem='2.16.840.1.113883.2.4.15.111' and not(@code='00.000')">(ControlActOverseerPerson): Control Act: / moet een UZI-register rolcode bevatten en deze mag niet 00.000 zijn</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]"
         id="d151203e86-false-d151342e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedPerson[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:assignedPerson[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedPerson[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:assignedPerson[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]"
         id="d151203e88-false-d151366e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]"
         id="d151203e93-false-d151390e0">
      <extends rule="PN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]"
         id="d151203e101-false-d151403e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]) &lt;= 1">(ControlActOverseerPerson): element hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:addr[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:addr[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:addr[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:addr[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]"
         id="d151203e106-false-d151466e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="@root='2.16.528.1.1007.3.3' and @extension">(ControlActOverseerPerson): Control Act: / moet een URA bevatten</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]"
         id="d151203e115-false-d151479e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.2.4.15.1060')">(ControlActOverseerPerson): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.2.4.15.1060''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]"
         id="d151203e123-false-d151499e0">
      <extends rule="ON"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]"
         id="d151203e129-false-d151512e0">
      <extends rule="AD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="hl7:city">(ControlActOverseerPerson): Control Act: / moet tenminste de vestigingsplaats bevatten</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.19
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]
Item: (opvragenAllergieintoleranties)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]"
         id="d15e18666-false-d151529e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:queryId[not(@nullFlavor)]) &gt;= 1">(opvragenAllergieintoleranties): element hl7:queryId[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:queryId[not(@nullFlavor)]) &lt;= 1">(opvragenAllergieintoleranties): element hl7:queryId[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:statusCode[@code = 'executing']) &gt;= 1">(opvragenAllergieintoleranties): element hl7:statusCode[@code = 'executing'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:statusCode[@code = 'executing']) &lt;= 1">(opvragenAllergieintoleranties): element hl7:statusCode[@code = 'executing'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:responseModalityCode[@code = 'R']) &gt;= 1">(opvragenAllergieintoleranties): element hl7:responseModalityCode[@code = 'R'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:responseModalityCode[@code = 'R']) &lt;= 1">(opvragenAllergieintoleranties): element hl7:responseModalityCode[@code = 'R'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:responsePriorityCode[@code = 'I']) &gt;= 1">(opvragenAllergieintoleranties): element hl7:responsePriorityCode[@code = 'I'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:responsePriorityCode[@code = 'I']) &lt;= 1">(opvragenAllergieintoleranties): element hl7:responsePriorityCode[@code = 'I'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:executionAndDeliveryTime[not(@nullFlavor)]) &gt;= 1">(opvragenAllergieintoleranties): element hl7:executionAndDeliveryTime[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:executionAndDeliveryTime[not(@nullFlavor)]) &lt;= 1">(opvragenAllergieintoleranties): element hl7:executionAndDeliveryTime[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]) &gt;= 1">(opvragenAllergieintoleranties): element hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]) &lt;= 1">(opvragenAllergieintoleranties): element hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:effectiveTimeInterval) &lt;= 1">(opvragenAllergieintoleranties): element hl7:effectiveTimeInterval komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']) &gt;= 1">(opvragenAllergieintoleranties): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']) &lt;= 1">(opvragenAllergieintoleranties): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.19
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:queryId[not(@nullFlavor)]
Item: (opvragenAllergieintoleranties)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:queryId[not(@nullFlavor)]"
         id="d15e18668-false-d151664e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenAllergieintoleranties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.19
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:statusCode[@code = 'executing']
Item: (opvragenAllergieintoleranties)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:statusCode[@code = 'executing']"
         id="d15e18679-false-d151677e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenAllergieintoleranties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="@nullFlavor or (@code='executing')">(opvragenAllergieintoleranties): de elementwaarde MOET een zijn van 'code 'executing''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.19
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:responseModalityCode[@code = 'R']
Item: (opvragenAllergieintoleranties)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:responseModalityCode[@code = 'R']"
         id="d15e18692-false-d151697e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenAllergieintoleranties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="@nullFlavor or (@code='R')">(opvragenAllergieintoleranties): de elementwaarde MOET een zijn van 'code 'R''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.19
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:responsePriorityCode[@code = 'I']
Item: (opvragenAllergieintoleranties)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:responsePriorityCode[@code = 'I']"
         id="d15e18705-false-d151717e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenAllergieintoleranties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="@nullFlavor or (@code='I')">(opvragenAllergieintoleranties): de elementwaarde MOET een zijn van 'code 'I''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.19
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:executionAndDeliveryTime[not(@nullFlavor)]
Item: (opvragenAllergieintoleranties)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:executionAndDeliveryTime[not(@nullFlavor)]"
         id="d15e18718-false-d151737e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenAllergieintoleranties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="not(*)">(opvragenAllergieintoleranties): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9035
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]
Item: (kezo-QRYpatientId)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]"
         id="d151748e15-false-d151756e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9035-2015-06-01T000000.html"
              test="count(hl7:value[@root = '2.16.840.1.113883.2.4.6.3']) &gt;= 1">(kezo-QRYpatientId): element hl7:value[@root = '2.16.840.1.113883.2.4.6.3'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9035-2015-06-01T000000.html"
              test="count(hl7:value[@root = '2.16.840.1.113883.2.4.6.3']) &lt;= 1">(kezo-QRYpatientId): element hl7:value[@root = '2.16.840.1.113883.2.4.6.3'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9035
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:value[@root = '2.16.840.1.113883.2.4.6.3']
Item: (kezo-QRYpatientId)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:value[@root = '2.16.840.1.113883.2.4.6.3']"
         id="d151748e20-false-d151780e0">
      <extends rule="II.NL.BSN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9035-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-QRYpatientId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9035-2015-06-01T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.6.3')">(kezo-QRYpatientId): de waarde van root MOET '2.16.840.1.113883.2.4.6.3' zijn. Gevonden: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9035-2015-06-01T000000.html"
              test="@extension">(kezo-QRYpatientId): attribute @extension MOET aanwezig zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9034
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:effectiveTimeInterval
Item: (kezo-QRYeffectiveTimeInterval)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:effectiveTimeInterval"
         id="d151798e31-false-d151806e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="count(hl7:value[not(@nullFlavor)]) &gt;= 1">(kezo-QRYeffectiveTimeInterval): element hl7:value[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="count(hl7:value[not(@nullFlavor)]) &lt;= 1">(kezo-QRYeffectiveTimeInterval): element hl7:value[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9034
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:effectiveTimeInterval/hl7:value[not(@nullFlavor)]
Item: (kezo-QRYeffectiveTimeInterval)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:effectiveTimeInterval/hl7:value[not(@nullFlavor)]"
         id="d151798e39-false-d151830e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-QRYeffectiveTimeInterval): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="not(hl7:low) or string-length(hl7:low/@value)&gt;=12">(kezo-QRYeffectiveTimeInterval): Onder- en bovengrens (low, high) is tot op de minuut te specificeren</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="not(hl7:high) or string-length(hl7:high/@value)&gt;=12">(kezo-QRYeffectiveTimeInterval): Onder- en bovengrens (low, high) is tot op de minuut te specificeren</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="count(hl7:low[not(@nullFlavor)]) &gt;= 1">(kezo-QRYeffectiveTimeInterval): element hl7:low[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="count(hl7:low[not(@nullFlavor)]) &lt;= 1">(kezo-QRYeffectiveTimeInterval): element hl7:low[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="count(hl7:high) &lt;= 1">(kezo-QRYeffectiveTimeInterval): element hl7:high komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9034
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:effectiveTimeInterval/hl7:value[not(@nullFlavor)]/hl7:low[not(@nullFlavor)]
Item: (kezo-QRYeffectiveTimeInterval)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:effectiveTimeInterval/hl7:value[not(@nullFlavor)]/hl7:low[not(@nullFlavor)]"
         id="d151798e44-false-d151867e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-QRYeffectiveTimeInterval): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="not(*)">(kezo-QRYeffectiveTimeInterval): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9034
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:effectiveTimeInterval/hl7:value[not(@nullFlavor)]/hl7:high
Item: (kezo-QRYeffectiveTimeInterval)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:effectiveTimeInterval/hl7:value[not(@nullFlavor)]/hl7:high"
         id="d151798e46-false-d151884e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-QRYeffectiveTimeInterval): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9034-2015-06-01T000000.html"
              test="not(*)">(kezo-QRYeffectiveTimeInterval): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.19
Context: //hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']
Item: (opvragenAllergieintoleranties)
-->

   <rule context="//hl7:REPC_IN990130NL[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.19']"
         id="d15e18736-false-d151901e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenAllergieintoleranties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.19-2015-06-01T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.66.10.19')">(opvragenAllergieintoleranties): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.66.10.19' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
</pattern>
