<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.66.10.205
Name: KEZO Indicatie Diagnose
Description: Indicatie: reden voor een activiteit als diagnose
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000">
   <title>KEZO Indicatie Diagnose</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.205
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]]
Item: (kezo-IndicatieDiagnose)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]]"
         id="d15e21232-false-d184985e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]) &gt;= 1">(kezo-IndicatieDiagnose): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]) &lt;= 1">(kezo-IndicatieDiagnose): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.205
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]
Item: (kezo-IndicatieDiagnose)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]"
         id="d15e21267-false-d185008e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="string(@classCode) = ('OBS')">(kezo-IndicatieDiagnose): de waarde van classCode MOET 'OBS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="string(@moodCode) = ('EVN')">(kezo-IndicatieDiagnose): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']) &gt;= 1">(kezo-IndicatieDiagnose): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']) &lt;= 1">(kezo-IndicatieDiagnose): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="count(hl7:id) &lt;= 1">(kezo-IndicatieDiagnose): element hl7:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="count(hl7:code[(@code = '282291009' and @codeSystem = '2.16.840.1.113883.6.96')]) &gt;= 1">(kezo-IndicatieDiagnose): element hl7:code[(@code = '282291009' and @codeSystem = '2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="count(hl7:code[(@code = '282291009' and @codeSystem = '2.16.840.1.113883.6.96')]) &lt;= 1">(kezo-IndicatieDiagnose): element hl7:code[(@code = '282291009' and @codeSystem = '2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(kezo-IndicatieDiagnose): element hl7:statusCode[@code = 'completed'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(kezo-IndicatieDiagnose): element hl7:statusCode[@code = 'completed'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(kezo-IndicatieDiagnose): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="count(hl7:value) &gt;= 1">(kezo-IndicatieDiagnose): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="count(hl7:value) &lt;= 1">(kezo-IndicatieDiagnose): element hl7:value komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.205
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']
Item: (kezo-IndicatieDiagnose)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']"
         id="d15e21273-false-d185107e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-IndicatieDiagnose): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.66.10.205')">(kezo-IndicatieDiagnose): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.66.10.205' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.205
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]/hl7:id
Item: (kezo-IndicatieDiagnose)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.205
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]/hl7:code[(@code = '282291009' and @codeSystem = '2.16.840.1.113883.6.96')]
Item: (kezo-IndicatieDiagnose)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]/hl7:code[(@code = '282291009' and @codeSystem = '2.16.840.1.113883.6.96')]"
         id="d15e21280-false-d185135e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="@nullFlavor or (@code='282291009' and @codeSystem='2.16.840.1.113883.6.96' and @displayName='Diagnosis')">(kezo-IndicatieDiagnose): de elementwaarde MOET een zijn van 'code '282291009' codeSystem '2.16.840.1.113883.6.96' displayName='Diagnosis''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.205
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]/hl7:statusCode[@code = 'completed']
Item: (kezo-IndicatieDiagnose)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]/hl7:statusCode[@code = 'completed']"
         id="d15e21286-false-d185151e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-IndicatieDiagnose): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="@nullFlavor or (@code='completed')">(kezo-IndicatieDiagnose): de elementwaarde MOET een zijn van 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.205
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]/hl7:effectiveTime
Item: (kezo-IndicatieDiagnose)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]/hl7:effectiveTime"
         id="d15e21291-false-d185171e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-IndicatieDiagnose): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="not(*)">(kezo-IndicatieDiagnose): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.205
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]/hl7:value
Item: (kezo-IndicatieDiagnose)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.205']]/hl7:value"
         id="d15e21293-false-d185188e0">
      <extends rule="CD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-IndicatieDiagnose): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="warning"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.205-2014-04-30T000000.html"
              test="not(@codeSystem='2.16.840.1.113883.2.4.4.31.1') or not(ends-with(@code,'.00'))">(kezo-IndicatieDiagnose): ICPC-1-2000NL codes met uitgang .00 zijn vervallen.</assert>
   </rule>
</pattern>
