<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.66.10.218
Name: KEZO Criticality Observatie
Description: Criticality / Mate van kritiek zijn
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000">
   <title>KEZO Criticality Observatie</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.218
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]
Item: (kezo-Criticalityobservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]"
         id="d15e23219-false-d205842e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]) &gt;= 1">(kezo-Criticalityobservation): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]) &lt;= 1">(kezo-Criticalityobservation): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.218
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]
Item: (kezo-Criticalityobservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]"
         id="d15e23249-false-d205865e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000.html"
              test="string(@classCode) = ('OBS')">(kezo-Criticalityobservation): de waarde van classCode MOET 'OBS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000.html"
              test="string(@moodCode) = ('EVN')">(kezo-Criticalityobservation): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']) &gt;= 1">(kezo-Criticalityobservation): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']) &lt;= 1">(kezo-Criticalityobservation): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000.html"
              test="count(hl7:code[(@code = 'CRIT' and @codeSystem = '2.16.840.1.113883.5.4')]) &gt;= 1">(kezo-Criticalityobservation): element hl7:code[(@code = 'CRIT' and @codeSystem = '2.16.840.1.113883.5.4')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000.html"
              test="count(hl7:code[(@code = 'CRIT' and @codeSystem = '2.16.840.1.113883.5.4')]) &lt;= 1">(kezo-Criticalityobservation): element hl7:code[(@code = 'CRIT' and @codeSystem = '2.16.840.1.113883.5.4')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(kezo-Criticalityobservation): element hl7:statusCode[@code = 'completed'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(kezo-Criticalityobservation): element hl7:statusCode[@code = 'completed'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.8.2.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(kezo-Criticalityobservation): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.8.2.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.8.2.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(kezo-Criticalityobservation): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.8.2.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.218
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']
Item: (kezo-Criticalityobservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']"
         id="d15e23255-false-d205948e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-Criticalityobservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.66.10.218')">(kezo-Criticalityobservation): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.66.10.218' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.218
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]/hl7:code[(@code = 'CRIT' and @codeSystem = '2.16.840.1.113883.5.4')]
Item: (kezo-Criticalityobservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]/hl7:code[(@code = 'CRIT' and @codeSystem = '2.16.840.1.113883.5.4')]"
         id="d15e23260-false-d205967e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-Criticalityobservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000.html"
              test="@nullFlavor or (@code='CRIT' and @codeSystem='2.16.840.1.113883.5.4')">(kezo-Criticalityobservation): de elementwaarde MOET een zijn van 'code 'CRIT' codeSystem '2.16.840.1.113883.5.4''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.218
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]/hl7:statusCode[@code = 'completed']
Item: (kezo-Criticalityobservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]/hl7:statusCode[@code = 'completed']"
         id="d15e23268-false-d205987e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-Criticalityobservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000.html"
              test="@nullFlavor or (@code='completed')">(kezo-Criticalityobservation): de elementwaarde MOET een zijn van 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.218
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.8.2.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (kezo-Criticalityobservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.8.2.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d15e23273-false-d206009e0">
      <extends rule="CD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-Criticalityobservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-07-15T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.8.2.4-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(kezo-Criticalityobservation): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.40.2.8.2.4 MateVanKritiekZijnCodelijst (DYNAMISCH)'.</assert>
   </rule>
</pattern>
