<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.66.10.301
Name: KEZO Clinical Information Section
Description: A section containing clinical details about the case such as presenting signs and symptoms, onset date of symptoms, the specific diagnosis/condition names (e.g Ulceroglandular tularemia), who made the diagnosis, their contact information, when the diagnosis was made etc., past clinical hx, the overall condition of the patient, etc.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.11.60.66.10.301-2014-06-27T000000">
   <title>KEZO Clinical Information Section</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.301
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]]
Item: (kezo-ClinicalInformation)
-->

   <rule context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]]"
         id="d15e24096-false-d219759e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.301-2014-06-27T000000.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]) &gt;= 1">(kezo-ClinicalInformation): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.301-2014-06-27T000000.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]) &lt;= 1">(kezo-ClinicalInformation): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.301
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]
Item: (kezo-ClinicalInformation)
-->

   <rule context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]"
         id="d15e24124-false-d219782e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.301-2014-06-27T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']) &gt;= 1">(kezo-ClinicalInformation): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.301-2014-06-27T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']) &lt;= 1">(kezo-ClinicalInformation): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.301-2014-06-27T000000.html"
              test="count(hl7:code[(@code = '55752-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(kezo-ClinicalInformation): element hl7:code[(@code = '55752-0' and @codeSystem = '2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.301-2014-06-27T000000.html"
              test="count(hl7:code[(@code = '55752-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(kezo-ClinicalInformation): element hl7:code[(@code = '55752-0' and @codeSystem = '2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.301-2014-06-27T000000.html"
              test="count(hl7:title) &lt;= 1">(kezo-ClinicalInformation): element hl7:title komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.301-2014-06-27T000000.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(kezo-ClinicalInformation): element hl7:text[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.301-2014-06-27T000000.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(kezo-ClinicalInformation): element hl7:text[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.301
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']
Item: (kezo-ClinicalInformation)
-->

   <rule context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']"
         id="d15e24126-false-d219845e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.301-2014-06-27T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.66.10.301')">(kezo-ClinicalInformation): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.66.10.301' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.301
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]/hl7:code[(@code = '55752-0' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (kezo-ClinicalInformation)
-->

   <rule context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]/hl7:code[(@code = '55752-0' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d15e24131-false-d219860e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.301-2014-06-27T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-ClinicalInformation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.301-2014-06-27T000000.html"
              test="@nullFlavor or (@code='55752-0' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Clinical information')">(kezo-ClinicalInformation): de elementwaarde MOET een zijn van 'code '55752-0' codeSystem '2.16.840.1.113883.6.1' displayName='Clinical information''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.301
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]/hl7:title
Item: (kezo-ClinicalInformation)
-->

   <rule context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]/hl7:title"
         id="d15e24136-false-d219880e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.301-2014-06-27T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-ClinicalInformation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.301
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]/hl7:text[not(@nullFlavor)]
Item: (kezo-ClinicalInformation)
-->

   <rule context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.301']]/hl7:text[not(@nullFlavor)]"
         id="d15e24138-false-d219893e0">
      <extends rule="ED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.301-2014-06-27T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ED' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-ClinicalInformation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
</pattern>
