<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.66.10.404
Name: KEZO MP CDA Medicatieafspraak
Description: Medicatieafspraak met eventueel op-/afbouw schema. Ten opzichte van het oorspronkelijke template in Medicatieproces 9.0.5 zijn twee entryRelationship elementen toegevoegd die koppelingen met contact(verslag) en concern (episode) ondersteunen.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000">
   <title>KEZO MP CDA Medicatieafspraak</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.404
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]
Item: (kezo-MPCDAMedicatieAfspraakSchema)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.404
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]
Item: (kezo-MPCDAMedicatieAfspraakSchema)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]"
         id="d15e25478-false-d274133e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="string(@classCode) = ('SBADM')">(kezo-MPCDAMedicatieAfspraakSchema): de waarde van classCode MOET 'SBADM' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="string(@moodCode) = ('RQO')">(kezo-MPCDAMedicatieAfspraakSchema): de waarde van moodCode MOET 'RQO' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404']) &gt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404']) &lt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']) &gt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']) &lt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:id) &gt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:id is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:id) &lt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:code[(@code = '16076005' and @codeSystem = '2.16.840.1.113883.6.96')]) &gt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:code[(@code = '16076005' and @codeSystem = '2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:code[(@code = '16076005' and @codeSystem = '2.16.840.1.113883.6.96')]) &lt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:code[(@code = '16076005' and @codeSystem = '2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:text) &gt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:text is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:text) &lt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:text komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:statusCode[@code='nullified']) &lt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:statusCode[@code='nullified'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:effectiveTime[(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') ]) &lt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:effectiveTime[(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') ] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:routeCode) &gt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:routeCode is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:routeCode) &lt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:routeCode komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9070']]]) &gt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9070']]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9070']]]) &lt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9070']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]) &gt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]) &lt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9067']) &lt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9067'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9068']) &lt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9068'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9160']) &lt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9160'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9122']) &lt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9122'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9123']) &lt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9123'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9069']) &lt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9069'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9086' or */cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9101' or */cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9176']) &lt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9086' or */cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9101' or */cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9176'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9200']]]) &lt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9200']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9084']]]) &gt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9084']]] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="count(cda:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9084']]]) &lt;= 1">(kezo-MPCDAMedicatieAfspraakSchema): element cda:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9084']]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.404
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404']
Item: (kezo-MPCDAMedicatieAfspraakSchema)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404']"
         id="d15e25492-false-d274418e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-MPCDAMedicatieAfspraakSchema): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.66.10.404')">(kezo-MPCDAMedicatieAfspraakSchema): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.66.10.404' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.404
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']
Item: (kezo-MPCDAMedicatieAfspraakSchema)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']"
         id="d15e25497-false-d274437e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.20.77.10.9148')">(kezo-MPCDAMedicatieAfspraakSchema): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9184
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:id
Item: (MPCDAVoorstelMedicatieAfspraakDelen1)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:id"
         id="d274446e42-false-d274454e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MPCDAVoorstelMedicatieAfspraakDelen1): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9184
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:code[(@code = '16076005' and @codeSystem = '2.16.840.1.113883.6.96')]
Item: (MPCDAVoorstelMedicatieAfspraakDelen1)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:code[(@code = '16076005' and @codeSystem = '2.16.840.1.113883.6.96')]"
         id="d274446e50-false-d274467e0">
      <extends rule="CD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MPCDAVoorstelMedicatieAfspraakDelen1): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="@nullFlavor or (@code='16076005' and @codeSystem='2.16.840.1.113883.6.96')">(MPCDAVoorstelMedicatieAfspraakDelen1): de elementwaarde MOET een zijn van 'code '16076005' codeSystem '2.16.840.1.113883.6.96''.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(MPCDAVoorstelMedicatieAfspraakDelen1): attribuut @displayName MOET datatype 'st' hebben  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(MPCDAVoorstelMedicatieAfspraakDelen1): attribuut @codeSystemName MOET datatype 'st' hebben  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9184
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:text
Item: (MPCDAVoorstelMedicatieAfspraakDelen1)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:text"
         id="d274446e68-false-d274499e0">
      <extends rule="ED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ED' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MPCDAVoorstelMedicatieAfspraakDelen1): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="string(@mediaType) = ('text/plain') or not(@mediaType)">(MPCDAVoorstelMedicatieAfspraakDelen1): de waarde van mediaType MOET 'text/plain' zijn. Gevonden: "<value-of select="@mediaType"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="not(@mediaType) or string-length(@mediaType)&gt;0">(MPCDAVoorstelMedicatieAfspraakDelen1): attribuut @mediaType MOET datatype 'st' hebben  - '<value-of select="@mediaType"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9184
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:statusCode[@code='nullified']
Item: (MPCDAVoorstelMedicatieAfspraakDelen1)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:statusCode[@code='nullified']"
         id="d274446e79-false-d274521e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MPCDAVoorstelMedicatieAfspraakDelen1): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="@nullFlavor or (@code='nullified')">(MPCDAVoorstelMedicatieAfspraakDelen1): de elementwaarde MOET een zijn van 'code 'nullified''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9184
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:effectiveTime[(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') ]
Item: (MPCDAVoorstelMedicatieAfspraakDelen1)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:effectiveTime[(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') ]"
         id="d274446e92-false-d274539e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MPCDAVoorstelMedicatieAfspraakDelen1): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="count(hl7:low) &lt;= 1">(MPCDAVoorstelMedicatieAfspraakDelen1): element hl7:low komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="count(hl7:width) &lt;= 1">(MPCDAVoorstelMedicatieAfspraakDelen1): element hl7:width komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="count(hl7:high) &lt;= 1">(MPCDAVoorstelMedicatieAfspraakDelen1): element hl7:high komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9019
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:effectiveTime[(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') ]/hl7:low
Item: (UsablePeriod)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:effectiveTime[(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') ]/hl7:low"
         id="d274579e42-false-d274587e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(UsablePeriod): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="not(*)">(UsablePeriod): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9019
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:effectiveTime[(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') ]/hl7:width
Item: (UsablePeriod)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:effectiveTime[(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') ]/hl7:width"
         id="d274579e58-false-d274604e0">
      <extends rule="PQ"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PQ' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(UsablePeriod): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(UsablePeriod): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(UsablePeriod): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="@value">(UsablePeriod): attribute @value MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="not(@value) or matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(UsablePeriod): attribuut @value is geen geldig real getal <value-of select="@value"/>
      </assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="@unit">(UsablePeriod): attribute @unit MOET aanwezig zijn.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@unit),'\s'))"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="not(@unit) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.2.4.3.11.60.20.77.11.25-2016-07-01T160454.xml')/*/valueSet/conceptList/concept/@code))])">(UsablePeriod): de waarde van unit MOET worden gekozen uit waardelijst '2.16.840.1.113883.2.4.3.11.60.20.77.11.25' Time a tot h PQ (UCUM) - without Month (2016-07-01T16:04:54).</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="@value&gt;0">(UsablePeriod): @value moet een getal bevatten dat groter is dan nul.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9019
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:effectiveTime[(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') ]/hl7:high
Item: (UsablePeriod)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:effectiveTime[(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') ]/hl7:high"
         id="d274579e86-false-d274651e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(UsablePeriod): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="not(*)">(UsablePeriod): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(UsablePeriod): attribuut @value MOET datatype 'ts' hebben  - '<value-of select="@value"/>'</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="not(@nullFlavor) or (string-length(@nullFlavor) &gt; 0 and not(matches(@nullFlavor,'\s')))">(UsablePeriod): attribuut @nullFlavor MOET datatype 'cs' hebben  - '<value-of select="@nullFlavor"/>'</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="not(../hl7:width)">(UsablePeriod): Einddatum/tijd mag niet voorkomen in combinatie met width.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="@nullFlavor or string-length(@value)&gt;10">(UsablePeriod): Einddatum/tijd minimaal tot op de minuut nauwkeurig meegeven (om verwarring tussen 'tot' en 'tot en met' te voorkomen).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9184
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:routeCode
Item: (MPCDAVoorstelMedicatieAfspraakDelen1)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:routeCode"
         id="d274446e107-false-d274680e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MPCDAVoorstelMedicatieAfspraakDelen1): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.4.4.9') or not(@codeSystem)">(MPCDAVoorstelMedicatieAfspraakDelen1): de waarde van codeSystem MOET '2.16.840.1.113883.2.4.4.9' zijn. Gevonden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="not(@nullFlavor) or (string-length(@nullFlavor) &gt; 0 and not(matches(@nullFlavor,'\s')))">(MPCDAVoorstelMedicatieAfspraakDelen1): attribuut @nullFlavor MOET datatype 'cs' hebben  - '<value-of select="@nullFlavor"/>'</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="not(starts-with(@code, '0'))">(MPCDAVoorstelMedicatieAfspraakDelen1): Géén voorloopnullen opnemen bij code voor toedieningsweg.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="@nullFlavor or @displayName">(MPCDAVoorstelMedicatieAfspraakDelen1): Het is verplicht de displayName mee te geven als er een waarde is.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.404
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9070']]]
Item: (kezo-MPCDAMedicatieAfspraakSchema)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.404
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]
Item: (kezo-MPCDAMedicatieAfspraakSchema)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9066
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]
Item: (MP_CDA_AuthorParticipation)
-->
   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2016-06-15T212337.html"
              test="count(cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9066']) &lt;= 1">(MP_CDA_AuthorParticipation): element cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9066'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2016-06-15T212337.html"
              test="count(cda:time) &gt;= 1">(MP_CDA_AuthorParticipation): element cda:time is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2016-06-15T212337.html"
              test="count(cda:time) &lt;= 1">(MP_CDA_AuthorParticipation): element cda:time komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2016-06-15T212337.html"
              test="count(cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]) &gt;= 1">(MP_CDA_AuthorParticipation): element cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2016-06-15T212337.html"
              test="count(cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]) &lt;= 1">(MP_CDA_AuthorParticipation): element cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9066
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9066']
Item: (MP_CDA_AuthorParticipation)
-->
   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9066']">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2016-06-15T212337.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.20.77.10.9066')">(MP_CDA_AuthorParticipation): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.20.77.10.9066' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9066
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:time
Item: (MP_CDA_AuthorParticipation)
-->
   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:time">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2016-06-15T212337.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(MP_CDA_AuthorParticipation): attribuut @value MOET datatype 'ts' hebben  - '<value-of select="@value"/>'</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2016-06-15T212337.html"
              test="not(@nullFlavor) or (string-length(@nullFlavor) &gt; 0 and not(matches(@nullFlavor,'\s')))">(MP_CDA_AuthorParticipation): attribuut @nullFlavor MOET datatype 'cs' hebben  - '<value-of select="@nullFlavor"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9066
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]
Item: (MP_CDA_AuthorParticipation)
-->
   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2016-06-15T212337.html"
              test="count(cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9113']) &lt;= 1">(MP_CDA_AuthorParticipation): element cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9113'] komt te vaak voor [max 1x].</assert>
      <let name="elmcount"
           value="count(cda:id[@root='2.16.528.1.1007.3.1'] | cda:id[@root='2.16.840.1.113883.2.4.6.1'] | cda:id[@root='2.16.528.1.1007.5.1'] | cda:id[not(@root='2.16.528.1.1007.3.1' or @root='2.16.840.1.113883.2.4.6.1' or @root='2.16.528.1.1007.5.1')])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2016-06-15T212337.html"
              test="$elmcount &gt;= 1">(MP_CDA_AuthorParticipation): keuze (cda:id[@root='2.16.528.1.1007.3.1']  of  cda:id[@root='2.16.840.1.113883.2.4.6.1']  of  cda:id[@root='2.16.528.1.1007.5.1']  of  cda:id[not(@root='2.16.528.1.1007.3.1' or @root='2.16.840.1.113883.2.4.6.1' or @root='2.16.528.1.1007.5.1')]) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2016-06-15T212337.html"
              test="count(cda:id[@root='2.16.528.1.1007.3.1']) &lt;= 1">(MP_CDA_AuthorParticipation): element cda:id[@root='2.16.528.1.1007.3.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2016-06-15T212337.html"
              test="count(cda:id[@root='2.16.840.1.113883.2.4.6.1']) &lt;= 1">(MP_CDA_AuthorParticipation): element cda:id[@root='2.16.840.1.113883.2.4.6.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2016-06-15T212337.html"
              test="count(cda:id[@root='2.16.528.1.1007.5.1']) &lt;= 1">(MP_CDA_AuthorParticipation): element cda:id[@root='2.16.528.1.1007.5.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2016-06-15T212337.html"
              test="count(cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]) &gt;= 1">(MP_CDA_AuthorParticipation): element cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2016-06-15T212337.html"
              test="count(cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]) &lt;= 1">(MP_CDA_AuthorParticipation): element cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2016-06-15T212337.html"
              test="count(cda:assignedPerson) &gt;= 1">(MP_CDA_AuthorParticipation): element cda:assignedPerson is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2016-06-15T212337.html"
              test="count(cda:assignedPerson) &lt;= 1">(MP_CDA_AuthorParticipation): element cda:assignedPerson komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2016-06-15T212337.html"
              test="count(cda:representedOrganization) &gt;= 1">(MP_CDA_AuthorParticipation): element cda:representedOrganization is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2016-06-15T212337.html"
              test="count(cda:representedOrganization) &lt;= 1">(MP_CDA_AuthorParticipation): element cda:representedOrganization komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2016-06-15T212337.html"
              test="(cda:id[@nullFlavor] and not(cda:id[@root])) or (cda:id[@root] and not(cda:id[@nullFlavor]))">(MP_CDA_AuthorParticipation): Neem ofwel minimaal één bekende identificatie, ofwel een id element met nullFlavor op [maar niet beide].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9113
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9113']
Item: (MPCDAZorgverlener)
-->
   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9113']">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9113-2016-07-10T152506.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MPCDAZorgverlener): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9113-2016-07-10T152506.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.20.77.10.9113')">(MPCDAZorgverlener): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.20.77.10.9113' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9111
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]
Item: (MP_CDA_ZorgverlenerIdentificaties)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9111
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:id[@root='2.16.528.1.1007.3.1']
Item: (MP_CDA_ZorgverlenerIdentificaties)
-->
   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:id[@root='2.16.528.1.1007.3.1']">
      <extends rule="II.NL.UZI"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9111-2016-07-07T212337.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MP_CDA_ZorgverlenerIdentificaties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9111-2016-07-07T212337.html"
              test="string(@root) = ('2.16.528.1.1007.3.1')">(MP_CDA_ZorgverlenerIdentificaties): de waarde van root MOET '2.16.528.1.1007.3.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9111
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:id[@root='2.16.840.1.113883.2.4.6.1']
Item: (MP_CDA_ZorgverlenerIdentificaties)
-->
   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:id[@root='2.16.840.1.113883.2.4.6.1']">
      <extends rule="II.NL.AGB"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9111-2016-07-07T212337.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MP_CDA_ZorgverlenerIdentificaties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9111-2016-07-07T212337.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.6.1')">(MP_CDA_ZorgverlenerIdentificaties): de waarde van root MOET '2.16.840.1.113883.2.4.6.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9111
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:id[@root='2.16.528.1.1007.5.1']
Item: (MP_CDA_ZorgverlenerIdentificaties)
-->
   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:id[@root='2.16.528.1.1007.5.1']">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9111-2016-07-07T212337.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MP_CDA_ZorgverlenerIdentificaties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9111-2016-07-07T212337.html"
              test="string(@root) = ('2.16.528.1.1007.5.1')">(MP_CDA_ZorgverlenerIdentificaties): de waarde van root MOET '2.16.528.1.1007.5.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9111
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:id[not(@root='2.16.528.1.1007.3.1' or @root='2.16.840.1.113883.2.4.6.1' or @root='2.16.528.1.1007.5.1')]
Item: (MP_CDA_ZorgverlenerIdentificaties)
-->
   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:id[not(@root='2.16.528.1.1007.3.1' or @root='2.16.840.1.113883.2.4.6.1' or @root='2.16.528.1.1007.5.1')]">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9111-2016-07-07T212337.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MP_CDA_ZorgverlenerIdentificaties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9113
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]
Item: (MPCDAZorgverlener)
-->
   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9113-2016-07-10T152506.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MPCDAZorgverlener): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9113-2016-07-10T152506.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.2.4.15.111') or (@codeSystem='2.16.840.1.113883.2.4.6.7')">(MPCDAZorgverlener): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.2.4.15.111' of codeSystem '2.16.840.1.113883.2.4.6.7''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9113
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:assignedPerson
Item: (MPCDAZorgverlener)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9113
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:representedOrganization
Item: (MPCDAZorgverlener)
-->
   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:representedOrganization">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9113-2016-07-10T152506.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(MPCDAZorgverlener): de waarde van classCode MOET 'ORG' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9113-2016-07-10T152506.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(MPCDAZorgverlener): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <let name="elmcount"
           value="count(cda:id[@root='2.16.528.1.1007.3.3'] | cda:id[@root='2.16.840.1.113883.2.4.6.1'] | cda:id[not(@root='2.16.840.1.113883.2.4.6.1') and not(@root='2.16.528.1.1007.3.3')])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9113-2016-07-10T152506.html"
              test="$elmcount &gt;= 1">(MPCDAZorgverlener): keuze (cda:id[@root='2.16.528.1.1007.3.3']  of  cda:id[@root='2.16.840.1.113883.2.4.6.1']  of  cda:id[not(@root='2.16.840.1.113883.2.4.6.1') and not(@root='2.16.528.1.1007.3.3')]) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9113-2016-07-10T152506.html"
              test="$elmcount &lt;= 3">(MPCDAZorgverlener): keuze (cda:id[@root='2.16.528.1.1007.3.3']  of  cda:id[@root='2.16.840.1.113883.2.4.6.1']  of  cda:id[not(@root='2.16.840.1.113883.2.4.6.1') and not(@root='2.16.528.1.1007.3.3')]) bevat te veel elementen [max 3x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9113-2016-07-10T152506.html"
              test="count(cda:id[@root='2.16.528.1.1007.3.3']) &lt;= 1">(MPCDAZorgverlener): element cda:id[@root='2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9113-2016-07-10T152506.html"
              test="count(cda:id[@root='2.16.840.1.113883.2.4.6.1']) &lt;= 1">(MPCDAZorgverlener): element cda:id[@root='2.16.840.1.113883.2.4.6.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9113-2016-07-10T152506.html"
              test="count(cda:id[not(@root='2.16.840.1.113883.2.4.6.1') and not(@root='2.16.528.1.1007.3.3')]) &lt;= 1">(MPCDAZorgverlener): element cda:id[not(@root='2.16.840.1.113883.2.4.6.1') and not(@root='2.16.528.1.1007.3.3')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9113-2016-07-10T152506.html"
              test="(cda:id[@nullFlavor] and not(cda:id[@root])) or (cda:id[@root] and not(cda:id[@nullFlavor]))">(MPCDAZorgverlener): Neem ofwel minimaal één bekende identificatie, ofwel een id element met nullFlavor op [maar niet beide].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9112
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:representedOrganization
Item: (MP_CDA_ZorgaanbiederIdentificaties)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9112
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:representedOrganization/cda:id[@root='2.16.528.1.1007.3.3']
Item: (MP_CDA_ZorgaanbiederIdentificaties)
-->
   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:representedOrganization/cda:id[@root='2.16.528.1.1007.3.3']">
      <extends rule="II.NL.URA"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9112-2016-07-10T120116.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MP_CDA_ZorgaanbiederIdentificaties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9112-2016-07-10T120116.html"
              test="string(@root) = ('2.16.528.1.1007.3.3')">(MP_CDA_ZorgaanbiederIdentificaties): de waarde van root MOET '2.16.528.1.1007.3.3' zijn. Gevonden: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9112-2016-07-10T120116.html"
              test="@extension">(MP_CDA_ZorgaanbiederIdentificaties): attribute @extension MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9112-2016-07-10T120116.html"
              test="not(@extension) or string-length(@extension)&gt;0">(MP_CDA_ZorgaanbiederIdentificaties): attribuut @extension MOET datatype 'st' hebben  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9112
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:representedOrganization/cda:id[@root='2.16.840.1.113883.2.4.6.1']
Item: (MP_CDA_ZorgaanbiederIdentificaties)
-->
   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:representedOrganization/cda:id[@root='2.16.840.1.113883.2.4.6.1']">
      <extends rule="II.NL.AGB"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9112-2016-07-10T120116.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MP_CDA_ZorgaanbiederIdentificaties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9112-2016-07-10T120116.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.6.1')">(MP_CDA_ZorgaanbiederIdentificaties): de waarde van root MOET '2.16.840.1.113883.2.4.6.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9112-2016-07-10T120116.html"
              test="@extension">(MP_CDA_ZorgaanbiederIdentificaties): attribute @extension MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9112-2016-07-10T120116.html"
              test="not(@extension) or string-length(@extension)&gt;0">(MP_CDA_ZorgaanbiederIdentificaties): attribuut @extension MOET datatype 'st' hebben  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9112
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:representedOrganization/cda:id[not(@root='2.16.840.1.113883.2.4.6.1') and not(@root='2.16.528.1.1007.3.3')]
Item: (MP_CDA_ZorgaanbiederIdentificaties)
-->
   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:representedOrganization/cda:id[not(@root='2.16.840.1.113883.2.4.6.1') and not(@root='2.16.528.1.1007.3.3')]">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9112-2016-07-10T120116.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MP_CDA_ZorgaanbiederIdentificaties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9112-2016-07-10T120116.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(MP_CDA_ZorgaanbiederIdentificaties): attribuut @root MOET datatype 'uid' hebben  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9112-2016-07-10T120116.html"
              test="not(@extension) or string-length(@extension)&gt;0">(MP_CDA_ZorgaanbiederIdentificaties): attribuut @extension MOET datatype 'st' hebben  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9089
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:representedOrganization/hl7:name
Item: (MPCDAOrganization)
-->
   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:representedOrganization/hl7:name">
      <extends rule="ON"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9089-2016-06-21T134042.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MPCDAOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9181
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9067']
Item: (MPCDAVoorstelMedicatieAfspraakDelen)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9067']"
         id="d275259e71-false-d275265e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9181-2017-05-31T111241.html"
              test="string(@typeCode) = ('COMP')">(MPCDAVoorstelMedicatieAfspraakDelen): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9181
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9068']
Item: (MPCDAVoorstelMedicatieAfspraakDelen)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9068']"
         id="d275259e94-false-d275278e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9181-2017-05-31T111241.html"
              test="string(@typeCode) = ('RSON')">(MPCDAVoorstelMedicatieAfspraakDelen): de waarde van typeCode MOET 'RSON' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9181
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9160']
Item: (MPCDAVoorstelMedicatieAfspraakDelen)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9160']"
         id="d275259e118-false-d275291e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9181-2017-05-31T111241.html"
              test="string(@typeCode) = ('RSON')">(MPCDAVoorstelMedicatieAfspraakDelen): de waarde van typeCode MOET 'RSON' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9181
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9085']
Item: (MPCDAVoorstelMedicatieAfspraakDelen)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9085']"
         id="d275259e126-false-d275304e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9181-2017-05-31T111241.html"
              test="string(@typeCode) = ('SPRT')">(MPCDAVoorstelMedicatieAfspraakDelen): de waarde van typeCode MOET 'SPRT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9181
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9122']
Item: (MPCDAVoorstelMedicatieAfspraakDelen)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9122']"
         id="d275259e149-false-d275317e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9181-2017-05-31T111241.html"
              test="string(@typeCode) = ('COMP')">(MPCDAVoorstelMedicatieAfspraakDelen): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9181
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9123']
Item: (MPCDAVoorstelMedicatieAfspraakDelen)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9123']"
         id="d275259e157-false-d275330e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9181-2017-05-31T111241.html"
              test="string(@typeCode) = ('COMP')">(MPCDAVoorstelMedicatieAfspraakDelen): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9181
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9177']
Item: (MPCDAVoorstelMedicatieAfspraakDelen)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9177']"
         id="d275259e165-false-d275343e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9181-2017-05-31T111241.html"
              test="string(@typeCode) = ('COMP')">(MPCDAVoorstelMedicatieAfspraakDelen): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9181
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9069']
Item: (MPCDAVoorstelMedicatieAfspraakDelen)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9069']"
         id="d275259e173-false-d275356e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9181-2017-05-31T111241.html"
              test="string(@typeCode) = ('SUBJ')">(MPCDAVoorstelMedicatieAfspraakDelen): de waarde van typeCode MOET 'SUBJ' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9181-2017-05-31T111241.html"
              test="string(@inversionInd) = ('true')">(MPCDAVoorstelMedicatieAfspraakDelen): de waarde van inversionInd MOET 'true' zijn. Gevonden: "<value-of select="@inversionInd"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9181
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9149']
Item: (MPCDAVoorstelMedicatieAfspraakDelen)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9149']"
         id="d275259e202-false-d275375e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9181-2017-05-31T111241.html"
              test="string(@typeCode) = ('COMP')">(MPCDAVoorstelMedicatieAfspraakDelen): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9181-2017-05-31T111241.html"
              test="count(cda:sequenceNumber) &gt;= 1">(MPCDAVoorstelMedicatieAfspraakDelen): element cda:sequenceNumber is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9181-2017-05-31T111241.html"
              test="count(cda:sequenceNumber) &lt;= 1">(MPCDAVoorstelMedicatieAfspraakDelen): element cda:sequenceNumber komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9181-2017-05-31T111241.html"
              test="count(cda:substanceAdministration[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9149']]) &gt;= 1">(MPCDAVoorstelMedicatieAfspraakDelen): element cda:substanceAdministration[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9149']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9181-2017-05-31T111241.html"
              test="count(cda:substanceAdministration[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9149']]) &lt;= 1">(MPCDAVoorstelMedicatieAfspraakDelen): element cda:substanceAdministration[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9149']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9181
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9149']/cda:sequenceNumber
Item: (MPCDAVoorstelMedicatieAfspraakDelen)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9149']/cda:sequenceNumber"
         id="d275259e209-false-d275474e0">
      <extends rule="INT"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9181-2017-05-31T111241.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='INT' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MPCDAVoorstelMedicatieAfspraakDelen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:INT" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9181-2017-05-31T111241.html"
              test="not(@value) or matches(@value, '^-?[1-9]\d*$|^+?\d*$')">(MPCDAVoorstelMedicatieAfspraakDelen): @value is geen geldig INT getal <value-of select="@value"/>
      </assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9181-2017-05-31T111241.html"
              test="@value">(MPCDAVoorstelMedicatieAfspraakDelen): attribute @value MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9181-2017-05-31T111241.html"
              test="not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')">(MPCDAVoorstelMedicatieAfspraakDelen): attribuut @value is geen geldig int getal <value-of select="@value"/>
      </assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9181
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9086' or */cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9101' or */cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9176']
Item: (MPCDAVoorstelMedicatieAfspraakDelen)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[*/cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9086' or */cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9101' or */cda:templateId/@root='2.16.840.1.113883.2.4.3.11.60.20.77.10.9176']"
         id="d275259e224-false-d275501e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9181-2017-05-31T111241.html"
              test="string(@typeCode) = ('REFR')">(MPCDAVoorstelMedicatieAfspraakDelen): de waarde van typeCode MOET 'REFR' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <let name="elmcount"
           value="count(hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9086']] | hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9101']] | hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9176']])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9181-2017-05-31T111241.html"
              test="$elmcount &lt;= 1">(MPCDAVoorstelMedicatieAfspraakDelen): keuze (hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9086']]  of  hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9101']]  of  hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9176']]) bevat te veel elementen [max 1x]</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.404
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9200']]]
Item: (kezo-MPCDAMedicatieAfspraakSchema)
-->
   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9200']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="string(@typeCode) = ('COMP')">(kezo-MPCDAMedicatieAfspraakSchema): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.404
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9084']]]
Item: (kezo-MPCDAMedicatieAfspraakSchema)
-->
   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/cda:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9084']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="string(@typeCode) = ('COMP')">(kezo-MPCDAMedicatieAfspraakSchema): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.404-2018-04-18T000000.html"
              test="string(@inversionInd) = ('true')">(kezo-MPCDAMedicatieAfspraakSchema): de waarde van inversionInd MOET 'true' zijn. Gevonden: "<value-of select="@inversionInd"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.32
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter]
Item: (partEncounterReference)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter]"
         id="d275589e10-false-d275595e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.32-2017-12-21T123947.html"
              test="string(@typeCode) = ('REFR')">(partEncounterReference): de waarde van typeCode MOET 'REFR' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.32-2017-12-21T123947.html"
              test="count(hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN']) &gt;= 1">(partEncounterReference): element hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.32-2017-12-21T123947.html"
              test="count(hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN']) &lt;= 1">(partEncounterReference): element hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.32
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter]/hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN']
Item: (partEncounterReference)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter]/hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN']"
         id="d275589e28-false-d275625e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.32-2017-12-21T123947.html"
              test="string(@classCode) = ('ENC')">(partEncounterReference): de waarde van classCode MOET 'ENC' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.32-2017-12-21T123947.html"
              test="string(@moodCode) = ('EVN')">(partEncounterReference): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.32-2017-12-21T123947.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(partEncounterReference): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.32-2017-12-21T123947.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(partEncounterReference): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.32
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter]/hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN']/hl7:id[not(@nullFlavor)]
Item: (partEncounterReference)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter]/hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN']/hl7:id[not(@nullFlavor)]"
         id="d275589e40-false-d275661e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.32-2017-12-21T123947.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(partEncounterReference): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.33
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]
Item: (partConcernReference)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]"
         id="d275668e10-false-d275674e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="string(@typeCode) = ('REFR')">(partConcernReference): de waarde van typeCode MOET 'REFR' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="count(hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]) &gt;= 1">(partConcernReference): element hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="count(hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]) &lt;= 1">(partConcernReference): element hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.33
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]
Item: (partConcernReference)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]"
         id="d275668e30-false-d275704e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="string(@classCode) = ('ACT')">(partConcernReference): de waarde van classCode MOET 'ACT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="string(@moodCode) = ('EVN')">(partConcernReference): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(partConcernReference): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(partConcernReference): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="count(hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]) &gt;= 1">(partConcernReference): element hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="count(hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]) &lt;= 1">(partConcernReference): element hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.33
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]/hl7:id[not(@nullFlavor)]
Item: (partConcernReference)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]/hl7:id[not(@nullFlavor)]"
         id="d275668e42-false-d275755e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(partConcernReference): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.33
Context: *[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]/hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]
Item: (partConcernReference)
-->

   <rule context="*[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]/cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]/hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]"
         id="d275668e52-false-d275768e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(partConcernReference): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="@nullFlavor or (@code='CONC' and @codeSystem='2.16.840.1.113883.5.6')">(partConcernReference): de elementwaarde MOET een zijn van 'code 'CONC' codeSystem '2.16.840.1.113883.5.6''.</assert>
   </rule>
</pattern>
