<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<axsl:stylesheet xmlns:axsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:saxon="http://saxon.sf.net/" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:iso="http://purl.oclc.org/dsdl/schematron" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:hl7="urn:hl7-org:v3" xmlns:cda="urn:hl7-org:v3" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:pharm="urn:ihe:pharm:medication" xmlns:lab="urn:oid:1.3.6.1.4.1.19376.1.3.2" xmlns:sdtc="urn:hl7-org:sdtc" xmlns:ihe="urn:ihe:pcc:hl7v3" xmlns:hl7nl="urn:hl7-nl:v3" xmlns:f="http://hl7.org/fhir" xmlns:nfu="urn:urn:nictiz-nl:v3/nfu" version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->

   <axsl:param name="archiveDirParameter"/>
   <axsl:param name="archiveNameParameter"/>
   <axsl:param name="fileNameParameter"/>
   <axsl:param name="fileDirParameter"/>
   <axsl:variable name="document-uri">
      <axsl:value-of select="document-uri(/)"/>
   </axsl:variable>

<!--PHASES-->


<!--PROLOG-->

   <axsl:output method="text"/>

<!--XSD TYPES FOR XSLT2-->


<!--KEYS AND FUNCTIONS-->


<!--DEFAULT RULES-->


<!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->

   <axsl:template match="*" mode="schematron-select-full-path">
      <axsl:apply-templates select="." mode="schematron-get-full-path"/>
   </axsl:template>

<!--MODE: SCHEMATRON-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->

   <axsl:template match="*" mode="schematron-get-full-path">
      <axsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <axsl:text>/</axsl:text>
      <axsl:choose>
         <axsl:when test="namespace-uri()=''">
            <axsl:value-of select="name()"/>
         </axsl:when>
         <axsl:otherwise>
            <axsl:text>*:</axsl:text>
            <axsl:value-of select="local-name()"/>
            <axsl:text>[namespace-uri()='</axsl:text>
            <axsl:value-of select="namespace-uri()"/>
            <axsl:text>']</axsl:text>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="preceding" select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <axsl:text>[</axsl:text>
      <axsl:value-of select="1+ $preceding"/>
      <axsl:text>]</axsl:text>
   </axsl:template>
   <axsl:template match="@*" mode="schematron-get-full-path">
      <axsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <axsl:text>/</axsl:text>
      <axsl:choose>
         <axsl:when test="namespace-uri()=''">@<axsl:value-of select="name()"/>
         </axsl:when>
         <axsl:otherwise>
            <axsl:text>@*[local-name()='</axsl:text>
            <axsl:value-of select="local-name()"/>
            <axsl:text>' and namespace-uri()='</axsl:text>
            <axsl:value-of select="namespace-uri()"/>
            <axsl:text>']</axsl:text>
         </axsl:otherwise>
      </axsl:choose>
   </axsl:template>

<!--MODE: SCHEMATRON-FULL-PATH-2-->
<!--This mode can be used to generate prefixed XPath for humans-->

   <axsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <axsl:for-each select="ancestor-or-self::*">
         <axsl:text>/</axsl:text>
         <axsl:value-of select="name(.)"/>
         <axsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <axsl:text>[</axsl:text>
            <axsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <axsl:text>]</axsl:text>
         </axsl:if>
      </axsl:for-each>
      <axsl:if test="not(self::*)">
         <axsl:text/>/@<axsl:value-of select="name(.)"/>
      </axsl:if>
   </axsl:template><!--MODE: SCHEMATRON-FULL-PATH-3-->
<!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->

   <axsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <axsl:for-each select="ancestor-or-self::*">
         <axsl:text>/</axsl:text>
         <axsl:value-of select="name(.)"/>
         <axsl:if test="parent::*">
            <axsl:text>[</axsl:text>
            <axsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <axsl:text>]</axsl:text>
         </axsl:if>
      </axsl:for-each>
      <axsl:if test="not(self::*)">
         <axsl:text/>/@<axsl:value-of select="name(.)"/>
      </axsl:if>
   </axsl:template>

<!--MODE: GENERATE-ID-FROM-PATH -->

   <axsl:template match="/" mode="generate-id-from-path"/>
   <axsl:template match="text()" mode="generate-id-from-path">
      <axsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <axsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </axsl:template>
   <axsl:template match="comment()" mode="generate-id-from-path">
      <axsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <axsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </axsl:template>
   <axsl:template match="processing-instruction()" mode="generate-id-from-path">
      <axsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <axsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </axsl:template>
   <axsl:template match="@*" mode="generate-id-from-path">
      <axsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <axsl:value-of select="concat('.@', name())"/>
   </axsl:template>
   <axsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <axsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <axsl:text>.</axsl:text>
      <axsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </axsl:template>

<!--MODE: GENERATE-ID-2 -->

   <axsl:template match="/" mode="generate-id-2">U</axsl:template>
   <axsl:template match="*" mode="generate-id-2" priority="2">
      <axsl:text>U</axsl:text>
      <axsl:number level="multiple" count="*"/>
   </axsl:template>
   <axsl:template match="node()" mode="generate-id-2">
      <axsl:text>U.</axsl:text>
      <axsl:number level="multiple" count="*"/>
      <axsl:text>n</axsl:text>
      <axsl:number count="node()"/>
   </axsl:template>
   <axsl:template match="@*" mode="generate-id-2">
      <axsl:text>U.</axsl:text>
      <axsl:number level="multiple" count="*"/>
      <axsl:text>_</axsl:text>
      <axsl:value-of select="string-length(local-name(.))"/>
      <axsl:text>_</axsl:text>
      <axsl:value-of select="translate(name(),':','.')"/>
   </axsl:template><!--Strip characters-->
   <axsl:template match="text()" priority="-1"/>

<!--SCHEMA SETUP-->

   <axsl:template match="/">
      <axsl:apply-templates select="/" mode="M13"/>
      <axsl:apply-templates select="/" mode="M14"/>
      <axsl:apply-templates select="/" mode="M15"/>
      <axsl:apply-templates select="/" mode="M16"/>
      <axsl:apply-templates select="/" mode="M26"/>
      <axsl:apply-templates select="/" mode="M27"/>
      <axsl:apply-templates select="/" mode="M28"/>
      <axsl:apply-templates select="/" mode="M29"/>
      <axsl:apply-templates select="/" mode="M30"/>
      <axsl:apply-templates select="/" mode="M31"/>
   </axsl:template>

<!--SCHEMATRON PATTERNS-->


<!--PATTERN -->

   <axsl:template match="text()" priority="-1" mode="M13"/>
   <axsl:template match="@*|node()" priority="-2" mode="M13">
      <axsl:apply-templates select="*" mode="M13"/>
   </axsl:template>

<!--PATTERN OrganizerContactverslagen-->


	<!--RULE -->

   <axsl:template match="/" priority="1000" mode="M14">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="descendant-or-self::hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]"/>
         <axsl:otherwise>
            <axsl:message>beschikbaarstellenContactverslagen: In de instance werd het volgende element verwacht: descendant-or-self::hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']] (descendant-or-self::hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']] / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M14"/>
   </axsl:template>
   <axsl:template match="text()" priority="-1" mode="M14"/>
   <axsl:template match="@*|node()" priority="-2" mode="M14">
      <axsl:apply-templates select="*" mode="M14"/>
   </axsl:template>

<!--PATTERN template-2.16.840.1.113883.2.4.3.11.60.66.10.14-2018-04-18T000000Organizer Contactverslagen-->


	<!--RULE d152e8916-false-d59678e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]" priority="1064" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@classCode) = ('CLUSTER')"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen): de waarde van classCode MOET 'CLUSTER' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@classCode"/>
               <axsl:text/>" (string(@classCode) = ('CLUSTER') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@moodCode) = ('EVN')"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@moodCode"/>
               <axsl:text/>" (string(@moodCode) = ('EVN') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']) &gt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14'] is mandatory [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']) &gt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14'] komt te vaak voor [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen): element hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')] is mandatory [min 1x]. (count(hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen): element hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')] komt te vaak voor [max 1x]. (count(hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:statusCode[@code = 'completed']) &gt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen): element hl7:statusCode[@code = 'completed'] is mandatory [min 1x]. (count(hl7:statusCode[@code = 'completed']) &gt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:statusCode[@code = 'completed']) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen): element hl7:statusCode[@code = 'completed'] komt te vaak voor [max 1x]. (count(hl7:statusCode[@code = 'completed']) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:recordTarget[not(@nullFlavor)][hl7:patientRole]) &gt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen): element hl7:recordTarget[not(@nullFlavor)][hl7:patientRole] is mandatory [min 1x]. (count(hl7:recordTarget[not(@nullFlavor)][hl7:patientRole]) &gt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:recordTarget[not(@nullFlavor)][hl7:patientRole]) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen): element hl7:recordTarget[not(@nullFlavor)][hl7:patientRole] komt te vaak voor [max 1x]. (count(hl7:recordTarget[not(@nullFlavor)][hl7:patientRole]) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:participant[@typeCode='RESP']) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen): element hl7:participant[@typeCode='RESP'] komt te vaak voor [max 1x]. (count(hl7:participant[@typeCode='RESP']) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:participant[@typeCode='CST']) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen): element hl7:participant[@typeCode='CST'] komt te vaak voor [max 1x]. (count(hl7:participant[@typeCode='CST']) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d152e8922-false-d59826e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']" priority="1063" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @identifierName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor and @identifierName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @displayable)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor and @displayable) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @reliability)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor and @reliability) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @assigningAuthorityName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor and @assigningAuthorityName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@root) &lt;= 128)">
         <axsl:message>dtr1-8-II: @root should not be longer than 128 characters. Found <axsl:text/>
            <axsl:value-of select="string-length(@root)"/>
            <axsl:text/> characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
      </axsl:if>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@extension) &lt;= 64)">
         <axsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Found <axsl:text/>
            <axsl:value-of select="string-length(@extension)"/>
            <axsl:text/> characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
      </axsl:if>
      <axsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <axsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <axsl:variable name="UUIDpattern" select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID or UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <axsl:variable name="root" select="@root"/>
      <axsl:variable name="extension" select="@extension"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-II: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT info-->

      <axsl:choose>
         <axsl:when test="not(matches(@root, $UUIDpattern) and matches(@root, '[a-z]') and matches(@root, '[A-Z]'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-II: Lower case and Upper case mixed UUID "<axsl:text/>
               <axsl:value-of select="@root"/>
               <axsl:text/>" found in @root. UUIDs SHALL not have mixed cases. (not(matches(@root, $UUIDpattern) and matches(@root, '[a-z]') and matches(@root, '[A-Z]')) / info / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.66.10.14')"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.66.10.14' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@root"/>
               <axsl:text/>" (string(@root) = ('2.16.840.1.113883.2.4.3.11.60.66.10.14') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d152e8927-false-d59844e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')]" priority="1062" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@code)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@codeSystemName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@code or not(@displayName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @code)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-CD: co-occurence violation. Cannot have code and null (not(@nullFlavor and @code) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @displayName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-CD: co-occurence violation. Cannot have displayName and null (not(@nullFlavor and @displayName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-CD: no null on translations (Exceptional values (NULL-values) can not be elements of a set.) (not(.//hl7:translation/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystem][not(@code)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-CD: translation code requires codeSystem (not(.//hl7:translation[@codeSystem][not(@code)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystemName][not(@codeSystem)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (not(.//hl7:translation[@codeSystemName][not(@codeSystem)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@displayName][not(@code)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-CD: translation displayName only if code (not(.//hl7:translation[@displayName][not(@code)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="matches(@displayName,'[\r\n\t]')">
         <axsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
      </axsl:if>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <axsl:variable name="code" select="@code"/>
      <axsl:variable name="codeSystem" select="@codeSystem"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[@code=$code][@codeSystem=$codeSystem])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-CD: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> (@code=<axsl:text/>
               <axsl:value-of select="$code"/>
               <axsl:text/> @codeSystem=<axsl:text/>
               <axsl:value-of select="$codeSystem"/>
               <axsl:text/>) SHALL be distinct (not($set_other[@code=$code][@codeSystem=$codeSystem]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="translations" select=".//hl7:translation/concat(@code,@codeSystem)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count($translations)=count(distinct-values($translations))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-19-CD: [RIM-002] translations SHALL be distinct (count($translations)=count(distinct-values($translations)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-20-CD: originalText/@language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:qualifier)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CE)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or (@code='34900-1' and @codeSystem='2.16.840.1.113883.6.1')"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen): de elementwaarde MOET een zijn van 'code '34900-1' codeSystem '2.16.840.1.113883.6.1''. (@nullFlavor or (@code='34900-1' and @codeSystem='2.16.840.1.113883.6.1') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d152e8935-false-d59863e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:statusCode[@code = 'completed']" priority="1061" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive ((@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@codeSystem) or @codeSystem = '2.16.840.1.113883.5.139'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-CS: cannot have codeSystem (not(@codeSystem) or @codeSystem = '2.16.840.1.113883.5.139' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@codeSystemName) or @codeSystemName = 'TimingEvent'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-CS: cannot have codeSystemName (not(@codeSystemName) or @codeSystemName = 'TimingEvent' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@codeSystemVersion)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-CS: cannot have codeSystemVersion (not(@codeSystemVersion) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@displayName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-CS: cannot have displayName (not(@displayName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:originalText)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-CS: cannot have originalText (not(hl7:originalText) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:qualifier)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-CS: cannot have qualifier (not(hl7:qualifier) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-CS: cannot have translation (not(hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or (@code='completed')"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen): de elementwaarde MOET een zijn van 'code 'completed''. (@nullFlavor or (@code='completed') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d59877e21-false-d59897e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]" priority="1060" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]) &gt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']] is mandatory [min 1x]. (count(hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]) &gt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']] komt te vaak voor [max 1x]. (count(hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d59877e23-false-d59946e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]" priority="1059" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:id[@root = '2.16.840.1.113883.2.4.6.3']) &gt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:id[@root = '2.16.840.1.113883.2.4.6.3'] is required [min 1x]. (count(hl7:id[@root = '2.16.840.1.113883.2.4.6.3']) &gt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:id[@root = '2.16.840.1.113883.2.4.6.3']) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:id[@root = '2.16.840.1.113883.2.4.6.3'] komt te vaak voor [max 1x]. (count(hl7:id[@root = '2.16.840.1.113883.2.4.6.3']) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]) &gt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]] is required [min 1x]. (count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]) &gt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]] komt te vaak voor [max 1x]. (count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d59877e25-false-d60003e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:id[@root = '2.16.840.1.113883.2.4.6.3']" priority="1058" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @identifierName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor and @identifierName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @displayable)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor and @displayable) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @reliability)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor and @reliability) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @assigningAuthorityName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor and @assigningAuthorityName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@root) &lt;= 128)">
         <axsl:message>dtr1-8-II: @root should not be longer than 128 characters. Found <axsl:text/>
            <axsl:value-of select="string-length(@root)"/>
            <axsl:text/> characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
      </axsl:if>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@extension) &lt;= 64)">
         <axsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Found <axsl:text/>
            <axsl:value-of select="string-length(@extension)"/>
            <axsl:text/> characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
      </axsl:if>
      <axsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <axsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <axsl:variable name="UUIDpattern" select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID or UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <axsl:variable name="root" select="@root"/>
      <axsl:variable name="extension" select="@extension"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-II: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT info-->

      <axsl:choose>
         <axsl:when test="not(matches(@root, $UUIDpattern) and matches(@root, '[a-z]') and matches(@root, '[A-Z]'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-II: Lower case and Upper case mixed UUID "<axsl:text/>
               <axsl:value-of select="@root"/>
               <axsl:text/>" found in @root. UUIDs SHALL not have mixed cases. (not(matches(@root, $UUIDpattern) and matches(@root, '[a-z]') and matches(@root, '[A-Z]')) / info / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or @root='2.16.840.1.113883.2.4.6.3'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-II.NL.BSN: Burgerservicenummer @root MOET 2.16.840.1.113883.2.4.6.3 zijn indien niet null. Gevonden: "<axsl:text/>
               <axsl:value-of select="@root"/>
               <axsl:text/>" (@nullFlavor or @root='2.16.840.1.113883.2.4.6.3' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II.NL.BSN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^\d{9}$')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-II.NL.BSN: Burgerservicenummer MOET 9 cijfers lang zijn, met voorloopnullen indien korter dan 9 cijfers. Gevonden: "<axsl:text/>
               <axsl:value-of select="@extension"/>
               <axsl:text/>" (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^\d{9}$') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II.NL.BSN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root='2.16.840.1.113883.2.4.6.3' and matches(@extension,'^\d{9}$')) or (         (   number(substring(@extension,1,1))*9 )+         (   number(substring(@extension,2,1))*8 )+         (   number(substring(@extension,3,1))*7 )+         (   number(substring(@extension,4,1))*6 )+         (   number(substring(@extension,5,1))*5 )+         (   number(substring(@extension,6,1))*4 )+         (   number(substring(@extension,7,1))*3 )+         (   number(substring(@extension,8,1))*2 )+         (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-II.NL.BSN: Burgerservicenummer voldoet niet aan modulo 11 proef. Gevonden: "<axsl:text/>
               <axsl:value-of select="@extension"/>
               <axsl:text/>" (not(@root='2.16.840.1.113883.2.4.6.3' and matches(@extension,'^\d{9}$')) or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II.NL.BSN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@root) = ('2.16.840.1.113883.2.4.6.3')"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): de waarde van root MOET '2.16.840.1.113883.2.4.6.3' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@root"/>
               <axsl:text/>" (string(@root) = ('2.16.840.1.113883.2.4.6.3') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@extension"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): attribute @extension MOET aanwezig zijn. (@extension / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d59877e39-false-d60037e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr" priority="1057" mode="M15">
      <axsl:variable name="theAttValue" select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.2-2015-04-01T000000.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): de waarde van use MOET worden gekozen uit waardelijst '2.16.840.1.113883.2.4.3.11.60.40.2.0.1.2' AdresSoortCodelijst (2015-04-01T00:00:00). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.2-2015-04-01T000000.xml')/*/valueSet/conceptList/concept/@code))]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-AD: address shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/>)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-AD: no useablePeriod if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:useablePeriod][@updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-AD: updateMode shall not be used on address elements (count(*[self::hl7:useablePeriod][@updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or          string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-AD: useablePeriod/low/@value must have the same precision as useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or         number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-AD: useablePeriod/low/@value must be before useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="tum" select="'^(us|ms|s|min|h|d|wk|mo|a|)$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="matches(hl7:useablePeriod/hl7:width/@unit, $tum)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-AD: for useablePeriod/width only us (microseconds), ms (milliseconds), s (seconds), min (minute), h (hours), d (day), wk (week), mo (month) or a (year) are allowed (matches(hl7:useablePeriod/hl7:width/@unit, $tum) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="*[not(@nullFlavor or self::hl7:useablePeriod)][normalize-space(.)='']">
         <axsl:message>dtr1-8-AD: empty address particles should not be present. (*[not(@nullFlavor or self::hl7:useablePeriod)][normalize-space(.)=''] / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
      </axsl:if>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="value" select="string-join((.//@use|.//text()),'')"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-AD: [RIM-001] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> SHALL NOT have nullFlavor, if there are other <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[string-join((.//@use|.//text()),'')=$value])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-AD: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> (<axsl:text/>
               <axsl:value-of select="$value"/>
               <axsl:text/>) SHALL be distinct (not($set_other[string-join((.//@use|.//text()),'')=$value]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="postalCodeText" select="hl7:postalCode/text()"/>
      <axsl:variable name="countryCode" select="hl7:country/@code"/>
      <axsl:variable name="countryCodeSystem" select="hl7:country/@codeSystem"/>
      <axsl:variable name="countryText" select="upper-case(normalize-space(hl7:country))"/>
      <axsl:variable name="isDutchAddress" select="(not(hl7:country) or         ($countryCode='NL' and $countryCodeSystem=('2.16.1','1.3.6.1.4.1.1466.115.121.1.11','1.0.3166.1.2.2')) or         ($countryCode='NLD' and $countryCodeSystem='2.16.2') or         ($countryCode='528' and $countryCodeSystem='2.16.3') or         $countryText='NL' or         $countryText='NLD' or         $countryText='NEDERLAND'         )"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="if (@codeSystem='2.16.840.1.113883.2.4.4.15') then (matches(@code,'^[0-9]{4}[A-Z]{2}$')) else ( true() )"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-AD.NL: postcodes onder codeSystem '2.16.840.1.113883.2.4.4.15' moeten voldoen aan '9999AA' (if (@codeSystem='2.16.840.1.113883.2.4.4.15') then (matches(@code,'^[0-9]{4}[A-Z]{2}$')) else ( true() ) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD.NL)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="if (hl7:postalCode/text() and $isDutchAddress)             then ( matches($postalCodeText,'^[0-9]{4} [A-Z]{2}$'))            else ( true() )"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-AD.NL: Nederlandse postcodes in de text-nodes moeten voldoen aan '9999 AA' (if (hl7:postalCode/text() and $isDutchAddress) then ( matches($postalCodeText,'^[0-9]{4} [A-Z]{2}$')) else ( true() ) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD.NL)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="illegalAddressPart" select="*[not(self::hl7:delimiter|self::hl7:country|self::hl7:county|self::hl7:city|self::hl7:postalCode|self::hl7:houseNumber|self::hl7:buildingNumberSuffix|self::hl7:streetName|self::hl7:additionalLocator|self::hl7:unitID|self::hl7:useablePeriod)]/name()"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($isDutchAddress) or empty($illegalAddressPart)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-AD.NL: binnen Nederland mogen alleen delimiter, country, county, city, postalCode, houseNumber, buildingNumberSuffix, streetName, additionalLocator, unitID en useablePeriod worden gebruikt. Gevonden '<axsl:text/>
               <axsl:value-of select="$illegalAddressPart"/>
               <axsl:text/>'. (not($isDutchAddress) or empty($illegalAddressPart) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD.NL)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="illegalCodedAddressPart" select="*[not(self::hl7:postalCode|self::hl7:country|self::hl7:county)][@code]/name()"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($isDutchAddress) or empty($illegalCodedAddressPart)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-AD.NL: alleen postalCode, country en county kunnen gecodeerd worden. Gevonden '<axsl:text/>
               <axsl:value-of select="$illegalCodedAddressPart"/>
               <axsl:text/>' (not($isDutchAddress) or empty($illegalCodedAddressPart) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD.NL)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:streetName) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:streetName komt te vaak voor [max 1x]. (count(hl7:streetName) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:houseNumber) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:houseNumber komt te vaak voor [max 1x]. (count(hl7:houseNumber) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:buildingNumberSuffix) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:buildingNumberSuffix komt te vaak voor [max 1x]. (count(hl7:buildingNumberSuffix) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:additionalLocator) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:additionalLocator komt te vaak voor [max 1x]. (count(hl7:additionalLocator) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:postalCode komt te vaak voor [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:county) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:county komt te vaak voor [max 1x]. (count(hl7:county) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:city) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:city komt te vaak voor [max 1x]. (count(hl7:city) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:country) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:country komt te vaak voor [max 1x]. (count(hl7:country) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:unitID) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:unitID komt te vaak voor [max 1x]. (count(hl7:unitID) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:useablePeriod) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:useablePeriod komt te vaak voor [max 1x]. (count(hl7:useablePeriod) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60153e38-false-d60160e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:streetName" priority="1056" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')"/>
         <axsl:otherwise>
            <axsl:message>(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.101)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60153e49-false-d60172e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:houseNumber" priority="1055" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')"/>
         <axsl:otherwise>
            <axsl:message>(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.101)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60153e62-false-d60184e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:buildingNumberSuffix" priority="1054" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')"/>
         <axsl:otherwise>
            <axsl:message>(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.101)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60153e102-false-d60196e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:additionalLocator" priority="1053" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')"/>
         <axsl:otherwise>
            <axsl:message>(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.101)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="text()='to' or text()='by'"/>
         <axsl:otherwise>
            <axsl:message>(address NL - generic): de elementinhoud van hl7:additionalLocator MOET ''to' of 'by'' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="."/>
               <axsl:text/>" (text()='to' or text()='by' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.101)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60153e114-false-d60216e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:postalCode" priority="1052" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="value" select="."/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[.=$value])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ADXP: [RIM-002] <axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/> (<axsl:text/>
               <axsl:value-of select="$value"/>
               <axsl:text/>) SHALL be distinct (not($set_other[.=$value]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ADXP)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')"/>
         <axsl:otherwise>
            <axsl:message>(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ADXP" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.101)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60153e144-false-d60230e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:county" priority="1051" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="value" select="."/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[.=$value])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ADXP: [RIM-002] <axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/> (<axsl:text/>
               <axsl:value-of select="$value"/>
               <axsl:text/>) SHALL be distinct (not($set_other[.=$value]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ADXP)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')"/>
         <axsl:otherwise>
            <axsl:message>(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ADXP" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.101)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60153e152-false-d60242e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:city" priority="1050" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')"/>
         <axsl:otherwise>
            <axsl:message>(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.101)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60153e160-false-d60254e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:country" priority="1049" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="value" select="."/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[.=$value])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ADXP: [RIM-002] <axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/> (<axsl:text/>
               <axsl:value-of select="$value"/>
               <axsl:text/>) SHALL be distinct (not($set_other[.=$value]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ADXP)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')"/>
         <axsl:otherwise>
            <axsl:message>(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ADXP" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.101)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60153e195-false-d60268e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:unitID" priority="1048" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')"/>
         <axsl:otherwise>
            <axsl:message>(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.101)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60153e211-false-d60280e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:useablePeriod" priority="1047" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_QTY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_QTY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-QTY: [RIM-001] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> SHALL NOT have nullFlavor, if there are other <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_QTY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="value" select="@value"/>
      <axsl:variable name="unit" select="@unit"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[@value=$value][@unit=$unit])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-QTY: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> (@value=<axsl:text/>
               <axsl:value-of select="$value"/>
               <axsl:text/> @unit=<axsl:text/>
               <axsl:value-of select="$unit"/>
               <axsl:text/>) SHALL be distinct (not($set_other[@value=$value][@unit=$unit]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_QTY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-TS: null or value or child element in case of extension ((@nullFlavor or @value or *) and not(@nullFlavor and @value) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theTS" select="@value"/>
      <axsl:variable name="theBC" select="if (starts-with($theTS,'-')) then '-' else ()"/>
      <axsl:variable name="theTZ" select="replace($theTS,'^-?[^+-]+([+-]\d{1,4})?$','$1')"/>
      <axsl:variable name="theTZh" select="if (string-length($theTZ) gt 0) then substring(concat($theTZ, '0000'), 1, 3) else ()"/>
      <axsl:variable name="theTZm" select="if (string-length($theTZ) gt 0) then substring(concat($theTZ, '0000'), 4, 2) else ()"/>
      <axsl:variable name="theBaseTS" select="replace($theTS,'^-?([^+-]+)([+-].*)?','$1')"/>
      <axsl:variable name="theCentury" select="if (substring($theBaseTS,1,2) castable as xs:integer) then substring($theBaseTS,1,2) else ()"/>
      <axsl:variable name="theYear" select="if (substring($theBaseTS,3,2) castable as xs:integer) then substring($theBaseTS,3,2) else ()"/>
      <axsl:variable name="theMonth" select="if (substring($theBaseTS,5,2) castable as xs:integer) then substring($theBaseTS,5,2) else ()"/>
      <axsl:variable name="theDay" select="if (substring($theBaseTS,7,2) castable as xs:integer) then substring($theBaseTS,7,2) else ()"/>
      <axsl:variable name="theHour" select="if (substring($theBaseTS,9,2) castable as xs:integer) then substring($theBaseTS,9,2) else ()"/>
      <axsl:variable name="theMinute" select="if (substring($theBaseTS,11,2) castable as xs:integer) then substring($theBaseTS,11,2) else ()"/>
      <axsl:variable name="theSecond" select="if (substring($theBaseTS,13,2) castable as xs:integer) then substring($theBaseTS,13,2) else ()"/>
      <axsl:variable name="theSubSecond" select="if (substring($theBaseTS,16) castable as xs:integer) then substring($theBaseTS,15) else ()"/>
      <axsl:variable name="cCentury" select="if (empty($theCentury)) then '00' else $theCentury"/>
      <axsl:variable name="cYear" select="if (empty($theYear)) then '00' else $theYear"/>
      <axsl:variable name="cMonth" select="if (empty($theMonth)) then '01' else $theMonth"/>
      <axsl:variable name="cDay" select="if (empty($theDay)) then '01' else $theDay"/>
      <axsl:variable name="cHour" select="if (empty($theHour)) then '00' else $theHour"/>
      <axsl:variable name="cMinute" select="if (empty($theMinute)) then '00' else $theMinute"/>
      <axsl:variable name="cSecond" select="if (empty($theSecond)) then '00' else $theSecond"/>
      <axsl:variable name="cTZ" select="string-join(($theTZh, $theTZm),':')"/>
      <axsl:variable name="theTSString" select="string-join(($theBC,$theCentury,$theYear,$theMonth,$theDay,$theHour,$theMinute,$theSecond,$theSubSecond,$theTZ),'')"/>
      <axsl:variable name="theDateTime" select="concat($theBC,$cCentury,$cYear,'-',$cMonth,'-',$cDay,'T',$cHour,':',$cMinute,':',$cSecond,$theSubSecond,$cTZ)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-TS: <axsl:text/>
               <axsl:value-of select="local-name()"/>
               <axsl:text/> "<axsl:text/>
               <axsl:value-of select="$theTS"/>
               <axsl:text/>" is not a valid timestamp. (empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @operator) or @operator = 'I'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-SXCM_TS: not operator if null (not(@nullFlavor and @operator) or @operator = 'I' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_SXCM_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(descendant-or-self::*[@nullFlavor and (@value|@unit|hl7:low|hl7:center|hl7:high|hl7:width)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-IVL_TS: null violation. Cannot have @nullFlavor and @value or other child elements (not(descendant-or-self::*[@nullFlavor and (@value|@unit|hl7:low|hl7:center|hl7:high|hl7:width)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value and hl7:*)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-IVL_TS: co-occurence violation. Cannot have @value and other child elements (not(@value and hl7:*) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value and (hl7:low|hl7:center|hl7:high|hl7:width))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-2-IVL_TS: co-occurence violation. Cannot have @value and child elements (not(@value and (hl7:low|hl7:center|hl7:high|hl7:width)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:center and (hl7:low|hl7:high|hl7:width))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-3-IVL_TS: co-occurence violation. Cannot have center and other elements (not(hl7:center and (hl7:low|hl7:high|hl7:width)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:width and hl7:low and hl7:high)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-4-IVL_TS: co-occurence violation. Cannot have width and have both low and high elements (not(hl7:width and hl7:low and hl7:high) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:*[@updateMode])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-IVL_TS: no updateMode on IVL attributes (not(hl7:*[@updateMode]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:low/@value = hl7:high/@value)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-IVL_TS: low/@value must not be equal to high/@value (not(hl7:low/@value = hl7:high/@value) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:width[@unit][not(@value)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-PQR: width element: no unit without value (not(hl7:width[@unit][not(@value)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:width/hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-PQR: width element: no translation (not(hl7:width/hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:low[@nullFlavor='PINF'])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-1-IVL_TS: low must be lower than or equal to high. Found low boundary PINF (Positive Infinity) (not(hl7:low[@nullFlavor='PINF']) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:high[@nullFlavor='NINF'])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-2-IVL_TS: low must be lower than or equal to high. Found high boundary NINF (Negative Infinity) (not(hl7:high[@nullFlavor='NINF']) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="tum" select="'^(us|ms|s|min|h|d|wk|mo|a|)$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="matches(hl7:width/@unit, $tum)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-IVL_TS: for width only us (microseconds), ms (milliseconds), s (seconds), min (minute), h (hours), d (day), wk (week), mo (month) or a (year) are allowed (matches(hl7:width/@unit, $tum) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theTSLow" select="hl7:low/@value"/>
      <axsl:variable name="theBCLow" select="if (starts-with($theTSLow,'-')) then '-' else ()"/>
      <axsl:variable name="theTZLow" select="replace($theTSLow,'-?[^+-]+([+-].*)?$','$1')"/>
      <axsl:variable name="theTZhLow" select="if (string-length($theTZLow)&gt;0) then substring($theTZLow,1,3) else ()"/>
      <axsl:variable name="theTZmLow" select="if (string-length($theTZLow)&gt;3) then substring($theTZLow,4) else ()"/>
      <axsl:variable name="theBaseTSLow" select="replace($theTSLow,'^-?([^+-]+)([+-].*)?','$1')"/>
      <axsl:variable name="theCenturyLow" select="if (substring($theBaseTSLow,1,2) castable as xs:integer) then substring($theBaseTSLow,1,2) else ()"/>
      <axsl:variable name="theYearLow" select="if (substring($theBaseTSLow,3,2) castable as xs:integer) then substring($theBaseTSLow,3,2) else ()"/>
      <axsl:variable name="theMonthLow" select="if (substring($theBaseTSLow,5,2) castable as xs:integer) then substring($theBaseTSLow,5,2) else ()"/>
      <axsl:variable name="theDayLow" select="if (substring($theBaseTSLow,7,2) castable as xs:integer) then substring($theBaseTSLow,7,2) else ()"/>
      <axsl:variable name="theHourLow" select="if (substring($theBaseTSLow,9,2) castable as xs:integer) then substring($theBaseTSLow,9,2) else ()"/>
      <axsl:variable name="theMinuteLow" select="if (substring($theBaseTSLow,11,2) castable as xs:integer) then substring($theBaseTSLow,11,2) else ()"/>
      <axsl:variable name="theSecondLow" select="if (substring($theBaseTSLow,13,2) castable as xs:integer) then substring($theBaseTSLow,13,2) else ()"/>
      <axsl:variable name="theSubSecondLow" select="if (substring($theBaseTSLow,16) castable as xs:integer) then substring($theBaseTSLow,15) else ()"/>
      <axsl:variable name="cCenturyLow" select="if (empty($theCenturyLow)) then '00' else $theCenturyLow"/>
      <axsl:variable name="cYearLow" select="if (empty($theYearLow)) then '00' else $theYearLow"/>
      <axsl:variable name="cMonthLow" select="if (empty($theMonthLow)) then '01' else $theMonthLow"/>
      <axsl:variable name="cDayLow" select="if (empty($theDayLow)) then '01' else $theDayLow"/>
      <axsl:variable name="cHourLow" select="if (empty($theHourLow)) then '00' else $theHourLow"/>
      <axsl:variable name="cMinuteLow" select="if (empty($theMinuteLow)) then '00' else $theMinuteLow"/>
      <axsl:variable name="cSecondLow" select="if (empty($theSecondLow)) then '00' else $theSecondLow"/>
      <axsl:variable name="cTZLow" select="string-join(($theTZhLow,$theTZmLow),':')"/>
      <axsl:variable name="theTSStringLow" select="string-join(($theBCLow,$theCenturyLow,$theYearLow,$theMonthLow,$theDayLow,$theHourLow,$theMinuteLow,$theSecondLow,$theSubSecondLow,$theTZLow),'')"/>
      <axsl:variable name="theLowDateTime" select="concat($theBCLow,$cCenturyLow,$cYearLow,'-',$cMonthLow,'-',$cDayLow,'T',$cHourLow,':',$cMinuteLow,':',$cSecondLow,$theSubSecondLow,$cTZLow)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTSLow) or ($theTSLow=$theTSStringLow and $theLowDateTime castable as xs:dateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-IVL_TS: <axsl:text/>
               <axsl:value-of select="local-name()"/>
               <axsl:text/>/low "<axsl:text/>
               <axsl:value-of select="$theTSLow"/>
               <axsl:text/>" is not a valid timestamp. (empty($theTSLow) or ($theTSLow=$theTSStringLow and $theLowDateTime castable as xs:dateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theTSCenter" select="hl7:center/@value"/>
      <axsl:variable name="theBCCenter" select="if (starts-with($theTSCenter,'-')) then '-' else ()"/>
      <axsl:variable name="theTZCenter" select="replace($theTSCenter,'-?[^+-]+([+-].*)?$','$1')"/>
      <axsl:variable name="theTZhCenter" select="if (string-length($theTZCenter)&gt;0) then substring($theTZCenter,1,3) else ()"/>
      <axsl:variable name="theTZmCenter" select="if (string-length($theTZCenter)&gt;3) then substring($theTZCenter,4) else ()"/>
      <axsl:variable name="theBaseTSCenter" select="replace($theTSCenter,'^-?([^+-]+)([+-].*)?','$1')"/>
      <axsl:variable name="theCenturyCenter" select="if (substring($theBaseTSCenter,1,2) castable as xs:integer) then substring($theBaseTSCenter,1,2) else ()"/>
      <axsl:variable name="theYearCenter" select="if (substring($theBaseTSCenter,3,2) castable as xs:integer) then substring($theBaseTSCenter,3,2) else ()"/>
      <axsl:variable name="theMonthCenter" select="if (substring($theBaseTSCenter,5,2) castable as xs:integer) then substring($theBaseTSCenter,5,2) else ()"/>
      <axsl:variable name="theDayCenter" select="if (substring($theBaseTSCenter,7,2) castable as xs:integer) then substring($theBaseTSCenter,7,2) else ()"/>
      <axsl:variable name="theHourCenter" select="if (substring($theBaseTSCenter,9,2) castable as xs:integer) then substring($theBaseTSCenter,9,2) else ()"/>
      <axsl:variable name="theMinuteCenter" select="if (substring($theBaseTSCenter,11,2) castable as xs:integer) then substring($theBaseTSCenter,11,2) else ()"/>
      <axsl:variable name="theSecondCenter" select="if (substring($theBaseTSCenter,13,2) castable as xs:integer) then substring($theBaseTSCenter,13,2) else ()"/>
      <axsl:variable name="theSubSecondCenter" select="if (substring($theBaseTSCenter,16) castable as xs:integer) then substring($theBaseTSCenter,15) else ()"/>
      <axsl:variable name="cCenturyCenter" select="if (empty($theCenturyCenter)) then '00' else $theCenturyCenter"/>
      <axsl:variable name="cYearCenter" select="if (empty($theYearCenter)) then '00' else $theYearCenter"/>
      <axsl:variable name="cMonthCenter" select="if (empty($theMonthCenter)) then '01' else $theMonthCenter"/>
      <axsl:variable name="cDayCenter" select="if (empty($theDayCenter)) then '01' else $theDayCenter"/>
      <axsl:variable name="cHourCenter" select="if (empty($theHourCenter)) then '00' else $theHourCenter"/>
      <axsl:variable name="cMinuteCenter" select="if (empty($theMinuteCenter)) then '00' else $theMinuteCenter"/>
      <axsl:variable name="cSecondCenter" select="if (empty($theSecondCenter)) then '00' else $theSecondCenter"/>
      <axsl:variable name="cTZCenter" select="string-join(($theTZhCenter,$theTZmCenter),':')"/>
      <axsl:variable name="theTSStringCenter" select="string-join(($theBCCenter,$theCenturyCenter,$theYearCenter,$theMonthCenter,$theDayCenter,$theHourCenter,$theMinuteCenter,$theSecondCenter,$theSubSecondCenter,$theTZCenter),'')"/>
      <axsl:variable name="theCenterDateTime" select="concat($theBCCenter,$cCenturyCenter,$cYearCenter,'-',$cMonthCenter,'-',$cDayCenter,'T',$cHourCenter,':',$cMinuteCenter,':',$cSecondCenter,$theSubSecondCenter,$cTZCenter)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTSCenter) or ($theTSCenter=$theTSStringCenter and $theCenterDateTime castable as xs:dateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-IVL_TS: <axsl:text/>
               <axsl:value-of select="local-name()"/>
               <axsl:text/>/center "<axsl:text/>
               <axsl:value-of select="$theTSCenter"/>
               <axsl:text/>" is not a valid timestamp. (empty($theTSCenter) or ($theTSCenter=$theTSStringCenter and $theCenterDateTime castable as xs:dateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theTSHigh" select="hl7:high/@value"/>
      <axsl:variable name="theBCHigh" select="if (starts-with($theTSHigh,'-')) then '-' else ()"/>
      <axsl:variable name="theTZHigh" select="replace($theTSHigh,'-?[^+-]+([+-].*)?$','$1')"/>
      <axsl:variable name="theTZhHigh" select="if (string-length($theTZHigh)&gt;0) then substring($theTZHigh,1,3) else ()"/>
      <axsl:variable name="theTZmHigh" select="if (string-length($theTZHigh)&gt;3) then substring($theTZHigh,4) else ()"/>
      <axsl:variable name="theBaseTSHigh" select="replace($theTSHigh,'^-?([^+-]+)([+-].*)?','$1')"/>
      <axsl:variable name="theCenturyHigh" select="if (substring($theBaseTSHigh,1,2) castable as xs:integer) then substring($theBaseTSHigh,1,2) else ()"/>
      <axsl:variable name="theYearHigh" select="if (substring($theBaseTSHigh,3,2) castable as xs:integer) then substring($theBaseTSHigh,3,2) else ()"/>
      <axsl:variable name="theMonthHigh" select="if (substring($theBaseTSHigh,5,2) castable as xs:integer) then substring($theBaseTSHigh,5,2) else ()"/>
      <axsl:variable name="theDayHigh" select="if (substring($theBaseTSHigh,7,2) castable as xs:integer) then substring($theBaseTSHigh,7,2) else ()"/>
      <axsl:variable name="theHourHigh" select="if (substring($theBaseTSHigh,9,2) castable as xs:integer) then substring($theBaseTSHigh,9,2) else ()"/>
      <axsl:variable name="theMinuteHigh" select="if (substring($theBaseTSHigh,11,2) castable as xs:integer) then substring($theBaseTSHigh,11,2) else ()"/>
      <axsl:variable name="theSecondHigh" select="if (substring($theBaseTSHigh,13,2) castable as xs:integer) then substring($theBaseTSHigh,13,2) else ()"/>
      <axsl:variable name="theSubSecondHigh" select="if (substring($theBaseTSHigh,16) castable as xs:integer) then substring($theBaseTSHigh,15) else ()"/>
      <axsl:variable name="cCenturyHigh" select="if (empty($theCenturyHigh)) then '00' else $theCenturyHigh"/>
      <axsl:variable name="cYearHigh" select="if (empty($theYearHigh)) then '00' else $theYearHigh"/>
      <axsl:variable name="cMonthHigh" select="if (empty($theMonthHigh)) then '01' else $theMonthHigh"/>
      <axsl:variable name="cDayHigh" select="if (empty($theDayHigh)) then '01' else $theDayHigh"/>
      <axsl:variable name="cHourHigh" select="if (empty($theHourHigh)) then '00' else $theHourHigh"/>
      <axsl:variable name="cMinuteHigh" select="if (empty($theMinuteHigh)) then '00' else $theMinuteHigh"/>
      <axsl:variable name="cSecondHigh" select="if (empty($theSecondHigh)) then '00' else $theSecondHigh"/>
      <axsl:variable name="cTZHigh" select="string-join(($theTZhHigh,$theTZmHigh),':')"/>
      <axsl:variable name="theTSStringHigh" select="string-join(($theBCHigh,$theCenturyHigh,$theYearHigh,$theMonthHigh,$theDayHigh,$theHourHigh,$theMinuteHigh,$theSecondHigh,$theSubSecondHigh,$theTZHigh),'')"/>
      <axsl:variable name="theHighDateTime" select="concat($theBCHigh,$cCenturyHigh,$cYearHigh,'-',$cMonthHigh,'-',$cDayHigh,'T',$cHourHigh,':',$cMinuteHigh,':',$cSecondHigh,$theSubSecondHigh,$cTZHigh)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTSHigh) or ($theTSHigh=$theTSStringHigh and $theHighDateTime castable as xs:dateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-IVL_TS: <axsl:text/>
               <axsl:value-of select="local-name()"/>
               <axsl:text/>/high "<axsl:text/>
               <axsl:value-of select="$theTSHigh"/>
               <axsl:text/>" is not a valid timestamp. (empty($theTSHigh) or ($theTSHigh=$theTSStringHigh and $theHighDateTime castable as xs:dateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTSLow) or empty($theTSHigh) or not($theLowDateTime castable as xs:dateTime) or not($theHighDateTime castable as xs:dateTime) or xs:dateTime($theLowDateTime) le xs:dateTime($theHighDateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-IVL_TS: low/@value (<axsl:text/>
               <axsl:value-of select="$theTSLow"/>
               <axsl:text/>) must be before high/@value (<axsl:text/>
               <axsl:value-of select="$theTSHigh"/>
               <axsl:text/>) (empty($theTSLow) or empty($theTSHigh) or not($theLowDateTime castable as xs:dateTime) or not($theHighDateTime castable as xs:dateTime) or xs:dateTime($theLowDateTime) le xs:dateTime($theHighDateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')"/>
         <axsl:otherwise>
            <axsl:message>(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.101)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d59877e44-false-d60296e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]" priority="1046" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:name) &gt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:name) &lt;= 2"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:name komt te vaak voor [max 2x]. (count(hl7:name) &lt;= 2 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]) &gt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code] is required [min 1x]. (count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]) &gt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code] komt te vaak voor [max 1x]. (count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:birthTime) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:birthTime komt te vaak voor [max 1x]. (count(hl7:birthTime) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(sdtc:multipleBirthInd) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element sdtc:multipleBirthInd komt te vaak voor [max 1x]. (count(sdtc:multipleBirthInd) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d59877e46-false-d60358e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name" priority="1045" mode="M15">
      <axsl:variable name="theAttValue" select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@use) or empty($theAttValue[not(. = (('L','A','OR')))])"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): de waarde van use MOET 'code L of code A of code OR' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@use"/>
               <axsl:text/>" (not(@use) or empty($theAttValue[not(. = (('L','A','OR')))]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and (* or string-length(normalize-space(string-join(text(),'')))&gt;0))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1.1-EN: entity name shall not be null and have elements or text (not(@nullFlavor and (* or string-length(normalize-space(string-join(text(),'')))&gt;0)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(* and string-length(normalize-space(string-join(text(),'')))&gt;0)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1.2-EN: entity name shall not have both elements and text (no mixed content) (not(* and string-length(normalize-space(string-join(text(),'')))&gt;0) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or * or string-length(normalize-space(string-join(text(),'')))&gt;0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1.3-EN: entity name that is not null shall not be empty (@nullFlavor or * or string-length(normalize-space(string-join(text(),'')))&gt;0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="*[not(self::*:validTime | @nullFlavor)][normalize-space(.)='']">
         <axsl:message>dtr1-3-EN: empty name particles should not be present. (*[not(self::*:validTime | @nullFlavor)][normalize-space(.)=''] / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
      </axsl:if>

		<!--REPORT warning-->

      <axsl:if test="substring(normalize-space(.),1,1)='&#34;'">
         <axsl:message>dtr1-4-EN: Use of quotes at the beginning of a name are probably not correct. (substring(normalize-space(.),1,1)='"' / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
      </axsl:if>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="value" select="string-join((.//@use|.//text()),'')"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-EN: [RIM-001] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> SHALL NOT have nullFlavor, if there are other <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[string-join((.//@use|.//text()),'')=$value])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-EN: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> (<axsl:text/>
               <axsl:value-of select="$value"/>
               <axsl:text/>) SHALL be distinct (not($set_other[string-join((.//@use|.//text()),'')=$value]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-EN: enxp elements SHALL have distinct values in @qualifier (not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(*[tokenize(@qualifier,'\s')='LS'])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-PN: Person names SHALL NOT contain a name part qualified with 'LS' (Legal status for organizations) (not(*[tokenize(@qualifier,'\s')='LS']) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_PN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(*[tokenize(@qualifier,'\s')='LS'])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-PN: Person names SHALL NOT contain a name part qualified with 'LS' (Legal status for organizations) (not(*[tokenize(@qualifier,'\s')='LS']) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_PN.NL)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:given[contains(@qualifier,'IN')]) or hl7:given[contains(@qualifier,'IN') and not(starts-with(text(),'.')) and contains(text(),'.') and ends-with(text(),'.')]"/>
         <axsl:otherwise>
            <axsl:message>Datatype PN: als given/@qualifier 'IN' bevat dan moeten er initialen gescheiden en gevolgd door een punt in het element given staan. (not(hl7:given[contains(@qualifier,'IN')]) or hl7:given[contains(@qualifier,'IN') and not(starts-with(text(),'.')) and contains(text(),'.') and ends-with(text(),'.')] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_PN.NL)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:given[contains(@qualifier,'IN') and contains(@qualifier,'CL')])"/>
         <axsl:otherwise>
            <axsl:message>Datatype PN: given/@qualifier 'IN' en 'CL' gaan niet samen. Initalen zijn geen roepnaam (not(hl7:given[contains(@qualifier,'IN') and contains(@qualifier,'CL')]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_PN.NL)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:given[contains(@qualifier,'CL') and contains(text(),'.')])"/>
         <axsl:otherwise>
            <axsl:message>Datatype PN: als given/@qualifier 'CL' bevat dan moeten er voornamen in dit element staan. Voornamen hebben geen puntjes. (not(hl7:given[contains(@qualifier,'CL') and contains(text(),'.')]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_PN.NL)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="hl7:prefix[@qualifier='VV' and not(ends-with(text(),' '))]">
         <axsl:message>Datatype PN: als er een spatie tussen een voorvoegsel en de bijbehorende achternaam hoort, moet het prefix element met qualifier=VV ook eindigen met een spatie. (hl7:prefix[@qualifier='VV' and not(ends-with(text(),' '))] / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_PN.NL)</axsl:message>
      </axsl:if>

		<!--REPORT warning-->

      <axsl:if test="hl7:family[substring(.,1,4)='van '] or hl7:family[substring(.,1,3)=('de ','in ')]">
         <axsl:message>Datatype PN: voorvoegsels moeten in het prefix element worden gevoerd, tenzij het bronsysteem voorvoegsels en achternaam niet gescheiden vastlegt. (hl7:family[substring(.,1,4)='van '] or hl7:family[substring(.,1,3)=('de ','in ')] / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_PN.NL)</axsl:message>
      </axsl:if>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:prefix[@qualifier='NB']) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:prefix[@qualifier='NB'] komt te vaak voor [max 1x]. (count(hl7:prefix[@qualifier='NB']) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:given[@qualifier='BR']) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:given[@qualifier='BR'] komt te vaak voor [max 1x]. (count(hl7:given[@qualifier='BR']) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:given[@qualifier='CL']) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:given[@qualifier='CL'] komt te vaak voor [max 1x]. (count(hl7:given[@qualifier='CL']) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:given[@qualifier='IN']) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:given[@qualifier='IN'] komt te vaak voor [max 1x]. (count(hl7:given[@qualifier='IN']) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:given[not(@qualifier)]) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:given[not(@qualifier)] komt te vaak voor [max 1x]. (count(hl7:given[not(@qualifier)]) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:prefix[not(@qualifier)]) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:prefix[not(@qualifier)] komt te vaak voor [max 1x]. (count(hl7:prefix[not(@qualifier)]) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:family[not(@qualifier)]) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:family[not(@qualifier)] komt te vaak voor [max 1x]. (count(hl7:family[not(@qualifier)]) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][tokenize(@qualifier,'\s')='BR']]) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][tokenize(@qualifier,'\s')='BR']] komt te vaak voor [max 1x]. (count(hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][tokenize(@qualifier,'\s')='BR']]) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:family[tokenize(@qualifier,'\s')='BR']) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:family[tokenize(@qualifier,'\s')='BR'] komt te vaak voor [max 1x]. (count(hl7:family[tokenize(@qualifier,'\s')='BR']) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:delimiter[not(@nullFlavor)]) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:delimiter[not(@nullFlavor)] komt te vaak voor [max 1x]. (count(hl7:delimiter[not(@nullFlavor)]) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][tokenize(@qualifier,'\s')='SP']]) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][tokenize(@qualifier,'\s')='SP']] komt te vaak voor [max 1x]. (count(hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][tokenize(@qualifier,'\s')='SP']]) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:family[tokenize(@qualifier,'\s')='SP']) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:family[tokenize(@qualifier,'\s')='SP'] komt te vaak voor [max 1x]. (count(hl7:family[tokenize(@qualifier,'\s')='SP']) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:suffix[not(@nullFlavor)]) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:suffix[not(@nullFlavor)] komt te vaak voor [max 1x]. (count(hl7:suffix[not(@nullFlavor)]) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:validTime) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): element hl7:validTime komt te vaak voor [max 1x]. (count(hl7:validTime) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(*) or (hl7:given and hl7:family)"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): In een gestructureerde naam moet minimaal één voornaam, initiaal of roepnaam en minimaal één geslachtsnaam of geslachtsnaam partner van een persoon aanwezig zijn, inclusief voorvoegsel(s) indien van toepassing (not(*) or (hl7:given and hl7:family) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60490e260-false-d60497e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:prefix[@qualifier='NB']" priority="1044" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@qualifier) = ('NB')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): de waarde van qualifier MOET 'NB' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@qualifier"/>
               <axsl:text/>" (string(@qualifier) = ('NB') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): attribute @nullFlavor MAG NIET voorkomen. (not(@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60490e279-false-d60518e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:given[@qualifier='BR']" priority="1043" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@qualifier) = ('BR')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): de waarde van qualifier MOET 'BR' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@qualifier"/>
               <axsl:text/>" (string(@qualifier) = ('BR') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): attribute @nullFlavor MAG NIET voorkomen. (not(@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60490e298-false-d60539e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:given[@qualifier='CL']" priority="1042" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@qualifier) = ('CL')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): de waarde van qualifier MOET 'CL' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@qualifier"/>
               <axsl:text/>" (string(@qualifier) = ('CL') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): attribute @nullFlavor MAG NIET voorkomen. (not(@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60490e318-false-d60560e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:given[@qualifier='IN']" priority="1041" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@qualifier) = ('IN')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): de waarde van qualifier MOET 'IN' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@qualifier"/>
               <axsl:text/>" (string(@qualifier) = ('IN') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): attribute @nullFlavor MAG NIET voorkomen. (not(@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60490e337-false-d60581e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:given[not(@qualifier)]" priority="1040" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60490e346-false-d60591e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:prefix[not(@qualifier)]" priority="1039" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60490e355-false-d60601e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:family[not(@qualifier)]" priority="1038" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60490e364-false-d60611e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][tokenize(@qualifier,'\s')='BR']]" priority="1037" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@qualifier) = ('VV')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): de waarde van qualifier MOET 'VV' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@qualifier"/>
               <axsl:text/>" (string(@qualifier) = ('VV') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): attribute @nullFlavor MAG NIET voorkomen. (not(@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60490e397-false-d60632e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:family[tokenize(@qualifier,'\s')='BR']" priority="1036" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@qualifier) = ('BR')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): de waarde van qualifier MOET 'BR' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@qualifier"/>
               <axsl:text/>" (string(@qualifier) = ('BR') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): attribute @nullFlavor MAG NIET voorkomen. (not(@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60490e417-false-d60655e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:delimiter[not(@nullFlavor)]" priority="1035" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): attribute @nullFlavor MAG NIET voorkomen. (not(@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60490e446-false-d60670e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][tokenize(@qualifier,'\s')='SP']]" priority="1034" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@qualifier) = ('VV')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): de waarde van qualifier MOET 'VV' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@qualifier"/>
               <axsl:text/>" (string(@qualifier) = ('VV') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): attribute @nullFlavor MAG NIET voorkomen. (not(@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60490e479-false-d60691e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:family[tokenize(@qualifier,'\s')='SP']" priority="1033" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@qualifier) = ('SP')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): de waarde van qualifier MOET 'SP' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@qualifier"/>
               <axsl:text/>" (string(@qualifier) = ('SP') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): attribute @nullFlavor MAG NIET voorkomen. (not(@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60490e498-false-d60714e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:suffix[not(@nullFlavor)]" priority="1032" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@qualifier) = ('AC') or not(@qualifier)"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): de waarde van qualifier MOET 'AC' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@qualifier"/>
               <axsl:text/>" (string(@qualifier) = ('AC') or not(@qualifier) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): attribute @nullFlavor MAG NIET voorkomen. (not(@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60490e537-false-d60737e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:validTime" priority="1031" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_QTY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_QTY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-QTY: [RIM-001] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> SHALL NOT have nullFlavor, if there are other <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_QTY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="value" select="@value"/>
      <axsl:variable name="unit" select="@unit"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[@value=$value][@unit=$unit])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-QTY: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> (@value=<axsl:text/>
               <axsl:value-of select="$value"/>
               <axsl:text/> @unit=<axsl:text/>
               <axsl:value-of select="$unit"/>
               <axsl:text/>) SHALL be distinct (not($set_other[@value=$value][@unit=$unit]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_QTY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-TS: null or value or child element in case of extension ((@nullFlavor or @value or *) and not(@nullFlavor and @value) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theTS" select="@value"/>
      <axsl:variable name="theBC" select="if (starts-with($theTS,'-')) then '-' else ()"/>
      <axsl:variable name="theTZ" select="replace($theTS,'^-?[^+-]+([+-]\d{1,4})?$','$1')"/>
      <axsl:variable name="theTZh" select="if (string-length($theTZ) gt 0) then substring(concat($theTZ, '0000'), 1, 3) else ()"/>
      <axsl:variable name="theTZm" select="if (string-length($theTZ) gt 0) then substring(concat($theTZ, '0000'), 4, 2) else ()"/>
      <axsl:variable name="theBaseTS" select="replace($theTS,'^-?([^+-]+)([+-].*)?','$1')"/>
      <axsl:variable name="theCentury" select="if (substring($theBaseTS,1,2) castable as xs:integer) then substring($theBaseTS,1,2) else ()"/>
      <axsl:variable name="theYear" select="if (substring($theBaseTS,3,2) castable as xs:integer) then substring($theBaseTS,3,2) else ()"/>
      <axsl:variable name="theMonth" select="if (substring($theBaseTS,5,2) castable as xs:integer) then substring($theBaseTS,5,2) else ()"/>
      <axsl:variable name="theDay" select="if (substring($theBaseTS,7,2) castable as xs:integer) then substring($theBaseTS,7,2) else ()"/>
      <axsl:variable name="theHour" select="if (substring($theBaseTS,9,2) castable as xs:integer) then substring($theBaseTS,9,2) else ()"/>
      <axsl:variable name="theMinute" select="if (substring($theBaseTS,11,2) castable as xs:integer) then substring($theBaseTS,11,2) else ()"/>
      <axsl:variable name="theSecond" select="if (substring($theBaseTS,13,2) castable as xs:integer) then substring($theBaseTS,13,2) else ()"/>
      <axsl:variable name="theSubSecond" select="if (substring($theBaseTS,16) castable as xs:integer) then substring($theBaseTS,15) else ()"/>
      <axsl:variable name="cCentury" select="if (empty($theCentury)) then '00' else $theCentury"/>
      <axsl:variable name="cYear" select="if (empty($theYear)) then '00' else $theYear"/>
      <axsl:variable name="cMonth" select="if (empty($theMonth)) then '01' else $theMonth"/>
      <axsl:variable name="cDay" select="if (empty($theDay)) then '01' else $theDay"/>
      <axsl:variable name="cHour" select="if (empty($theHour)) then '00' else $theHour"/>
      <axsl:variable name="cMinute" select="if (empty($theMinute)) then '00' else $theMinute"/>
      <axsl:variable name="cSecond" select="if (empty($theSecond)) then '00' else $theSecond"/>
      <axsl:variable name="cTZ" select="string-join(($theTZh, $theTZm),':')"/>
      <axsl:variable name="theTSString" select="string-join(($theBC,$theCentury,$theYear,$theMonth,$theDay,$theHour,$theMinute,$theSecond,$theSubSecond,$theTZ),'')"/>
      <axsl:variable name="theDateTime" select="concat($theBC,$cCentury,$cYear,'-',$cMonth,'-',$cDay,'T',$cHour,':',$cMinute,':',$cSecond,$theSubSecond,$cTZ)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-TS: <axsl:text/>
               <axsl:value-of select="local-name()"/>
               <axsl:text/> "<axsl:text/>
               <axsl:value-of select="$theTS"/>
               <axsl:text/>" is not a valid timestamp. (empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @operator) or @operator = 'I'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-SXCM_TS: not operator if null (not(@nullFlavor and @operator) or @operator = 'I' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_SXCM_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(descendant-or-self::*[@nullFlavor and (@value|@unit|hl7:low|hl7:center|hl7:high|hl7:width)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-IVL_TS: null violation. Cannot have @nullFlavor and @value or other child elements (not(descendant-or-self::*[@nullFlavor and (@value|@unit|hl7:low|hl7:center|hl7:high|hl7:width)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value and hl7:*)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-IVL_TS: co-occurence violation. Cannot have @value and other child elements (not(@value and hl7:*) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value and (hl7:low|hl7:center|hl7:high|hl7:width))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-2-IVL_TS: co-occurence violation. Cannot have @value and child elements (not(@value and (hl7:low|hl7:center|hl7:high|hl7:width)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:center and (hl7:low|hl7:high|hl7:width))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-3-IVL_TS: co-occurence violation. Cannot have center and other elements (not(hl7:center and (hl7:low|hl7:high|hl7:width)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:width and hl7:low and hl7:high)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-4-IVL_TS: co-occurence violation. Cannot have width and have both low and high elements (not(hl7:width and hl7:low and hl7:high) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:*[@updateMode])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-IVL_TS: no updateMode on IVL attributes (not(hl7:*[@updateMode]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:low/@value = hl7:high/@value)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-IVL_TS: low/@value must not be equal to high/@value (not(hl7:low/@value = hl7:high/@value) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:width[@unit][not(@value)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-PQR: width element: no unit without value (not(hl7:width[@unit][not(@value)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:width/hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-PQR: width element: no translation (not(hl7:width/hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:low[@nullFlavor='PINF'])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-1-IVL_TS: low must be lower than or equal to high. Found low boundary PINF (Positive Infinity) (not(hl7:low[@nullFlavor='PINF']) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:high[@nullFlavor='NINF'])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-2-IVL_TS: low must be lower than or equal to high. Found high boundary NINF (Negative Infinity) (not(hl7:high[@nullFlavor='NINF']) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="tum" select="'^(us|ms|s|min|h|d|wk|mo|a|)$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="matches(hl7:width/@unit, $tum)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-IVL_TS: for width only us (microseconds), ms (milliseconds), s (seconds), min (minute), h (hours), d (day), wk (week), mo (month) or a (year) are allowed (matches(hl7:width/@unit, $tum) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theTSLow" select="hl7:low/@value"/>
      <axsl:variable name="theBCLow" select="if (starts-with($theTSLow,'-')) then '-' else ()"/>
      <axsl:variable name="theTZLow" select="replace($theTSLow,'-?[^+-]+([+-].*)?$','$1')"/>
      <axsl:variable name="theTZhLow" select="if (string-length($theTZLow)&gt;0) then substring($theTZLow,1,3) else ()"/>
      <axsl:variable name="theTZmLow" select="if (string-length($theTZLow)&gt;3) then substring($theTZLow,4) else ()"/>
      <axsl:variable name="theBaseTSLow" select="replace($theTSLow,'^-?([^+-]+)([+-].*)?','$1')"/>
      <axsl:variable name="theCenturyLow" select="if (substring($theBaseTSLow,1,2) castable as xs:integer) then substring($theBaseTSLow,1,2) else ()"/>
      <axsl:variable name="theYearLow" select="if (substring($theBaseTSLow,3,2) castable as xs:integer) then substring($theBaseTSLow,3,2) else ()"/>
      <axsl:variable name="theMonthLow" select="if (substring($theBaseTSLow,5,2) castable as xs:integer) then substring($theBaseTSLow,5,2) else ()"/>
      <axsl:variable name="theDayLow" select="if (substring($theBaseTSLow,7,2) castable as xs:integer) then substring($theBaseTSLow,7,2) else ()"/>
      <axsl:variable name="theHourLow" select="if (substring($theBaseTSLow,9,2) castable as xs:integer) then substring($theBaseTSLow,9,2) else ()"/>
      <axsl:variable name="theMinuteLow" select="if (substring($theBaseTSLow,11,2) castable as xs:integer) then substring($theBaseTSLow,11,2) else ()"/>
      <axsl:variable name="theSecondLow" select="if (substring($theBaseTSLow,13,2) castable as xs:integer) then substring($theBaseTSLow,13,2) else ()"/>
      <axsl:variable name="theSubSecondLow" select="if (substring($theBaseTSLow,16) castable as xs:integer) then substring($theBaseTSLow,15) else ()"/>
      <axsl:variable name="cCenturyLow" select="if (empty($theCenturyLow)) then '00' else $theCenturyLow"/>
      <axsl:variable name="cYearLow" select="if (empty($theYearLow)) then '00' else $theYearLow"/>
      <axsl:variable name="cMonthLow" select="if (empty($theMonthLow)) then '01' else $theMonthLow"/>
      <axsl:variable name="cDayLow" select="if (empty($theDayLow)) then '01' else $theDayLow"/>
      <axsl:variable name="cHourLow" select="if (empty($theHourLow)) then '00' else $theHourLow"/>
      <axsl:variable name="cMinuteLow" select="if (empty($theMinuteLow)) then '00' else $theMinuteLow"/>
      <axsl:variable name="cSecondLow" select="if (empty($theSecondLow)) then '00' else $theSecondLow"/>
      <axsl:variable name="cTZLow" select="string-join(($theTZhLow,$theTZmLow),':')"/>
      <axsl:variable name="theTSStringLow" select="string-join(($theBCLow,$theCenturyLow,$theYearLow,$theMonthLow,$theDayLow,$theHourLow,$theMinuteLow,$theSecondLow,$theSubSecondLow,$theTZLow),'')"/>
      <axsl:variable name="theLowDateTime" select="concat($theBCLow,$cCenturyLow,$cYearLow,'-',$cMonthLow,'-',$cDayLow,'T',$cHourLow,':',$cMinuteLow,':',$cSecondLow,$theSubSecondLow,$cTZLow)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTSLow) or ($theTSLow=$theTSStringLow and $theLowDateTime castable as xs:dateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-IVL_TS: <axsl:text/>
               <axsl:value-of select="local-name()"/>
               <axsl:text/>/low "<axsl:text/>
               <axsl:value-of select="$theTSLow"/>
               <axsl:text/>" is not a valid timestamp. (empty($theTSLow) or ($theTSLow=$theTSStringLow and $theLowDateTime castable as xs:dateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theTSCenter" select="hl7:center/@value"/>
      <axsl:variable name="theBCCenter" select="if (starts-with($theTSCenter,'-')) then '-' else ()"/>
      <axsl:variable name="theTZCenter" select="replace($theTSCenter,'-?[^+-]+([+-].*)?$','$1')"/>
      <axsl:variable name="theTZhCenter" select="if (string-length($theTZCenter)&gt;0) then substring($theTZCenter,1,3) else ()"/>
      <axsl:variable name="theTZmCenter" select="if (string-length($theTZCenter)&gt;3) then substring($theTZCenter,4) else ()"/>
      <axsl:variable name="theBaseTSCenter" select="replace($theTSCenter,'^-?([^+-]+)([+-].*)?','$1')"/>
      <axsl:variable name="theCenturyCenter" select="if (substring($theBaseTSCenter,1,2) castable as xs:integer) then substring($theBaseTSCenter,1,2) else ()"/>
      <axsl:variable name="theYearCenter" select="if (substring($theBaseTSCenter,3,2) castable as xs:integer) then substring($theBaseTSCenter,3,2) else ()"/>
      <axsl:variable name="theMonthCenter" select="if (substring($theBaseTSCenter,5,2) castable as xs:integer) then substring($theBaseTSCenter,5,2) else ()"/>
      <axsl:variable name="theDayCenter" select="if (substring($theBaseTSCenter,7,2) castable as xs:integer) then substring($theBaseTSCenter,7,2) else ()"/>
      <axsl:variable name="theHourCenter" select="if (substring($theBaseTSCenter,9,2) castable as xs:integer) then substring($theBaseTSCenter,9,2) else ()"/>
      <axsl:variable name="theMinuteCenter" select="if (substring($theBaseTSCenter,11,2) castable as xs:integer) then substring($theBaseTSCenter,11,2) else ()"/>
      <axsl:variable name="theSecondCenter" select="if (substring($theBaseTSCenter,13,2) castable as xs:integer) then substring($theBaseTSCenter,13,2) else ()"/>
      <axsl:variable name="theSubSecondCenter" select="if (substring($theBaseTSCenter,16) castable as xs:integer) then substring($theBaseTSCenter,15) else ()"/>
      <axsl:variable name="cCenturyCenter" select="if (empty($theCenturyCenter)) then '00' else $theCenturyCenter"/>
      <axsl:variable name="cYearCenter" select="if (empty($theYearCenter)) then '00' else $theYearCenter"/>
      <axsl:variable name="cMonthCenter" select="if (empty($theMonthCenter)) then '01' else $theMonthCenter"/>
      <axsl:variable name="cDayCenter" select="if (empty($theDayCenter)) then '01' else $theDayCenter"/>
      <axsl:variable name="cHourCenter" select="if (empty($theHourCenter)) then '00' else $theHourCenter"/>
      <axsl:variable name="cMinuteCenter" select="if (empty($theMinuteCenter)) then '00' else $theMinuteCenter"/>
      <axsl:variable name="cSecondCenter" select="if (empty($theSecondCenter)) then '00' else $theSecondCenter"/>
      <axsl:variable name="cTZCenter" select="string-join(($theTZhCenter,$theTZmCenter),':')"/>
      <axsl:variable name="theTSStringCenter" select="string-join(($theBCCenter,$theCenturyCenter,$theYearCenter,$theMonthCenter,$theDayCenter,$theHourCenter,$theMinuteCenter,$theSecondCenter,$theSubSecondCenter,$theTZCenter),'')"/>
      <axsl:variable name="theCenterDateTime" select="concat($theBCCenter,$cCenturyCenter,$cYearCenter,'-',$cMonthCenter,'-',$cDayCenter,'T',$cHourCenter,':',$cMinuteCenter,':',$cSecondCenter,$theSubSecondCenter,$cTZCenter)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTSCenter) or ($theTSCenter=$theTSStringCenter and $theCenterDateTime castable as xs:dateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-IVL_TS: <axsl:text/>
               <axsl:value-of select="local-name()"/>
               <axsl:text/>/center "<axsl:text/>
               <axsl:value-of select="$theTSCenter"/>
               <axsl:text/>" is not a valid timestamp. (empty($theTSCenter) or ($theTSCenter=$theTSStringCenter and $theCenterDateTime castable as xs:dateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theTSHigh" select="hl7:high/@value"/>
      <axsl:variable name="theBCHigh" select="if (starts-with($theTSHigh,'-')) then '-' else ()"/>
      <axsl:variable name="theTZHigh" select="replace($theTSHigh,'-?[^+-]+([+-].*)?$','$1')"/>
      <axsl:variable name="theTZhHigh" select="if (string-length($theTZHigh)&gt;0) then substring($theTZHigh,1,3) else ()"/>
      <axsl:variable name="theTZmHigh" select="if (string-length($theTZHigh)&gt;3) then substring($theTZHigh,4) else ()"/>
      <axsl:variable name="theBaseTSHigh" select="replace($theTSHigh,'^-?([^+-]+)([+-].*)?','$1')"/>
      <axsl:variable name="theCenturyHigh" select="if (substring($theBaseTSHigh,1,2) castable as xs:integer) then substring($theBaseTSHigh,1,2) else ()"/>
      <axsl:variable name="theYearHigh" select="if (substring($theBaseTSHigh,3,2) castable as xs:integer) then substring($theBaseTSHigh,3,2) else ()"/>
      <axsl:variable name="theMonthHigh" select="if (substring($theBaseTSHigh,5,2) castable as xs:integer) then substring($theBaseTSHigh,5,2) else ()"/>
      <axsl:variable name="theDayHigh" select="if (substring($theBaseTSHigh,7,2) castable as xs:integer) then substring($theBaseTSHigh,7,2) else ()"/>
      <axsl:variable name="theHourHigh" select="if (substring($theBaseTSHigh,9,2) castable as xs:integer) then substring($theBaseTSHigh,9,2) else ()"/>
      <axsl:variable name="theMinuteHigh" select="if (substring($theBaseTSHigh,11,2) castable as xs:integer) then substring($theBaseTSHigh,11,2) else ()"/>
      <axsl:variable name="theSecondHigh" select="if (substring($theBaseTSHigh,13,2) castable as xs:integer) then substring($theBaseTSHigh,13,2) else ()"/>
      <axsl:variable name="theSubSecondHigh" select="if (substring($theBaseTSHigh,16) castable as xs:integer) then substring($theBaseTSHigh,15) else ()"/>
      <axsl:variable name="cCenturyHigh" select="if (empty($theCenturyHigh)) then '00' else $theCenturyHigh"/>
      <axsl:variable name="cYearHigh" select="if (empty($theYearHigh)) then '00' else $theYearHigh"/>
      <axsl:variable name="cMonthHigh" select="if (empty($theMonthHigh)) then '01' else $theMonthHigh"/>
      <axsl:variable name="cDayHigh" select="if (empty($theDayHigh)) then '01' else $theDayHigh"/>
      <axsl:variable name="cHourHigh" select="if (empty($theHourHigh)) then '00' else $theHourHigh"/>
      <axsl:variable name="cMinuteHigh" select="if (empty($theMinuteHigh)) then '00' else $theMinuteHigh"/>
      <axsl:variable name="cSecondHigh" select="if (empty($theSecondHigh)) then '00' else $theSecondHigh"/>
      <axsl:variable name="cTZHigh" select="string-join(($theTZhHigh,$theTZmHigh),':')"/>
      <axsl:variable name="theTSStringHigh" select="string-join(($theBCHigh,$theCenturyHigh,$theYearHigh,$theMonthHigh,$theDayHigh,$theHourHigh,$theMinuteHigh,$theSecondHigh,$theSubSecondHigh,$theTZHigh),'')"/>
      <axsl:variable name="theHighDateTime" select="concat($theBCHigh,$cCenturyHigh,$cYearHigh,'-',$cMonthHigh,'-',$cDayHigh,'T',$cHourHigh,':',$cMinuteHigh,':',$cSecondHigh,$theSubSecondHigh,$cTZHigh)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTSHigh) or ($theTSHigh=$theTSStringHigh and $theHighDateTime castable as xs:dateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-IVL_TS: <axsl:text/>
               <axsl:value-of select="local-name()"/>
               <axsl:text/>/high "<axsl:text/>
               <axsl:value-of select="$theTSHigh"/>
               <axsl:text/>" is not a valid timestamp. (empty($theTSHigh) or ($theTSHigh=$theTSStringHigh and $theHighDateTime castable as xs:dateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTSLow) or empty($theTSHigh) or not($theLowDateTime castable as xs:dateTime) or not($theHighDateTime castable as xs:dateTime) or xs:dateTime($theLowDateTime) le xs:dateTime($theHighDateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-IVL_TS: low/@value (<axsl:text/>
               <axsl:value-of select="$theTSLow"/>
               <axsl:text/>) must be before high/@value (<axsl:text/>
               <axsl:value-of select="$theTSHigh"/>
               <axsl:text/>) (empty($theTSLow) or empty($theTSHigh) or not($theLowDateTime castable as xs:dateTime) or not($theHighDateTime castable as xs:dateTime) or xs:dateTime($theLowDateTime) le xs:dateTime($theHighDateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')"/>
         <axsl:otherwise>
            <axsl:message>(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.1.100)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d59877e57-false-d60751e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]" priority="1030" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@code)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@codeSystemName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@code or not(@displayName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @code)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-CD: co-occurence violation. Cannot have code and null (not(@nullFlavor and @code) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @displayName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-CD: co-occurence violation. Cannot have displayName and null (not(@nullFlavor and @displayName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-CD: no null on translations (Exceptional values (NULL-values) can not be elements of a set.) (not(.//hl7:translation/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystem][not(@code)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-CD: translation code requires codeSystem (not(.//hl7:translation[@codeSystem][not(@code)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystemName][not(@codeSystem)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (not(.//hl7:translation[@codeSystemName][not(@codeSystem)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@displayName][not(@code)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-CD: translation displayName only if code (not(.//hl7:translation[@displayName][not(@code)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="matches(@displayName,'[\r\n\t]')">
         <axsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
      </axsl:if>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <axsl:variable name="code" select="@code"/>
      <axsl:variable name="codeSystem" select="@codeSystem"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[@code=$code][@codeSystem=$codeSystem])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-CD: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> (@code=<axsl:text/>
               <axsl:value-of select="$code"/>
               <axsl:text/> @codeSystem=<axsl:text/>
               <axsl:value-of select="$codeSystem"/>
               <axsl:text/>) SHALL be distinct (not($set_other[@code=$code][@codeSystem=$codeSystem]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="translations" select=".//hl7:translation/concat(@code,@codeSystem)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count($translations)=count(distinct-values($translations))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-19-CD: [RIM-002] translations SHALL be distinct (count($translations)=count(distinct-values($translations)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-20-CD: originalText/@language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:qualifier)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CE)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theCode" select="@code"/>
      <axsl:variable name="theCodeSystem" select="@codeSystem"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1 GeslachtCodelijst (2015-04-01T00:00:00)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theNullFlavor" select="@nullFlavor"/>
      <axsl:variable name="validNullFlavorsFound" select="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or $validNullFlavorsFound"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): de nulwaarde '<axsl:text/>
               <axsl:value-of select="@nullFlavor"/>
               <axsl:text/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1 GeslachtCodelijst (2015-04-01T00:00:00). (not(@nullFlavor) or $validNullFlavorsFound / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d59877e62-false-d60777e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:birthTime" priority="1029" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_QTY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_QTY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-QTY: [RIM-001] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> SHALL NOT have nullFlavor, if there are other <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_QTY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="value" select="@value"/>
      <axsl:variable name="unit" select="@unit"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[@value=$value][@unit=$unit])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-QTY: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> (@value=<axsl:text/>
               <axsl:value-of select="$value"/>
               <axsl:text/> @unit=<axsl:text/>
               <axsl:value-of select="$unit"/>
               <axsl:text/>) SHALL be distinct (not($set_other[@value=$value][@unit=$unit]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_QTY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-TS: null or value or child element in case of extension ((@nullFlavor or @value or *) and not(@nullFlavor and @value) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theTS" select="@value"/>
      <axsl:variable name="theBC" select="if (starts-with($theTS,'-')) then '-' else ()"/>
      <axsl:variable name="theTZ" select="replace($theTS,'^-?[^+-]+([+-]\d{1,4})?$','$1')"/>
      <axsl:variable name="theTZh" select="if (string-length($theTZ) gt 0) then substring(concat($theTZ, '0000'), 1, 3) else ()"/>
      <axsl:variable name="theTZm" select="if (string-length($theTZ) gt 0) then substring(concat($theTZ, '0000'), 4, 2) else ()"/>
      <axsl:variable name="theBaseTS" select="replace($theTS,'^-?([^+-]+)([+-].*)?','$1')"/>
      <axsl:variable name="theCentury" select="if (substring($theBaseTS,1,2) castable as xs:integer) then substring($theBaseTS,1,2) else ()"/>
      <axsl:variable name="theYear" select="if (substring($theBaseTS,3,2) castable as xs:integer) then substring($theBaseTS,3,2) else ()"/>
      <axsl:variable name="theMonth" select="if (substring($theBaseTS,5,2) castable as xs:integer) then substring($theBaseTS,5,2) else ()"/>
      <axsl:variable name="theDay" select="if (substring($theBaseTS,7,2) castable as xs:integer) then substring($theBaseTS,7,2) else ()"/>
      <axsl:variable name="theHour" select="if (substring($theBaseTS,9,2) castable as xs:integer) then substring($theBaseTS,9,2) else ()"/>
      <axsl:variable name="theMinute" select="if (substring($theBaseTS,11,2) castable as xs:integer) then substring($theBaseTS,11,2) else ()"/>
      <axsl:variable name="theSecond" select="if (substring($theBaseTS,13,2) castable as xs:integer) then substring($theBaseTS,13,2) else ()"/>
      <axsl:variable name="theSubSecond" select="if (substring($theBaseTS,16) castable as xs:integer) then substring($theBaseTS,15) else ()"/>
      <axsl:variable name="cCentury" select="if (empty($theCentury)) then '00' else $theCentury"/>
      <axsl:variable name="cYear" select="if (empty($theYear)) then '00' else $theYear"/>
      <axsl:variable name="cMonth" select="if (empty($theMonth)) then '01' else $theMonth"/>
      <axsl:variable name="cDay" select="if (empty($theDay)) then '01' else $theDay"/>
      <axsl:variable name="cHour" select="if (empty($theHour)) then '00' else $theHour"/>
      <axsl:variable name="cMinute" select="if (empty($theMinute)) then '00' else $theMinute"/>
      <axsl:variable name="cSecond" select="if (empty($theSecond)) then '00' else $theSecond"/>
      <axsl:variable name="cTZ" select="string-join(($theTZh, $theTZm),':')"/>
      <axsl:variable name="theTSString" select="string-join(($theBC,$theCentury,$theYear,$theMonth,$theDay,$theHour,$theMinute,$theSecond,$theSubSecond,$theTZ),'')"/>
      <axsl:variable name="theDateTime" select="concat($theBC,$cCentury,$cYear,'-',$cMonth,'-',$cDay,'T',$cHour,':',$cMinute,':',$cSecond,$theSubSecond,$cTZ)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-TS: <axsl:text/>
               <axsl:value-of select="local-name()"/>
               <axsl:text/> "<axsl:text/>
               <axsl:value-of select="$theTS"/>
               <axsl:text/>" is not a valid timestamp. (empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(*)"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): <axsl:text/>
               <axsl:value-of select="local-name()"/>
               <axsl:text/> met datatype TS, MAG GEEN elementen bevatten. (not(*) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d59877e64-false-d60793e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/sdtc:multipleBirthInd" priority="1028" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'BL')"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'BL') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60800e5-false-d60805e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='RESP']" priority="1027" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@typeCode) = ('RESP')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Inhoudsverantwoordelijke (Body)): de waarde van typeCode MOET 'RESP' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@typeCode"/>
               <axsl:text/>" (string(@typeCode) = ('RESP') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9031)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:time) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Inhoudsverantwoordelijke (Body)): element hl7:time komt te vaak voor [max 1x]. (count(hl7:time) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9031)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:participantRole[@classCode = 'ASSIGNED']) &gt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Inhoudsverantwoordelijke (Body)): element hl7:participantRole[@classCode = 'ASSIGNED'] is required [min 1x]. (count(hl7:participantRole[@classCode = 'ASSIGNED']) &gt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9031)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:participantRole[@classCode = 'ASSIGNED']) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Inhoudsverantwoordelijke (Body)): element hl7:participantRole[@classCode = 'ASSIGNED'] komt te vaak voor [max 1x]. (count(hl7:participantRole[@classCode = 'ASSIGNED']) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9031)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60844e30-false-d60851e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='RESP']/hl7:time" priority="1026" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_QTY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_QTY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-QTY: [RIM-001] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> SHALL NOT have nullFlavor, if there are other <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_QTY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="value" select="@value"/>
      <axsl:variable name="unit" select="@unit"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[@value=$value][@unit=$unit])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-QTY: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> (@value=<axsl:text/>
               <axsl:value-of select="$value"/>
               <axsl:text/> @unit=<axsl:text/>
               <axsl:value-of select="$unit"/>
               <axsl:text/>) SHALL be distinct (not($set_other[@value=$value][@unit=$unit]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_QTY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-TS: null or value or child element in case of extension ((@nullFlavor or @value or *) and not(@nullFlavor and @value) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theTS" select="@value"/>
      <axsl:variable name="theBC" select="if (starts-with($theTS,'-')) then '-' else ()"/>
      <axsl:variable name="theTZ" select="replace($theTS,'^-?[^+-]+([+-]\d{1,4})?$','$1')"/>
      <axsl:variable name="theTZh" select="if (string-length($theTZ) gt 0) then substring(concat($theTZ, '0000'), 1, 3) else ()"/>
      <axsl:variable name="theTZm" select="if (string-length($theTZ) gt 0) then substring(concat($theTZ, '0000'), 4, 2) else ()"/>
      <axsl:variable name="theBaseTS" select="replace($theTS,'^-?([^+-]+)([+-].*)?','$1')"/>
      <axsl:variable name="theCentury" select="if (substring($theBaseTS,1,2) castable as xs:integer) then substring($theBaseTS,1,2) else ()"/>
      <axsl:variable name="theYear" select="if (substring($theBaseTS,3,2) castable as xs:integer) then substring($theBaseTS,3,2) else ()"/>
      <axsl:variable name="theMonth" select="if (substring($theBaseTS,5,2) castable as xs:integer) then substring($theBaseTS,5,2) else ()"/>
      <axsl:variable name="theDay" select="if (substring($theBaseTS,7,2) castable as xs:integer) then substring($theBaseTS,7,2) else ()"/>
      <axsl:variable name="theHour" select="if (substring($theBaseTS,9,2) castable as xs:integer) then substring($theBaseTS,9,2) else ()"/>
      <axsl:variable name="theMinute" select="if (substring($theBaseTS,11,2) castable as xs:integer) then substring($theBaseTS,11,2) else ()"/>
      <axsl:variable name="theSecond" select="if (substring($theBaseTS,13,2) castable as xs:integer) then substring($theBaseTS,13,2) else ()"/>
      <axsl:variable name="theSubSecond" select="if (substring($theBaseTS,16) castable as xs:integer) then substring($theBaseTS,15) else ()"/>
      <axsl:variable name="cCentury" select="if (empty($theCentury)) then '00' else $theCentury"/>
      <axsl:variable name="cYear" select="if (empty($theYear)) then '00' else $theYear"/>
      <axsl:variable name="cMonth" select="if (empty($theMonth)) then '01' else $theMonth"/>
      <axsl:variable name="cDay" select="if (empty($theDay)) then '01' else $theDay"/>
      <axsl:variable name="cHour" select="if (empty($theHour)) then '00' else $theHour"/>
      <axsl:variable name="cMinute" select="if (empty($theMinute)) then '00' else $theMinute"/>
      <axsl:variable name="cSecond" select="if (empty($theSecond)) then '00' else $theSecond"/>
      <axsl:variable name="cTZ" select="string-join(($theTZh, $theTZm),':')"/>
      <axsl:variable name="theTSString" select="string-join(($theBC,$theCentury,$theYear,$theMonth,$theDay,$theHour,$theMinute,$theSecond,$theSubSecond,$theTZ),'')"/>
      <axsl:variable name="theDateTime" select="concat($theBC,$cCentury,$cYear,'-',$cMonth,'-',$cDay,'T',$cHour,':',$cMinute,':',$cSecond,$theSubSecond,$cTZ)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-TS: <axsl:text/>
               <axsl:value-of select="local-name()"/>
               <axsl:text/> "<axsl:text/>
               <axsl:value-of select="$theTS"/>
               <axsl:text/>" is not a valid timestamp. (empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @operator) or @operator = 'I'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-SXCM_TS: not operator if null (not(@nullFlavor and @operator) or @operator = 'I' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_SXCM_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(descendant-or-self::*[@nullFlavor and (@value|@unit|hl7:low|hl7:center|hl7:high|hl7:width)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-IVL_TS: null violation. Cannot have @nullFlavor and @value or other child elements (not(descendant-or-self::*[@nullFlavor and (@value|@unit|hl7:low|hl7:center|hl7:high|hl7:width)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value and hl7:*)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-IVL_TS: co-occurence violation. Cannot have @value and other child elements (not(@value and hl7:*) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value and (hl7:low|hl7:center|hl7:high|hl7:width))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-2-IVL_TS: co-occurence violation. Cannot have @value and child elements (not(@value and (hl7:low|hl7:center|hl7:high|hl7:width)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:center and (hl7:low|hl7:high|hl7:width))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-3-IVL_TS: co-occurence violation. Cannot have center and other elements (not(hl7:center and (hl7:low|hl7:high|hl7:width)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:width and hl7:low and hl7:high)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-4-IVL_TS: co-occurence violation. Cannot have width and have both low and high elements (not(hl7:width and hl7:low and hl7:high) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:*[@updateMode])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-IVL_TS: no updateMode on IVL attributes (not(hl7:*[@updateMode]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:low/@value = hl7:high/@value)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-IVL_TS: low/@value must not be equal to high/@value (not(hl7:low/@value = hl7:high/@value) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:width[@unit][not(@value)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-PQR: width element: no unit without value (not(hl7:width[@unit][not(@value)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:width/hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-PQR: width element: no translation (not(hl7:width/hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:low[@nullFlavor='PINF'])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-1-IVL_TS: low must be lower than or equal to high. Found low boundary PINF (Positive Infinity) (not(hl7:low[@nullFlavor='PINF']) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:high[@nullFlavor='NINF'])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-2-IVL_TS: low must be lower than or equal to high. Found high boundary NINF (Negative Infinity) (not(hl7:high[@nullFlavor='NINF']) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="tum" select="'^(us|ms|s|min|h|d|wk|mo|a|)$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="matches(hl7:width/@unit, $tum)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-IVL_TS: for width only us (microseconds), ms (milliseconds), s (seconds), min (minute), h (hours), d (day), wk (week), mo (month) or a (year) are allowed (matches(hl7:width/@unit, $tum) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theTSLow" select="hl7:low/@value"/>
      <axsl:variable name="theBCLow" select="if (starts-with($theTSLow,'-')) then '-' else ()"/>
      <axsl:variable name="theTZLow" select="replace($theTSLow,'-?[^+-]+([+-].*)?$','$1')"/>
      <axsl:variable name="theTZhLow" select="if (string-length($theTZLow)&gt;0) then substring($theTZLow,1,3) else ()"/>
      <axsl:variable name="theTZmLow" select="if (string-length($theTZLow)&gt;3) then substring($theTZLow,4) else ()"/>
      <axsl:variable name="theBaseTSLow" select="replace($theTSLow,'^-?([^+-]+)([+-].*)?','$1')"/>
      <axsl:variable name="theCenturyLow" select="if (substring($theBaseTSLow,1,2) castable as xs:integer) then substring($theBaseTSLow,1,2) else ()"/>
      <axsl:variable name="theYearLow" select="if (substring($theBaseTSLow,3,2) castable as xs:integer) then substring($theBaseTSLow,3,2) else ()"/>
      <axsl:variable name="theMonthLow" select="if (substring($theBaseTSLow,5,2) castable as xs:integer) then substring($theBaseTSLow,5,2) else ()"/>
      <axsl:variable name="theDayLow" select="if (substring($theBaseTSLow,7,2) castable as xs:integer) then substring($theBaseTSLow,7,2) else ()"/>
      <axsl:variable name="theHourLow" select="if (substring($theBaseTSLow,9,2) castable as xs:integer) then substring($theBaseTSLow,9,2) else ()"/>
      <axsl:variable name="theMinuteLow" select="if (substring($theBaseTSLow,11,2) castable as xs:integer) then substring($theBaseTSLow,11,2) else ()"/>
      <axsl:variable name="theSecondLow" select="if (substring($theBaseTSLow,13,2) castable as xs:integer) then substring($theBaseTSLow,13,2) else ()"/>
      <axsl:variable name="theSubSecondLow" select="if (substring($theBaseTSLow,16) castable as xs:integer) then substring($theBaseTSLow,15) else ()"/>
      <axsl:variable name="cCenturyLow" select="if (empty($theCenturyLow)) then '00' else $theCenturyLow"/>
      <axsl:variable name="cYearLow" select="if (empty($theYearLow)) then '00' else $theYearLow"/>
      <axsl:variable name="cMonthLow" select="if (empty($theMonthLow)) then '01' else $theMonthLow"/>
      <axsl:variable name="cDayLow" select="if (empty($theDayLow)) then '01' else $theDayLow"/>
      <axsl:variable name="cHourLow" select="if (empty($theHourLow)) then '00' else $theHourLow"/>
      <axsl:variable name="cMinuteLow" select="if (empty($theMinuteLow)) then '00' else $theMinuteLow"/>
      <axsl:variable name="cSecondLow" select="if (empty($theSecondLow)) then '00' else $theSecondLow"/>
      <axsl:variable name="cTZLow" select="string-join(($theTZhLow,$theTZmLow),':')"/>
      <axsl:variable name="theTSStringLow" select="string-join(($theBCLow,$theCenturyLow,$theYearLow,$theMonthLow,$theDayLow,$theHourLow,$theMinuteLow,$theSecondLow,$theSubSecondLow,$theTZLow),'')"/>
      <axsl:variable name="theLowDateTime" select="concat($theBCLow,$cCenturyLow,$cYearLow,'-',$cMonthLow,'-',$cDayLow,'T',$cHourLow,':',$cMinuteLow,':',$cSecondLow,$theSubSecondLow,$cTZLow)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTSLow) or ($theTSLow=$theTSStringLow and $theLowDateTime castable as xs:dateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-IVL_TS: <axsl:text/>
               <axsl:value-of select="local-name()"/>
               <axsl:text/>/low "<axsl:text/>
               <axsl:value-of select="$theTSLow"/>
               <axsl:text/>" is not a valid timestamp. (empty($theTSLow) or ($theTSLow=$theTSStringLow and $theLowDateTime castable as xs:dateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theTSCenter" select="hl7:center/@value"/>
      <axsl:variable name="theBCCenter" select="if (starts-with($theTSCenter,'-')) then '-' else ()"/>
      <axsl:variable name="theTZCenter" select="replace($theTSCenter,'-?[^+-]+([+-].*)?$','$1')"/>
      <axsl:variable name="theTZhCenter" select="if (string-length($theTZCenter)&gt;0) then substring($theTZCenter,1,3) else ()"/>
      <axsl:variable name="theTZmCenter" select="if (string-length($theTZCenter)&gt;3) then substring($theTZCenter,4) else ()"/>
      <axsl:variable name="theBaseTSCenter" select="replace($theTSCenter,'^-?([^+-]+)([+-].*)?','$1')"/>
      <axsl:variable name="theCenturyCenter" select="if (substring($theBaseTSCenter,1,2) castable as xs:integer) then substring($theBaseTSCenter,1,2) else ()"/>
      <axsl:variable name="theYearCenter" select="if (substring($theBaseTSCenter,3,2) castable as xs:integer) then substring($theBaseTSCenter,3,2) else ()"/>
      <axsl:variable name="theMonthCenter" select="if (substring($theBaseTSCenter,5,2) castable as xs:integer) then substring($theBaseTSCenter,5,2) else ()"/>
      <axsl:variable name="theDayCenter" select="if (substring($theBaseTSCenter,7,2) castable as xs:integer) then substring($theBaseTSCenter,7,2) else ()"/>
      <axsl:variable name="theHourCenter" select="if (substring($theBaseTSCenter,9,2) castable as xs:integer) then substring($theBaseTSCenter,9,2) else ()"/>
      <axsl:variable name="theMinuteCenter" select="if (substring($theBaseTSCenter,11,2) castable as xs:integer) then substring($theBaseTSCenter,11,2) else ()"/>
      <axsl:variable name="theSecondCenter" select="if (substring($theBaseTSCenter,13,2) castable as xs:integer) then substring($theBaseTSCenter,13,2) else ()"/>
      <axsl:variable name="theSubSecondCenter" select="if (substring($theBaseTSCenter,16) castable as xs:integer) then substring($theBaseTSCenter,15) else ()"/>
      <axsl:variable name="cCenturyCenter" select="if (empty($theCenturyCenter)) then '00' else $theCenturyCenter"/>
      <axsl:variable name="cYearCenter" select="if (empty($theYearCenter)) then '00' else $theYearCenter"/>
      <axsl:variable name="cMonthCenter" select="if (empty($theMonthCenter)) then '01' else $theMonthCenter"/>
      <axsl:variable name="cDayCenter" select="if (empty($theDayCenter)) then '01' else $theDayCenter"/>
      <axsl:variable name="cHourCenter" select="if (empty($theHourCenter)) then '00' else $theHourCenter"/>
      <axsl:variable name="cMinuteCenter" select="if (empty($theMinuteCenter)) then '00' else $theMinuteCenter"/>
      <axsl:variable name="cSecondCenter" select="if (empty($theSecondCenter)) then '00' else $theSecondCenter"/>
      <axsl:variable name="cTZCenter" select="string-join(($theTZhCenter,$theTZmCenter),':')"/>
      <axsl:variable name="theTSStringCenter" select="string-join(($theBCCenter,$theCenturyCenter,$theYearCenter,$theMonthCenter,$theDayCenter,$theHourCenter,$theMinuteCenter,$theSecondCenter,$theSubSecondCenter,$theTZCenter),'')"/>
      <axsl:variable name="theCenterDateTime" select="concat($theBCCenter,$cCenturyCenter,$cYearCenter,'-',$cMonthCenter,'-',$cDayCenter,'T',$cHourCenter,':',$cMinuteCenter,':',$cSecondCenter,$theSubSecondCenter,$cTZCenter)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTSCenter) or ($theTSCenter=$theTSStringCenter and $theCenterDateTime castable as xs:dateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-IVL_TS: <axsl:text/>
               <axsl:value-of select="local-name()"/>
               <axsl:text/>/center "<axsl:text/>
               <axsl:value-of select="$theTSCenter"/>
               <axsl:text/>" is not a valid timestamp. (empty($theTSCenter) or ($theTSCenter=$theTSStringCenter and $theCenterDateTime castable as xs:dateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theTSHigh" select="hl7:high/@value"/>
      <axsl:variable name="theBCHigh" select="if (starts-with($theTSHigh,'-')) then '-' else ()"/>
      <axsl:variable name="theTZHigh" select="replace($theTSHigh,'-?[^+-]+([+-].*)?$','$1')"/>
      <axsl:variable name="theTZhHigh" select="if (string-length($theTZHigh)&gt;0) then substring($theTZHigh,1,3) else ()"/>
      <axsl:variable name="theTZmHigh" select="if (string-length($theTZHigh)&gt;3) then substring($theTZHigh,4) else ()"/>
      <axsl:variable name="theBaseTSHigh" select="replace($theTSHigh,'^-?([^+-]+)([+-].*)?','$1')"/>
      <axsl:variable name="theCenturyHigh" select="if (substring($theBaseTSHigh,1,2) castable as xs:integer) then substring($theBaseTSHigh,1,2) else ()"/>
      <axsl:variable name="theYearHigh" select="if (substring($theBaseTSHigh,3,2) castable as xs:integer) then substring($theBaseTSHigh,3,2) else ()"/>
      <axsl:variable name="theMonthHigh" select="if (substring($theBaseTSHigh,5,2) castable as xs:integer) then substring($theBaseTSHigh,5,2) else ()"/>
      <axsl:variable name="theDayHigh" select="if (substring($theBaseTSHigh,7,2) castable as xs:integer) then substring($theBaseTSHigh,7,2) else ()"/>
      <axsl:variable name="theHourHigh" select="if (substring($theBaseTSHigh,9,2) castable as xs:integer) then substring($theBaseTSHigh,9,2) else ()"/>
      <axsl:variable name="theMinuteHigh" select="if (substring($theBaseTSHigh,11,2) castable as xs:integer) then substring($theBaseTSHigh,11,2) else ()"/>
      <axsl:variable name="theSecondHigh" select="if (substring($theBaseTSHigh,13,2) castable as xs:integer) then substring($theBaseTSHigh,13,2) else ()"/>
      <axsl:variable name="theSubSecondHigh" select="if (substring($theBaseTSHigh,16) castable as xs:integer) then substring($theBaseTSHigh,15) else ()"/>
      <axsl:variable name="cCenturyHigh" select="if (empty($theCenturyHigh)) then '00' else $theCenturyHigh"/>
      <axsl:variable name="cYearHigh" select="if (empty($theYearHigh)) then '00' else $theYearHigh"/>
      <axsl:variable name="cMonthHigh" select="if (empty($theMonthHigh)) then '01' else $theMonthHigh"/>
      <axsl:variable name="cDayHigh" select="if (empty($theDayHigh)) then '01' else $theDayHigh"/>
      <axsl:variable name="cHourHigh" select="if (empty($theHourHigh)) then '00' else $theHourHigh"/>
      <axsl:variable name="cMinuteHigh" select="if (empty($theMinuteHigh)) then '00' else $theMinuteHigh"/>
      <axsl:variable name="cSecondHigh" select="if (empty($theSecondHigh)) then '00' else $theSecondHigh"/>
      <axsl:variable name="cTZHigh" select="string-join(($theTZhHigh,$theTZmHigh),':')"/>
      <axsl:variable name="theTSStringHigh" select="string-join(($theBCHigh,$theCenturyHigh,$theYearHigh,$theMonthHigh,$theDayHigh,$theHourHigh,$theMinuteHigh,$theSecondHigh,$theSubSecondHigh,$theTZHigh),'')"/>
      <axsl:variable name="theHighDateTime" select="concat($theBCHigh,$cCenturyHigh,$cYearHigh,'-',$cMonthHigh,'-',$cDayHigh,'T',$cHourHigh,':',$cMinuteHigh,':',$cSecondHigh,$theSubSecondHigh,$cTZHigh)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTSHigh) or ($theTSHigh=$theTSStringHigh and $theHighDateTime castable as xs:dateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-IVL_TS: <axsl:text/>
               <axsl:value-of select="local-name()"/>
               <axsl:text/>/high "<axsl:text/>
               <axsl:value-of select="$theTSHigh"/>
               <axsl:text/>" is not a valid timestamp. (empty($theTSHigh) or ($theTSHigh=$theTSStringHigh and $theHighDateTime castable as xs:dateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTSLow) or empty($theTSHigh) or not($theLowDateTime castable as xs:dateTime) or not($theHighDateTime castable as xs:dateTime) or xs:dateTime($theLowDateTime) le xs:dateTime($theHighDateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-IVL_TS: low/@value (<axsl:text/>
               <axsl:value-of select="$theTSLow"/>
               <axsl:text/>) must be before high/@value (<axsl:text/>
               <axsl:value-of select="$theTSHigh"/>
               <axsl:text/>) (empty($theTSLow) or empty($theTSHigh) or not($theLowDateTime castable as xs:dateTime) or not($theHighDateTime castable as xs:dateTime) or xs:dateTime($theLowDateTime) le xs:dateTime($theHighDateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60844e35-false-d60863e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']" priority="1025" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@classCode) = ('ASSIGNED')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): de waarde van classCode MOET 'ASSIGNED' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@classCode"/>
               <axsl:text/>" (string(@classCode) = ('ASSIGNED') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @nullFlavor]) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): element hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @nullFlavor] komt te vaak voor [max 1x]. (count(hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @nullFlavor]) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): element hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE'] komt te vaak voor [max 1x]. (count(hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): element hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] komt te vaak voor [max 1x]. (count(hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60844e39-false-d60916e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:id" priority="1024" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @identifierName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor and @identifierName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @displayable)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor and @displayable) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @reliability)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor and @reliability) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @assigningAuthorityName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor and @assigningAuthorityName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@root) &lt;= 128)">
         <axsl:message>dtr1-8-II: @root should not be longer than 128 characters. Found <axsl:text/>
            <axsl:value-of select="string-length(@root)"/>
            <axsl:text/> characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
      </axsl:if>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@extension) &lt;= 64)">
         <axsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Found <axsl:text/>
            <axsl:value-of select="string-length(@extension)"/>
            <axsl:text/> characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
      </axsl:if>
      <axsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <axsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <axsl:variable name="UUIDpattern" select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID or UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <axsl:variable name="root" select="@root"/>
      <axsl:variable name="extension" select="@extension"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-II: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT info-->

      <axsl:choose>
         <axsl:when test="not(matches(@root, $UUIDpattern) and matches(@root, '[a-z]') and matches(@root, '[A-Z]'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-II: Lower case and Upper case mixed UUID "<axsl:text/>
               <axsl:value-of select="@root"/>
               <axsl:text/>" found in @root. UUIDs SHALL not have mixed cases. (not(matches(@root, $UUIDpattern) and matches(@root, '[a-z]') and matches(@root, '[A-Z]')) / info / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60844e45-false-d60928e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @nullFlavor]" priority="1023" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@code)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@codeSystemName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@code or not(@displayName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @code)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-CD: co-occurence violation. Cannot have code and null (not(@nullFlavor and @code) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @displayName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-CD: co-occurence violation. Cannot have displayName and null (not(@nullFlavor and @displayName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-CD: no null on translations (Exceptional values (NULL-values) can not be elements of a set.) (not(.//hl7:translation/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystem][not(@code)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-CD: translation code requires codeSystem (not(.//hl7:translation[@codeSystem][not(@code)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystemName][not(@codeSystem)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (not(.//hl7:translation[@codeSystemName][not(@codeSystem)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@displayName][not(@code)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-CD: translation displayName only if code (not(.//hl7:translation[@displayName][not(@code)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="matches(@displayName,'[\r\n\t]')">
         <axsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
      </axsl:if>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <axsl:variable name="code" select="@code"/>
      <axsl:variable name="codeSystem" select="@codeSystem"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[@code=$code][@codeSystem=$codeSystem])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-CD: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> (@code=<axsl:text/>
               <axsl:value-of select="$code"/>
               <axsl:text/> @codeSystem=<axsl:text/>
               <axsl:value-of select="$codeSystem"/>
               <axsl:text/>) SHALL be distinct (not($set_other[@code=$code][@codeSystem=$codeSystem]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="translations" select=".//hl7:translation/concat(@code,@codeSystem)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count($translations)=count(distinct-values($translations))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-19-CD: [RIM-002] translations SHALL be distinct (count($translations)=count(distinct-values($translations)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-20-CD: originalText/@language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:qualifier)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CE)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or (@codeSystem='2.16.840.1.113883.2.4.15.111')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.2.4.15.111''. (@nullFlavor or (@codeSystem='2.16.840.1.113883.2.4.15.111') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60844e52-false-d60947e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:addr" priority="1022" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-AD: address shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/>)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-AD: no useablePeriod if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:useablePeriod][@updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-AD: updateMode shall not be used on address elements (count(*[self::hl7:useablePeriod][@updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or          string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-AD: useablePeriod/low/@value must have the same precision as useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or         number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-AD: useablePeriod/low/@value must be before useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="tum" select="'^(us|ms|s|min|h|d|wk|mo|a|)$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="matches(hl7:useablePeriod/hl7:width/@unit, $tum)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-AD: for useablePeriod/width only us (microseconds), ms (milliseconds), s (seconds), min (minute), h (hours), d (day), wk (week), mo (month) or a (year) are allowed (matches(hl7:useablePeriod/hl7:width/@unit, $tum) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="*[not(@nullFlavor or self::hl7:useablePeriod)][normalize-space(.)='']">
         <axsl:message>dtr1-8-AD: empty address particles should not be present. (*[not(@nullFlavor or self::hl7:useablePeriod)][normalize-space(.)=''] / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
      </axsl:if>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="value" select="string-join((.//@use|.//text()),'')"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-AD: [RIM-001] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> SHALL NOT have nullFlavor, if there are other <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[string-join((.//@use|.//text()),'')=$value])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-AD: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> (<axsl:text/>
               <axsl:value-of select="$value"/>
               <axsl:text/>) SHALL be distinct (not($set_other[string-join((.//@use|.//text()),'')=$value]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60844e54-false-d60959e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:telecom" priority="1021" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or @value"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-URL: elements of type URL SHALL have a @value attribute. (@nullFlavor or @value / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_URL)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or @value=iri-to-uri(@value)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-URL: @value must be a valid URI, e.g. '<axsl:text/>
               <axsl:value-of select="iri-to-uri(@value)"/>
               <axsl:text/>'. (@nullFlavor or @value=iri-to-uri(@value) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_URL)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="use" select="@use"/>
      <axsl:variable name="value" select="@value"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-URL: [RIM-001] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> SHALL NOT have nullFlavor, if there are other <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_URL)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[@use=$use][@value=$value])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-URL: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> (<axsl:text/>
               <axsl:value-of select="$value"/>
               <axsl:text/>) SHALL be distinct (not($set_other[@use=$use][@value=$value]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_URL)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:useablePeriod)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-TEL: not null and useablePeriod (not(@nullFlavor and hl7:useablePeriod) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_TEL)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60844e57-false-d60971e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']" priority="1020" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@classCode) = ('PSN')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@classCode"/>
               <axsl:text/>" (string(@classCode) = ('PSN') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@determinerCode"/>
               <axsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x]. (count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60844e66-false-d61008e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]" priority="1019" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@code)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@codeSystemName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@code or not(@displayName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @code)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-CD: co-occurence violation. Cannot have code and null (not(@nullFlavor and @code) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @displayName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-CD: co-occurence violation. Cannot have displayName and null (not(@nullFlavor and @displayName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-CD: no null on translations (Exceptional values (NULL-values) can not be elements of a set.) (not(.//hl7:translation/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystem][not(@code)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-CD: translation code requires codeSystem (not(.//hl7:translation[@codeSystem][not(@code)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystemName][not(@codeSystem)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (not(.//hl7:translation[@codeSystemName][not(@codeSystem)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@displayName][not(@code)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-CD: translation displayName only if code (not(.//hl7:translation[@displayName][not(@code)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="matches(@displayName,'[\r\n\t]')">
         <axsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
      </axsl:if>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <axsl:variable name="code" select="@code"/>
      <axsl:variable name="codeSystem" select="@codeSystem"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[@code=$code][@codeSystem=$codeSystem])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-CD: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> (@code=<axsl:text/>
               <axsl:value-of select="$code"/>
               <axsl:text/> @codeSystem=<axsl:text/>
               <axsl:value-of select="$codeSystem"/>
               <axsl:text/>) SHALL be distinct (not($set_other[@code=$code][@codeSystem=$codeSystem]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="translations" select=".//hl7:translation/concat(@code,@codeSystem)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count($translations)=count(distinct-values($translations))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-19-CD: [RIM-002] translations SHALL be distinct (count($translations)=count(distinct-values($translations)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-20-CD: originalText/@language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:qualifier)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CE)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theCode" select="@code"/>
      <axsl:variable name="theCodeSystem" select="@codeSystem"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.2 RoleCodeNL - zorgverlenertype (personen) (DYNAMISCH)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem])">
         <axsl:message>(KEZO PART CDA Responsible Party (Body)): element hl7:code is gecodeerd met bindingssterkte 'required' en bevat een code die verouderd is. (exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem]) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
      </axsl:if>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60844e71-false-d61036e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name" priority="1018" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and (* or string-length(normalize-space(string-join(text(),'')))&gt;0))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1.1-EN: entity name shall not be null and have elements or text (not(@nullFlavor and (* or string-length(normalize-space(string-join(text(),'')))&gt;0)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(* and string-length(normalize-space(string-join(text(),'')))&gt;0)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1.2-EN: entity name shall not have both elements and text (no mixed content) (not(* and string-length(normalize-space(string-join(text(),'')))&gt;0) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or * or string-length(normalize-space(string-join(text(),'')))&gt;0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1.3-EN: entity name that is not null shall not be empty (@nullFlavor or * or string-length(normalize-space(string-join(text(),'')))&gt;0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="*[not(self::*:validTime | @nullFlavor)][normalize-space(.)='']">
         <axsl:message>dtr1-3-EN: empty name particles should not be present. (*[not(self::*:validTime | @nullFlavor)][normalize-space(.)=''] / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
      </axsl:if>

		<!--REPORT warning-->

      <axsl:if test="substring(normalize-space(.),1,1)='&#34;'">
         <axsl:message>dtr1-4-EN: Use of quotes at the beginning of a name are probably not correct. (substring(normalize-space(.),1,1)='"' / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
      </axsl:if>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="value" select="string-join((.//@use|.//text()),'')"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-EN: [RIM-001] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> SHALL NOT have nullFlavor, if there are other <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[string-join((.//@use|.//text()),'')=$value])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-EN: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> (<axsl:text/>
               <axsl:value-of select="$value"/>
               <axsl:text/>) SHALL be distinct (not($set_other[string-join((.//@use|.//text()),'')=$value]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-EN: enxp elements SHALL have distinct values in @qualifier (not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(*[tokenize(@qualifier,'\s')='LS'])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-PN: Person names SHALL NOT contain a name part qualified with 'LS' (Legal status for organizations) (not(*[tokenize(@qualifier,'\s')='LS']) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_PN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60844e74-false-d61048e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']" priority="1017" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@classCode) = ('ORG')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): de waarde van classCode MOET 'ORG' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@classCode"/>
               <axsl:text/>" (string(@classCode) = ('ORG') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@determinerCode"/>
               <axsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): element hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor] komt te vaak voor [max 1x]. (count(hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:desc) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): element hl7:desc komt te vaak voor [max 1x]. (count(hl7:desc) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60844e83-false-d61090e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id" priority="1016" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @identifierName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor and @identifierName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @displayable)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor and @displayable) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @reliability)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor and @reliability) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @assigningAuthorityName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor and @assigningAuthorityName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@root) &lt;= 128)">
         <axsl:message>dtr1-8-II: @root should not be longer than 128 characters. Found <axsl:text/>
            <axsl:value-of select="string-length(@root)"/>
            <axsl:text/> characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
      </axsl:if>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@extension) &lt;= 64)">
         <axsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Found <axsl:text/>
            <axsl:value-of select="string-length(@extension)"/>
            <axsl:text/> characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
      </axsl:if>
      <axsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <axsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <axsl:variable name="UUIDpattern" select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID or UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <axsl:variable name="root" select="@root"/>
      <axsl:variable name="extension" select="@extension"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-II: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT info-->

      <axsl:choose>
         <axsl:when test="not(matches(@root, $UUIDpattern) and matches(@root, '[a-z]') and matches(@root, '[A-Z]'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-II: Lower case and Upper case mixed UUID "<axsl:text/>
               <axsl:value-of select="@root"/>
               <axsl:text/>" found in @root. UUIDs SHALL not have mixed cases. (not(matches(@root, $UUIDpattern) and matches(@root, '[a-z]') and matches(@root, '[A-Z]')) / info / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60844e85-false-d61102e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]" priority="1015" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@code)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@codeSystemName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@code or not(@displayName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @code)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-CD: co-occurence violation. Cannot have code and null (not(@nullFlavor and @code) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @displayName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-CD: co-occurence violation. Cannot have displayName and null (not(@nullFlavor and @displayName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-CD: no null on translations (Exceptional values (NULL-values) can not be elements of a set.) (not(.//hl7:translation/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystem][not(@code)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-CD: translation code requires codeSystem (not(.//hl7:translation[@codeSystem][not(@code)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystemName][not(@codeSystem)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (not(.//hl7:translation[@codeSystemName][not(@codeSystem)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@displayName][not(@code)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-CD: translation displayName only if code (not(.//hl7:translation[@displayName][not(@code)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="matches(@displayName,'[\r\n\t]')">
         <axsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
      </axsl:if>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <axsl:variable name="code" select="@code"/>
      <axsl:variable name="codeSystem" select="@codeSystem"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[@code=$code][@codeSystem=$codeSystem])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-CD: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> (@code=<axsl:text/>
               <axsl:value-of select="$code"/>
               <axsl:text/> @codeSystem=<axsl:text/>
               <axsl:value-of select="$codeSystem"/>
               <axsl:text/>) SHALL be distinct (not($set_other[@code=$code][@codeSystem=$codeSystem]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="translations" select=".//hl7:translation/concat(@code,@codeSystem)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count($translations)=count(distinct-values($translations))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-19-CD: [RIM-002] translations SHALL be distinct (count($translations)=count(distinct-values($translations)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-20-CD: originalText/@language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:qualifier)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CE)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or (@codeSystem='2.16.840.1.113883.2.4.15.1060')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.2.4.15.1060''. (@nullFlavor or (@codeSystem='2.16.840.1.113883.2.4.15.1060') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d60844e91-false-d61121e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:desc" priority="1014" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d61128e5-false-d61133e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='CST']" priority="1013" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@typeCode) = ('CST')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Dossierhouder): de waarde van typeCode MOET 'CST' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@typeCode"/>
               <axsl:text/>" (string(@typeCode) = ('CST') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9032)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:time) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Dossierhouder): element hl7:time komt te vaak voor [max 1x]. (count(hl7:time) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9032)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:participantRole[@classCode = 'ASSIGNED']) &gt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Dossierhouder): element hl7:participantRole[@classCode = 'ASSIGNED'] is required [min 1x]. (count(hl7:participantRole[@classCode = 'ASSIGNED']) &gt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9032)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:participantRole[@classCode = 'ASSIGNED']) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Dossierhouder): element hl7:participantRole[@classCode = 'ASSIGNED'] komt te vaak voor [max 1x]. (count(hl7:participantRole[@classCode = 'ASSIGNED']) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9032)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d61172e31-false-d61179e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='CST']/hl7:time" priority="1012" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_QTY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_QTY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-QTY: [RIM-001] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> SHALL NOT have nullFlavor, if there are other <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_QTY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="value" select="@value"/>
      <axsl:variable name="unit" select="@unit"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[@value=$value][@unit=$unit])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-QTY: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> (@value=<axsl:text/>
               <axsl:value-of select="$value"/>
               <axsl:text/> @unit=<axsl:text/>
               <axsl:value-of select="$unit"/>
               <axsl:text/>) SHALL be distinct (not($set_other[@value=$value][@unit=$unit]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_QTY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-TS: null or value or child element in case of extension ((@nullFlavor or @value or *) and not(@nullFlavor and @value) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theTS" select="@value"/>
      <axsl:variable name="theBC" select="if (starts-with($theTS,'-')) then '-' else ()"/>
      <axsl:variable name="theTZ" select="replace($theTS,'^-?[^+-]+([+-]\d{1,4})?$','$1')"/>
      <axsl:variable name="theTZh" select="if (string-length($theTZ) gt 0) then substring(concat($theTZ, '0000'), 1, 3) else ()"/>
      <axsl:variable name="theTZm" select="if (string-length($theTZ) gt 0) then substring(concat($theTZ, '0000'), 4, 2) else ()"/>
      <axsl:variable name="theBaseTS" select="replace($theTS,'^-?([^+-]+)([+-].*)?','$1')"/>
      <axsl:variable name="theCentury" select="if (substring($theBaseTS,1,2) castable as xs:integer) then substring($theBaseTS,1,2) else ()"/>
      <axsl:variable name="theYear" select="if (substring($theBaseTS,3,2) castable as xs:integer) then substring($theBaseTS,3,2) else ()"/>
      <axsl:variable name="theMonth" select="if (substring($theBaseTS,5,2) castable as xs:integer) then substring($theBaseTS,5,2) else ()"/>
      <axsl:variable name="theDay" select="if (substring($theBaseTS,7,2) castable as xs:integer) then substring($theBaseTS,7,2) else ()"/>
      <axsl:variable name="theHour" select="if (substring($theBaseTS,9,2) castable as xs:integer) then substring($theBaseTS,9,2) else ()"/>
      <axsl:variable name="theMinute" select="if (substring($theBaseTS,11,2) castable as xs:integer) then substring($theBaseTS,11,2) else ()"/>
      <axsl:variable name="theSecond" select="if (substring($theBaseTS,13,2) castable as xs:integer) then substring($theBaseTS,13,2) else ()"/>
      <axsl:variable name="theSubSecond" select="if (substring($theBaseTS,16) castable as xs:integer) then substring($theBaseTS,15) else ()"/>
      <axsl:variable name="cCentury" select="if (empty($theCentury)) then '00' else $theCentury"/>
      <axsl:variable name="cYear" select="if (empty($theYear)) then '00' else $theYear"/>
      <axsl:variable name="cMonth" select="if (empty($theMonth)) then '01' else $theMonth"/>
      <axsl:variable name="cDay" select="if (empty($theDay)) then '01' else $theDay"/>
      <axsl:variable name="cHour" select="if (empty($theHour)) then '00' else $theHour"/>
      <axsl:variable name="cMinute" select="if (empty($theMinute)) then '00' else $theMinute"/>
      <axsl:variable name="cSecond" select="if (empty($theSecond)) then '00' else $theSecond"/>
      <axsl:variable name="cTZ" select="string-join(($theTZh, $theTZm),':')"/>
      <axsl:variable name="theTSString" select="string-join(($theBC,$theCentury,$theYear,$theMonth,$theDay,$theHour,$theMinute,$theSecond,$theSubSecond,$theTZ),'')"/>
      <axsl:variable name="theDateTime" select="concat($theBC,$cCentury,$cYear,'-',$cMonth,'-',$cDay,'T',$cHour,':',$cMinute,':',$cSecond,$theSubSecond,$cTZ)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-TS: <axsl:text/>
               <axsl:value-of select="local-name()"/>
               <axsl:text/> "<axsl:text/>
               <axsl:value-of select="$theTS"/>
               <axsl:text/>" is not a valid timestamp. (empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @operator) or @operator = 'I'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-SXCM_TS: not operator if null (not(@nullFlavor and @operator) or @operator = 'I' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_SXCM_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(descendant-or-self::*[@nullFlavor and (@value|@unit|hl7:low|hl7:center|hl7:high|hl7:width)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-IVL_TS: null violation. Cannot have @nullFlavor and @value or other child elements (not(descendant-or-self::*[@nullFlavor and (@value|@unit|hl7:low|hl7:center|hl7:high|hl7:width)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value and hl7:*)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-IVL_TS: co-occurence violation. Cannot have @value and other child elements (not(@value and hl7:*) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value and (hl7:low|hl7:center|hl7:high|hl7:width))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-2-IVL_TS: co-occurence violation. Cannot have @value and child elements (not(@value and (hl7:low|hl7:center|hl7:high|hl7:width)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:center and (hl7:low|hl7:high|hl7:width))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-3-IVL_TS: co-occurence violation. Cannot have center and other elements (not(hl7:center and (hl7:low|hl7:high|hl7:width)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:width and hl7:low and hl7:high)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-4-IVL_TS: co-occurence violation. Cannot have width and have both low and high elements (not(hl7:width and hl7:low and hl7:high) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:*[@updateMode])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-IVL_TS: no updateMode on IVL attributes (not(hl7:*[@updateMode]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:low/@value = hl7:high/@value)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-IVL_TS: low/@value must not be equal to high/@value (not(hl7:low/@value = hl7:high/@value) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:width[@unit][not(@value)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-PQR: width element: no unit without value (not(hl7:width[@unit][not(@value)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:width/hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-PQR: width element: no translation (not(hl7:width/hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:low[@nullFlavor='PINF'])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-1-IVL_TS: low must be lower than or equal to high. Found low boundary PINF (Positive Infinity) (not(hl7:low[@nullFlavor='PINF']) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:high[@nullFlavor='NINF'])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-2-IVL_TS: low must be lower than or equal to high. Found high boundary NINF (Negative Infinity) (not(hl7:high[@nullFlavor='NINF']) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="tum" select="'^(us|ms|s|min|h|d|wk|mo|a|)$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="matches(hl7:width/@unit, $tum)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-IVL_TS: for width only us (microseconds), ms (milliseconds), s (seconds), min (minute), h (hours), d (day), wk (week), mo (month) or a (year) are allowed (matches(hl7:width/@unit, $tum) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theTSLow" select="hl7:low/@value"/>
      <axsl:variable name="theBCLow" select="if (starts-with($theTSLow,'-')) then '-' else ()"/>
      <axsl:variable name="theTZLow" select="replace($theTSLow,'-?[^+-]+([+-].*)?$','$1')"/>
      <axsl:variable name="theTZhLow" select="if (string-length($theTZLow)&gt;0) then substring($theTZLow,1,3) else ()"/>
      <axsl:variable name="theTZmLow" select="if (string-length($theTZLow)&gt;3) then substring($theTZLow,4) else ()"/>
      <axsl:variable name="theBaseTSLow" select="replace($theTSLow,'^-?([^+-]+)([+-].*)?','$1')"/>
      <axsl:variable name="theCenturyLow" select="if (substring($theBaseTSLow,1,2) castable as xs:integer) then substring($theBaseTSLow,1,2) else ()"/>
      <axsl:variable name="theYearLow" select="if (substring($theBaseTSLow,3,2) castable as xs:integer) then substring($theBaseTSLow,3,2) else ()"/>
      <axsl:variable name="theMonthLow" select="if (substring($theBaseTSLow,5,2) castable as xs:integer) then substring($theBaseTSLow,5,2) else ()"/>
      <axsl:variable name="theDayLow" select="if (substring($theBaseTSLow,7,2) castable as xs:integer) then substring($theBaseTSLow,7,2) else ()"/>
      <axsl:variable name="theHourLow" select="if (substring($theBaseTSLow,9,2) castable as xs:integer) then substring($theBaseTSLow,9,2) else ()"/>
      <axsl:variable name="theMinuteLow" select="if (substring($theBaseTSLow,11,2) castable as xs:integer) then substring($theBaseTSLow,11,2) else ()"/>
      <axsl:variable name="theSecondLow" select="if (substring($theBaseTSLow,13,2) castable as xs:integer) then substring($theBaseTSLow,13,2) else ()"/>
      <axsl:variable name="theSubSecondLow" select="if (substring($theBaseTSLow,16) castable as xs:integer) then substring($theBaseTSLow,15) else ()"/>
      <axsl:variable name="cCenturyLow" select="if (empty($theCenturyLow)) then '00' else $theCenturyLow"/>
      <axsl:variable name="cYearLow" select="if (empty($theYearLow)) then '00' else $theYearLow"/>
      <axsl:variable name="cMonthLow" select="if (empty($theMonthLow)) then '01' else $theMonthLow"/>
      <axsl:variable name="cDayLow" select="if (empty($theDayLow)) then '01' else $theDayLow"/>
      <axsl:variable name="cHourLow" select="if (empty($theHourLow)) then '00' else $theHourLow"/>
      <axsl:variable name="cMinuteLow" select="if (empty($theMinuteLow)) then '00' else $theMinuteLow"/>
      <axsl:variable name="cSecondLow" select="if (empty($theSecondLow)) then '00' else $theSecondLow"/>
      <axsl:variable name="cTZLow" select="string-join(($theTZhLow,$theTZmLow),':')"/>
      <axsl:variable name="theTSStringLow" select="string-join(($theBCLow,$theCenturyLow,$theYearLow,$theMonthLow,$theDayLow,$theHourLow,$theMinuteLow,$theSecondLow,$theSubSecondLow,$theTZLow),'')"/>
      <axsl:variable name="theLowDateTime" select="concat($theBCLow,$cCenturyLow,$cYearLow,'-',$cMonthLow,'-',$cDayLow,'T',$cHourLow,':',$cMinuteLow,':',$cSecondLow,$theSubSecondLow,$cTZLow)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTSLow) or ($theTSLow=$theTSStringLow and $theLowDateTime castable as xs:dateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-IVL_TS: <axsl:text/>
               <axsl:value-of select="local-name()"/>
               <axsl:text/>/low "<axsl:text/>
               <axsl:value-of select="$theTSLow"/>
               <axsl:text/>" is not a valid timestamp. (empty($theTSLow) or ($theTSLow=$theTSStringLow and $theLowDateTime castable as xs:dateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theTSCenter" select="hl7:center/@value"/>
      <axsl:variable name="theBCCenter" select="if (starts-with($theTSCenter,'-')) then '-' else ()"/>
      <axsl:variable name="theTZCenter" select="replace($theTSCenter,'-?[^+-]+([+-].*)?$','$1')"/>
      <axsl:variable name="theTZhCenter" select="if (string-length($theTZCenter)&gt;0) then substring($theTZCenter,1,3) else ()"/>
      <axsl:variable name="theTZmCenter" select="if (string-length($theTZCenter)&gt;3) then substring($theTZCenter,4) else ()"/>
      <axsl:variable name="theBaseTSCenter" select="replace($theTSCenter,'^-?([^+-]+)([+-].*)?','$1')"/>
      <axsl:variable name="theCenturyCenter" select="if (substring($theBaseTSCenter,1,2) castable as xs:integer) then substring($theBaseTSCenter,1,2) else ()"/>
      <axsl:variable name="theYearCenter" select="if (substring($theBaseTSCenter,3,2) castable as xs:integer) then substring($theBaseTSCenter,3,2) else ()"/>
      <axsl:variable name="theMonthCenter" select="if (substring($theBaseTSCenter,5,2) castable as xs:integer) then substring($theBaseTSCenter,5,2) else ()"/>
      <axsl:variable name="theDayCenter" select="if (substring($theBaseTSCenter,7,2) castable as xs:integer) then substring($theBaseTSCenter,7,2) else ()"/>
      <axsl:variable name="theHourCenter" select="if (substring($theBaseTSCenter,9,2) castable as xs:integer) then substring($theBaseTSCenter,9,2) else ()"/>
      <axsl:variable name="theMinuteCenter" select="if (substring($theBaseTSCenter,11,2) castable as xs:integer) then substring($theBaseTSCenter,11,2) else ()"/>
      <axsl:variable name="theSecondCenter" select="if (substring($theBaseTSCenter,13,2) castable as xs:integer) then substring($theBaseTSCenter,13,2) else ()"/>
      <axsl:variable name="theSubSecondCenter" select="if (substring($theBaseTSCenter,16) castable as xs:integer) then substring($theBaseTSCenter,15) else ()"/>
      <axsl:variable name="cCenturyCenter" select="if (empty($theCenturyCenter)) then '00' else $theCenturyCenter"/>
      <axsl:variable name="cYearCenter" select="if (empty($theYearCenter)) then '00' else $theYearCenter"/>
      <axsl:variable name="cMonthCenter" select="if (empty($theMonthCenter)) then '01' else $theMonthCenter"/>
      <axsl:variable name="cDayCenter" select="if (empty($theDayCenter)) then '01' else $theDayCenter"/>
      <axsl:variable name="cHourCenter" select="if (empty($theHourCenter)) then '00' else $theHourCenter"/>
      <axsl:variable name="cMinuteCenter" select="if (empty($theMinuteCenter)) then '00' else $theMinuteCenter"/>
      <axsl:variable name="cSecondCenter" select="if (empty($theSecondCenter)) then '00' else $theSecondCenter"/>
      <axsl:variable name="cTZCenter" select="string-join(($theTZhCenter,$theTZmCenter),':')"/>
      <axsl:variable name="theTSStringCenter" select="string-join(($theBCCenter,$theCenturyCenter,$theYearCenter,$theMonthCenter,$theDayCenter,$theHourCenter,$theMinuteCenter,$theSecondCenter,$theSubSecondCenter,$theTZCenter),'')"/>
      <axsl:variable name="theCenterDateTime" select="concat($theBCCenter,$cCenturyCenter,$cYearCenter,'-',$cMonthCenter,'-',$cDayCenter,'T',$cHourCenter,':',$cMinuteCenter,':',$cSecondCenter,$theSubSecondCenter,$cTZCenter)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTSCenter) or ($theTSCenter=$theTSStringCenter and $theCenterDateTime castable as xs:dateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-IVL_TS: <axsl:text/>
               <axsl:value-of select="local-name()"/>
               <axsl:text/>/center "<axsl:text/>
               <axsl:value-of select="$theTSCenter"/>
               <axsl:text/>" is not a valid timestamp. (empty($theTSCenter) or ($theTSCenter=$theTSStringCenter and $theCenterDateTime castable as xs:dateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theTSHigh" select="hl7:high/@value"/>
      <axsl:variable name="theBCHigh" select="if (starts-with($theTSHigh,'-')) then '-' else ()"/>
      <axsl:variable name="theTZHigh" select="replace($theTSHigh,'-?[^+-]+([+-].*)?$','$1')"/>
      <axsl:variable name="theTZhHigh" select="if (string-length($theTZHigh)&gt;0) then substring($theTZHigh,1,3) else ()"/>
      <axsl:variable name="theTZmHigh" select="if (string-length($theTZHigh)&gt;3) then substring($theTZHigh,4) else ()"/>
      <axsl:variable name="theBaseTSHigh" select="replace($theTSHigh,'^-?([^+-]+)([+-].*)?','$1')"/>
      <axsl:variable name="theCenturyHigh" select="if (substring($theBaseTSHigh,1,2) castable as xs:integer) then substring($theBaseTSHigh,1,2) else ()"/>
      <axsl:variable name="theYearHigh" select="if (substring($theBaseTSHigh,3,2) castable as xs:integer) then substring($theBaseTSHigh,3,2) else ()"/>
      <axsl:variable name="theMonthHigh" select="if (substring($theBaseTSHigh,5,2) castable as xs:integer) then substring($theBaseTSHigh,5,2) else ()"/>
      <axsl:variable name="theDayHigh" select="if (substring($theBaseTSHigh,7,2) castable as xs:integer) then substring($theBaseTSHigh,7,2) else ()"/>
      <axsl:variable name="theHourHigh" select="if (substring($theBaseTSHigh,9,2) castable as xs:integer) then substring($theBaseTSHigh,9,2) else ()"/>
      <axsl:variable name="theMinuteHigh" select="if (substring($theBaseTSHigh,11,2) castable as xs:integer) then substring($theBaseTSHigh,11,2) else ()"/>
      <axsl:variable name="theSecondHigh" select="if (substring($theBaseTSHigh,13,2) castable as xs:integer) then substring($theBaseTSHigh,13,2) else ()"/>
      <axsl:variable name="theSubSecondHigh" select="if (substring($theBaseTSHigh,16) castable as xs:integer) then substring($theBaseTSHigh,15) else ()"/>
      <axsl:variable name="cCenturyHigh" select="if (empty($theCenturyHigh)) then '00' else $theCenturyHigh"/>
      <axsl:variable name="cYearHigh" select="if (empty($theYearHigh)) then '00' else $theYearHigh"/>
      <axsl:variable name="cMonthHigh" select="if (empty($theMonthHigh)) then '01' else $theMonthHigh"/>
      <axsl:variable name="cDayHigh" select="if (empty($theDayHigh)) then '01' else $theDayHigh"/>
      <axsl:variable name="cHourHigh" select="if (empty($theHourHigh)) then '00' else $theHourHigh"/>
      <axsl:variable name="cMinuteHigh" select="if (empty($theMinuteHigh)) then '00' else $theMinuteHigh"/>
      <axsl:variable name="cSecondHigh" select="if (empty($theSecondHigh)) then '00' else $theSecondHigh"/>
      <axsl:variable name="cTZHigh" select="string-join(($theTZhHigh,$theTZmHigh),':')"/>
      <axsl:variable name="theTSStringHigh" select="string-join(($theBCHigh,$theCenturyHigh,$theYearHigh,$theMonthHigh,$theDayHigh,$theHourHigh,$theMinuteHigh,$theSecondHigh,$theSubSecondHigh,$theTZHigh),'')"/>
      <axsl:variable name="theHighDateTime" select="concat($theBCHigh,$cCenturyHigh,$cYearHigh,'-',$cMonthHigh,'-',$cDayHigh,'T',$cHourHigh,':',$cMinuteHigh,':',$cSecondHigh,$theSubSecondHigh,$cTZHigh)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTSHigh) or ($theTSHigh=$theTSStringHigh and $theHighDateTime castable as xs:dateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-IVL_TS: <axsl:text/>
               <axsl:value-of select="local-name()"/>
               <axsl:text/>/high "<axsl:text/>
               <axsl:value-of select="$theTSHigh"/>
               <axsl:text/>" is not a valid timestamp. (empty($theTSHigh) or ($theTSHigh=$theTSStringHigh and $theHighDateTime castable as xs:dateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty($theTSLow) or empty($theTSHigh) or not($theLowDateTime castable as xs:dateTime) or not($theHighDateTime castable as xs:dateTime) or xs:dateTime($theLowDateTime) le xs:dateTime($theHighDateTime)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-IVL_TS: low/@value (<axsl:text/>
               <axsl:value-of select="$theTSLow"/>
               <axsl:text/>) must be before high/@value (<axsl:text/>
               <axsl:value-of select="$theTSHigh"/>
               <axsl:text/>) (empty($theTSLow) or empty($theTSHigh) or not($theLowDateTime castable as xs:dateTime) or not($theHighDateTime castable as xs:dateTime) or xs:dateTime($theLowDateTime) le xs:dateTime($theHighDateTime) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_IVL_TS)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d61172e36-false-d61191e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']" priority="1011" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@classCode) = ('ASSIGNED')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): de waarde van classCode MOET 'ASSIGNED' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@classCode"/>
               <axsl:text/>" (string(@classCode) = ('ASSIGNED') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:id) &gt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:code) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): element hl7:code komt te vaak voor [max 1x]. (count(hl7:code) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:playingEntity[@classCode = ('PSN', 'ORG')][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): element hl7:playingEntity[@classCode = ('PSN', 'ORG')][@determinerCode = 'INSTANCE'] komt te vaak voor [max 1x]. (count(hl7:playingEntity[@classCode = ('PSN', 'ORG')][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): element hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] komt te vaak voor [max 1x]. (count(hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d61172e43-false-d61256e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:id" priority="1010" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @identifierName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor and @identifierName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @displayable)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor and @displayable) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @reliability)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor and @reliability) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @assigningAuthorityName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor and @assigningAuthorityName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@root) &lt;= 128)">
         <axsl:message>dtr1-8-II: @root should not be longer than 128 characters. Found <axsl:text/>
            <axsl:value-of select="string-length(@root)"/>
            <axsl:text/> characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
      </axsl:if>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@extension) &lt;= 64)">
         <axsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Found <axsl:text/>
            <axsl:value-of select="string-length(@extension)"/>
            <axsl:text/> characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
      </axsl:if>
      <axsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <axsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <axsl:variable name="UUIDpattern" select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID or UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <axsl:variable name="root" select="@root"/>
      <axsl:variable name="extension" select="@extension"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-II: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT info-->

      <axsl:choose>
         <axsl:when test="not(matches(@root, $UUIDpattern) and matches(@root, '[a-z]') and matches(@root, '[A-Z]'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-II: Lower case and Upper case mixed UUID "<axsl:text/>
               <axsl:value-of select="@root"/>
               <axsl:text/>" found in @root. UUIDs SHALL not have mixed cases. (not(matches(@root, $UUIDpattern) and matches(@root, '[a-z]') and matches(@root, '[A-Z]')) / info / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d61172e49-false-d61274e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:code" priority="1009" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@code)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@codeSystemName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@code or not(@displayName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @code)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-CD: co-occurence violation. Cannot have code and null (not(@nullFlavor and @code) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @displayName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-CD: co-occurence violation. Cannot have displayName and null (not(@nullFlavor and @displayName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-CD: no null on translations (Exceptional values (NULL-values) can not be elements of a set.) (not(.//hl7:translation/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystem][not(@code)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-CD: translation code requires codeSystem (not(.//hl7:translation[@codeSystem][not(@code)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystemName][not(@codeSystem)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (not(.//hl7:translation[@codeSystemName][not(@codeSystem)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@displayName][not(@code)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-CD: translation displayName only if code (not(.//hl7:translation[@displayName][not(@code)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="matches(@displayName,'[\r\n\t]')">
         <axsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
      </axsl:if>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <axsl:variable name="code" select="@code"/>
      <axsl:variable name="codeSystem" select="@codeSystem"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[@code=$code][@codeSystem=$codeSystem])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-CD: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> (@code=<axsl:text/>
               <axsl:value-of select="$code"/>
               <axsl:text/> @codeSystem=<axsl:text/>
               <axsl:value-of select="$codeSystem"/>
               <axsl:text/>) SHALL be distinct (not($set_other[@code=$code][@codeSystem=$codeSystem]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="translations" select=".//hl7:translation/concat(@code,@codeSystem)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count($translations)=count(distinct-values($translations))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-19-CD: [RIM-002] translations SHALL be distinct (count($translations)=count(distinct-values($translations)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-20-CD: originalText/@language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:qualifier)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CE)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theCode" select="@code"/>
      <axsl:variable name="theCodeSystem" select="@codeSystem"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.1.6-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.1.7-DYNAMIC.xml')//valueSet[1][conceptList/include[@codeSystem = $theCodeSystem]])"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3 OrganisatieTypeCodelijst (DYNAMISCH) of 2.16.840.1.113883.2.4.3.11.60.40.2.17.1.6 SpecialismeUZICodelijst (DYNAMISCH) of 2.16.840.1.113883.2.4.3.11.60.40.2.17.1.7 SpecialismeAGBCodelijst (DYNAMISCH)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.1.6-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.1.7-DYNAMIC.xml')//valueSet[1][conceptList/include[@codeSystem = $theCodeSystem]]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.1.6-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem])">
         <axsl:message>(KEZO PART CDA Custodian Party (Body)): element hl7:code is gecodeerd met bindingssterkte 'required' en bevat een code die verouderd is. (exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.1.6-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem]) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
      </axsl:if>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d61172e61-false-d61314e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:addr" priority="1008" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-AD: address shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/>)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-AD: no useablePeriod if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:useablePeriod][@updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-AD: updateMode shall not be used on address elements (count(*[self::hl7:useablePeriod][@updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or          string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-AD: useablePeriod/low/@value must have the same precision as useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or         number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-AD: useablePeriod/low/@value must be before useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="tum" select="'^(us|ms|s|min|h|d|wk|mo|a|)$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="matches(hl7:useablePeriod/hl7:width/@unit, $tum)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-AD: for useablePeriod/width only us (microseconds), ms (milliseconds), s (seconds), min (minute), h (hours), d (day), wk (week), mo (month) or a (year) are allowed (matches(hl7:useablePeriod/hl7:width/@unit, $tum) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="*[not(@nullFlavor or self::hl7:useablePeriod)][normalize-space(.)='']">
         <axsl:message>dtr1-8-AD: empty address particles should not be present. (*[not(@nullFlavor or self::hl7:useablePeriod)][normalize-space(.)=''] / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
      </axsl:if>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="value" select="string-join((.//@use|.//text()),'')"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-AD: [RIM-001] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> SHALL NOT have nullFlavor, if there are other <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[string-join((.//@use|.//text()),'')=$value])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-AD: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> (<axsl:text/>
               <axsl:value-of select="$value"/>
               <axsl:text/>) SHALL be distinct (not($set_other[string-join((.//@use|.//text()),'')=$value]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_AD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d61172e64-false-d61326e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:telecom" priority="1007" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or @value"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-URL: elements of type URL SHALL have a @value attribute. (@nullFlavor or @value / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_URL)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or @value=iri-to-uri(@value)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-URL: @value must be a valid URI, e.g. '<axsl:text/>
               <axsl:value-of select="iri-to-uri(@value)"/>
               <axsl:text/>'. (@nullFlavor or @value=iri-to-uri(@value) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_URL)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="use" select="@use"/>
      <axsl:variable name="value" select="@value"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-URL: [RIM-001] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> SHALL NOT have nullFlavor, if there are other <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_URL)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[@use=$use][@value=$value])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-URL: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> (<axsl:text/>
               <axsl:value-of select="$value"/>
               <axsl:text/>) SHALL be distinct (not($set_other[@use=$use][@value=$value]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_URL)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="urlScheme" select="substring-before(@value,':')"/>
      <axsl:variable name="urlStr" select="substring-after(@value,':')"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="if ($urlScheme='tel' or $urlScheme='fax') then (         matches($urlStr,'^(\+?([\d()./-]|(%[a-f\d]{2}))+)*(;(phone-context=((\+?([\d()./-]|(%[a-f\d]{2}))+)|(([a-z\d-]|(%[a-f\d]{2}))+(\.([a-z\d-]|(%[a-f\d]{2}))+)*))|(ext=[\d./-]+)|(isub=(([a-z\d();/?:@&amp;=+$,_.!~*''-])|(%[a-f\d]{2}))+)|([a-z\d-]+=([a-z\d\[\]/:&amp;+$_.!~*()-]|(%[a-f\d]{2}))+)))*$')         ) else (1=1)"/>
         <axsl:otherwise>
            <axsl:message>dtr3-URL.NL.EXTENDED: URIs with URL Scheme <axsl:text/>
               <axsl:value-of select="$urlScheme"/>
               <axsl:text/> MUST comply with RFC 3966 (if ($urlScheme='tel' or $urlScheme='fax') then ( matches($urlStr,'^(\+?([\d()./-]|(%[a-f\d]{2}))+)*(;(phone-context=((\+?([\d()./-]|(%[a-f\d]{2}))+)|(([a-z\d-]|(%[a-f\d]{2}))+(\.([a-z\d-]|(%[a-f\d]{2}))+)*))|(ext=[\d./-]+)|(isub=(([a-z\d();/?:@&amp;=+$,_.!~*''-])|(%[a-f\d]{2}))+)|([a-z\d-]+=([a-z\d\[\]/:&amp;+$_.!~*()-]|(%[a-f\d]{2}))+)))*$') ) else (1=1) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_URL.NL.EXTENDED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="if ($urlScheme='file') then (         matches($urlStr,'^///{0,2}((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <axsl:otherwise>
            <axsl:message>dtr4-URL.NL.EXTENDED: URIs with URL Scheme <axsl:text/>
               <axsl:value-of select="$urlScheme"/>
               <axsl:text/> MUST comply with RFC 1738. (if ($urlScheme='file') then ( matches($urlStr,'^///{0,2}((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_URL.NL.EXTENDED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="if ($urlScheme='nfs') then (         matches($urlStr,'^//((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))/?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <axsl:otherwise>
            <axsl:message>dtr5-URL.NL.EXTENDED: URIs with URL Scheme <axsl:text/>
               <axsl:value-of select="$urlScheme"/>
               <axsl:text/> MUST comply with RFC 2224. (if ($urlScheme='nfs') then ( matches($urlStr,'^//((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))/?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_URL.NL.EXTENDED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="if ($urlScheme='ftp' or $urlScheme='ftps') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;=~_-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z][\w-]*))?)?(/(([a-z\d$\.+!*(),?&amp;_~=-])|(%[a-f\d]{2}))*)*(;type=[aid])?$','i')         ) else (1=1)"/>
         <axsl:otherwise>
            <axsl:message>dtr6-URL.NL.EXTENDED: URIs with URL Scheme <axsl:text/>
               <axsl:value-of select="$urlScheme"/>
               <axsl:text/> MUST comply with RFC 1738. (if ($urlScheme='ftp' or $urlScheme='ftps') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;=~_-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z][\w-]*))?)?(/(([a-z\d$\.+!*(),?&amp;_~=-])|(%[a-f\d]{2}))*)*(;type=[aid])?$','i') ) else (1=1) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_URL.NL.EXTENDED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="if ($urlScheme='http' or $urlScheme='https') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*(\?(([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*(&amp;((([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*)?)*)?(#([\w~!$+|.,*:=~_]|%[a-f\d]{2})*)?$', 'i')         ) else (1=1)"/>
         <axsl:otherwise>
            <axsl:message>dtr7-URL.NL.EXTENDED: URIs with URL Scheme <axsl:text/>
               <axsl:value-of select="$urlScheme"/>
               <axsl:text/> MUST comply with RFC 1738 (if ($urlScheme='http' or $urlScheme='https') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*(\?(([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*(&amp;((([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*)?)*)?(#([\w~!$+|.,*:=~_]|%[a-f\d]{2})*)?$', 'i') ) else (1=1) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_URL.NL.EXTENDED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="if ($urlScheme='telnet') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <axsl:otherwise>
            <axsl:message>dtr8-URL.NL.EXTENDED: URIs with URL Scheme <axsl:text/>
               <axsl:value-of select="$urlScheme"/>
               <axsl:text/> MUST comply with RFC 1738. (if ($urlScheme='telnet') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_URL.NL.EXTENDED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="if ($urlScheme='mailto') then (         matches($urlStr,'^[\w$\.+!*(),?&amp;~_=-]+(\.[\w$\.+!*(),?&amp;~_=-]+)*@([\w$+!*(),?&amp;~_=-]+\.)+([a-z]{2,4})$','i')         ) else (1=1)"/>
         <axsl:otherwise>
            <axsl:message>dtr9-URL.NL.EXTENDED: URIs with URL Scheme <axsl:text/>
               <axsl:value-of select="$urlScheme"/>
               <axsl:text/> MUST comply with RFC 2368. Note that it is not allowed to carry extra headers (if ($urlScheme='mailto') then ( matches($urlStr,'^[\w$\.+!*(),?&amp;~_=-]+(\.[\w$\.+!*(),?&amp;~_=-]+)*@([\w$+!*(),?&amp;~_=-]+\.)+([a-z]{2,4})$','i') ) else (1=1) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_URL.NL.EXTENDED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="if ($urlScheme='x-hl7-applicatie') then (         matches($urlStr,'^2\.16\.840\.1\.113883\.2\.4\.6\.6\.[1-9]\d*$')         ) else (1=1)"/>
         <axsl:otherwise>
            <axsl:message>dtr10-URL.NL.EXTENDED: URIs with URL Scheme <axsl:text/>
               <axsl:value-of select="$urlScheme"/>
               <axsl:text/> MUST start with "2.16.840.1.113883.2.4.6.6." prefixed with the numerical part (if ($urlScheme='x-hl7-applicatie') then ( matches($urlStr,'^2\.16\.840\.1\.113883\.2\.4\.6\.6\.[1-9]\d*$') ) else (1=1) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_URL.NL.EXTENDED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="if ($urlScheme='mllp') then (         matches($urlStr,'^//(([1-2]\d{0,2})(\.([1-2]\d{0,2})){3}|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2}))):(([1-9]\d{0,4})|([A-Za-z]\w*))/$')         ) else (1=1)"/>
         <axsl:otherwise>
            <axsl:message>dtr11-URL.NL.EXTENDED: URIs with URL Scheme <axsl:text/>
               <axsl:value-of select="$urlScheme"/>
               <axsl:text/> MUST comply with mllp://host:port/ where 'host' MAY be a name or IP and 'port' a named port or integer (if ($urlScheme='mllp') then ( matches($urlStr,'^//(([1-2]\d{0,2})(\.([1-2]\d{0,2})){3}|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2}))):(([1-9]\d{0,4})|([A-Za-z]\w*))/$') ) else (1=1) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_URL.NL.EXTENDED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:usablePeriod)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-TEL.NL.EXTENDED: not null and usablePeriod (not(@nullFlavor and hl7:usablePeriod) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_TEL.NL.EXTENDED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d61172e66-false-d61338e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = ('PSN', 'ORG')][@determinerCode = 'INSTANCE']" priority="1006" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@classCode"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): attribute @classCode MOET aanwezig zijn. (@classCode / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theAttValue" select="distinct-values(tokenize(normalize-space(@classCode),'\s'))"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@classCode) or empty($theAttValue[not(. = (('PSN','ORG')))])"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): de waarde van classCode MOET 'code PSN of code ORG' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@classCode"/>
               <axsl:text/>" (not(@classCode) or empty($theAttValue[not(. = (('PSN','ORG')))]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@determinerCode"/>
               <axsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:name) &gt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d61172e77-false-d61382e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = ('PSN', 'ORG')][@determinerCode = 'INSTANCE']/hl7:name" priority="1005" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and (* or string-length(normalize-space(string-join(text(),'')))&gt;0))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1.1-EN: entity name shall not be null and have elements or text (not(@nullFlavor and (* or string-length(normalize-space(string-join(text(),'')))&gt;0)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(* and string-length(normalize-space(string-join(text(),'')))&gt;0)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1.2-EN: entity name shall not have both elements and text (no mixed content) (not(* and string-length(normalize-space(string-join(text(),'')))&gt;0) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or * or string-length(normalize-space(string-join(text(),'')))&gt;0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1.3-EN: entity name that is not null shall not be empty (@nullFlavor or * or string-length(normalize-space(string-join(text(),'')))&gt;0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="*[not(self::*:validTime | @nullFlavor)][normalize-space(.)='']">
         <axsl:message>dtr1-3-EN: empty name particles should not be present. (*[not(self::*:validTime | @nullFlavor)][normalize-space(.)=''] / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
      </axsl:if>

		<!--REPORT warning-->

      <axsl:if test="substring(normalize-space(.),1,1)='&#34;'">
         <axsl:message>dtr1-4-EN: Use of quotes at the beginning of a name are probably not correct. (substring(normalize-space(.),1,1)='"' / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
      </axsl:if>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="value" select="string-join((.//@use|.//text()),'')"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-EN: [RIM-001] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> SHALL NOT have nullFlavor, if there are other <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[string-join((.//@use|.//text()),'')=$value])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-EN: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> (<axsl:text/>
               <axsl:value-of select="$value"/>
               <axsl:text/>) SHALL be distinct (not($set_other[string-join((.//@use|.//text()),'')=$value]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-EN: enxp elements SHALL have distinct values in @qualifier (not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_EN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(*[tokenize(@qualifier,'\s')='LS'])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-PN: Person names SHALL NOT contain a name part qualified with 'LS' (Legal status for organizations) (not(*[tokenize(@qualifier,'\s')='LS']) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_PN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d61172e80-false-d61394e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']" priority="1004" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@classCode) = ('ORG')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): de waarde van classCode MOET 'ORG' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@classCode"/>
               <axsl:text/>" (string(@classCode) = ('ORG') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@determinerCode"/>
               <axsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x]. (count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:desc) &gt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): element hl7:desc is required [min 1x]. (count(hl7:desc) &gt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:desc) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): element hl7:desc komt te vaak voor [max 1x]. (count(hl7:desc) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d61172e92-false-d61444e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id" priority="1003" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @identifierName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor and @identifierName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @displayable)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor and @displayable) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @reliability)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor and @reliability) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @assigningAuthorityName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor and @assigningAuthorityName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@root) &lt;= 128)">
         <axsl:message>dtr1-8-II: @root should not be longer than 128 characters. Found <axsl:text/>
            <axsl:value-of select="string-length(@root)"/>
            <axsl:text/> characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
      </axsl:if>

		<!--REPORT warning-->

      <axsl:if test="not(string-length(@extension) &lt;= 64)">
         <axsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Found <axsl:text/>
            <axsl:value-of select="string-length(@extension)"/>
            <axsl:text/> characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
      </axsl:if>
      <axsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <axsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <axsl:variable name="UUIDpattern" select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID or UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <axsl:variable name="root" select="@root"/>
      <axsl:variable name="extension" select="@extension"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-II: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT info-->

      <axsl:choose>
         <axsl:when test="not(matches(@root, $UUIDpattern) and matches(@root, '[a-z]') and matches(@root, '[A-Z]'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-II: Lower case and Upper case mixed UUID "<axsl:text/>
               <axsl:value-of select="@root"/>
               <axsl:text/>" found in @root. UUIDs SHALL not have mixed cases. (not(matches(@root, $UUIDpattern) and matches(@root, '[a-z]') and matches(@root, '[A-Z]')) / info / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_II)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d61172e99-false-d61458e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]" priority="1002" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@code)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@codeSystemName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@code or not(@displayName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @code)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-CD: co-occurence violation. Cannot have code and null (not(@nullFlavor and @code) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @displayName)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-CD: co-occurence violation. Cannot have displayName and null (not(@nullFlavor and @displayName) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-CD: no null on translations (Exceptional values (NULL-values) can not be elements of a set.) (not(.//hl7:translation/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystem][not(@code)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-CD: translation code requires codeSystem (not(.//hl7:translation[@codeSystem][not(@code)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystemName][not(@codeSystem)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (not(.//hl7:translation[@codeSystemName][not(@codeSystem)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:translation[@displayName][not(@code)])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-CD: translation displayName only if code (not(.//hl7:translation[@displayName][not(@code)]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--REPORT warning-->

      <axsl:if test="matches(@displayName,'[\r\n\t]')">
         <axsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
      </axsl:if>
      <axsl:variable name="name" select="local-name()"/>
      <axsl:variable name="set_other" select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <axsl:variable name="code" select="@code"/>
      <axsl:variable name="codeSystem" select="@codeSystem"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not($set_other[@code=$code][@codeSystem=$codeSystem])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-CD: [RIM-002] <axsl:text/>
               <axsl:value-of select="$name"/>
               <axsl:text/> (@code=<axsl:text/>
               <axsl:value-of select="$code"/>
               <axsl:text/> @codeSystem=<axsl:text/>
               <axsl:value-of select="$codeSystem"/>
               <axsl:text/>) SHALL be distinct (not($set_other[@code=$code][@codeSystem=$codeSystem]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="translations" select=".//hl7:translation/concat(@code,@codeSystem)"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count($translations)=count(distinct-values($translations))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-19-CD: [RIM-002] translations SHALL be distinct (count($translations)=count(distinct-values($translations)) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))])"/>
         <axsl:otherwise>
            <axsl:message>dtr1-20-CD: originalText/@language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CD)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:qualifier)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_CE)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="theCode" select="@code"/>
      <axsl:variable name="theCodeSystem" select="@codeSystem"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3 OrganisatieTypeCodelijst (DYNAMISCH)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE d61172e104-false-d61481e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:desc" priority="1001" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="every $elm in descendant-or-self::* satisfies $elm[             not(@nullFlavor) or             (@nullFlavor                        and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. =  '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or             (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation']))         ]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' 
        (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension or &lt;originalText&gt; may have a value). Found: &lt;<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>
      
               <axsl:text/>
               <axsl:value-of select="for $att in (@* except @nullFlavor) return concat(' ', name($att), '=&#34;', $att, '&#34;')"/>
               <axsl:text/>&gt;<axsl:text/>
               <axsl:value-of select="for $elm in * return concat('&lt;', name($elm), '... /&gt;')"/>
               <axsl:text/>&lt;/<axsl:text/>
               <axsl:value-of select="name()"/>
               <axsl:text/>&gt; (every $elm in descendant-or-self::* satisfies $elm[ not(@nullFlavor) or (@nullFlavor and not(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor|@partType|@codeSystem[. = '2.16.840.1.113883.5.139']|@codeSystemName[. = 'TimingEvent']|@integrityCheckAlgorithm[. = 'SHA-1']|@inverted[. = 'false']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1']) | * | text()[string-length(normalize-space()) gt 0])) or (@nullFlavor = ('OTH', 'NA', 'UNC') and not(@* except (@xsi:type|@xsi:nil|@*:valueSet|@*:valueSetVersion|@codeSystem|@codeSystemName|@codeSystemVersion|@extension|@nullFlavor|@partType|@integrityCheckAlgorithm[. = 'SHA-1']|@mediaType[. = 'text/plain']|@operator[. = 'I']|@representation[. = 'TXT']|@inclusive[. = 'true']|@unit[. = '1'])) and (@extension | @codeSystem | *[local-name()='originalText'] | *[local-name()='translation'])) ] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ANY)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="@nullFlavor | * | text()[string-length(normalize-space()) gt 0]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor | * | text()[string-length(normalize-space()) gt 0] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_BIN)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <axsl:otherwise>
            <axsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@value or xml) or not(@charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @mediaType) or @mediaType = 'text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor and @mediaType) or @mediaType = 'text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @charset)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor and @charset) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @language)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-12-ED: no language if null (not(@nullFlavor and @language) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor and @compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor and @integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor and @integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@nullFlavor and hl7:translation)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor and hl7:translation) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <axsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <axsl:otherwise>
            <axsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ED)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:reference)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(hl7:thumbnail)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@representation) or @representation='TXT'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@compression)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheck)"/>
         <axsl:otherwise>
            <axsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1'"/>
         <axsl:otherwise>
            <axsl:message>dtr1-9-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) or @integrityCheckAlgorithm = 'SHA-1' / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://docs.art-decor.org/documentation/datatypes/DTr1_ST)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<axsl:text/>
               <axsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>}:<axsl:text/>
               <axsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <axsl:text/>" (empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

	<!--RULE -->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]" priority="1000" mode="M15">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@typeCode"/>
               <axsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen): de waarde van contextControlCode MOET 'OP' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@contextControlCode"/>
               <axsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>
   <axsl:template match="text()" priority="-1" mode="M15"/>
   <axsl:template match="@*|node()" priority="-2" mode="M15">
      <axsl:apply-templates select="*" mode="M15"/>
   </axsl:template>

<!--PATTERN template-2.16.840.1.113883.2.4.3.11.60.66.10.14-2018-04-18T000000-closedOrganizer Contactverslagen-->


	<!--RULE d152e8916-true-d61712e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14'] | self::hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:statusCode[@code = 'completed'] | self::hl7:recordTarget[hl7:patientRole] | self::hl7:participant[@typeCode='RESP'] | self::hl7:participant[@typeCode='CST'] | self::hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]])]" priority="1047" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d152e8916-true-d61712e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14'] | hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:statusCode[@code = 'completed'] | hl7:recordTarget[hl7:patientRole] | hl7:participant[@typeCode='RESP'] | hl7:participant[@typeCode='CST'] | hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]] (rule-reference: d152e8916-true-d61712e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d61732e21-true-d61784e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/*[not(@xsi:nil = 'true')][not(self::hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']])]" priority="1046" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal)/d61732e21-true-d61784e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']] (rule-reference: d61732e21-true-d61784e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d61732e23-true-d61853e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/*[not(@xsi:nil = 'true')][not(self::hl7:id[@root = '2.16.840.1.113883.2.4.6.3'] | self::hl7:addr | self::hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]])]" priority="1045" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal)/d61732e23-true-d61853e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:id[@root = '2.16.840.1.113883.2.4.6.3'] | hl7:addr | hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]] (rule-reference: d61732e23-true-d61853e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d61732e39-true-d61901e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/*[not(@xsi:nil = 'true')][not(self::hl7:streetName | self::hl7:houseNumber | self::hl7:buildingNumberSuffix | self::hl7:additionalLocator | self::hl7:postalCode | self::hl7:county | self::hl7:city | self::hl7:country | self::hl7:unitID | self::hl7:useablePeriod)]" priority="1044" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal)/d61732e39-true-d61901e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:streetName | hl7:houseNumber | hl7:buildingNumberSuffix | hl7:additionalLocator | hl7:postalCode | hl7:county | hl7:city | hl7:country | hl7:unitID | hl7:useablePeriod (rule-reference: d61732e39-true-d61901e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d61732e44-true-d61996e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/*[not(@xsi:nil = 'true')][not(self::hl7:name | self::hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code] | self::hl7:birthTime | self::sdtc:multipleBirthInd)]" priority="1043" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal)/d61732e44-true-d61996e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:name | hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code] | hl7:birthTime | sdtc:multipleBirthInd (rule-reference: d61732e44-true-d61996e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d61732e46-true-d62016e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/*[not(@xsi:nil = 'true')][not(self::hl7:prefix[@qualifier='NB'] | self::hl7:given[@qualifier='BR'] | self::hl7:given[@qualifier='CL'] | self::hl7:given[@qualifier='IN'] | self::hl7:given[not(@qualifier)] | self::hl7:prefix[not(@qualifier)] | self::hl7:family[not(@qualifier)] | self::hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][tokenize(@qualifier,'\s')='BR']] | self::hl7:family[tokenize(@qualifier,'\s')='BR'] | self::hl7:delimiter[not(@nullFlavor)] | self::hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][tokenize(@qualifier,'\s')='SP']] | self::hl7:family[tokenize(@qualifier,'\s')='SP'] | self::hl7:suffix[not(@nullFlavor)] | self::hl7:validTime)]" priority="1042" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(CDA recordTarget SDTC NL BSN Minimal)/d61732e46-true-d62016e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:prefix[@qualifier='NB'] | hl7:given[@qualifier='BR'] | hl7:given[@qualifier='CL'] | hl7:given[@qualifier='IN'] | hl7:given[not(@qualifier)] | hl7:prefix[not(@qualifier)] | hl7:family[not(@qualifier)] | hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][tokenize(@qualifier,'\s')='BR']] | hl7:family[tokenize(@qualifier,'\s')='BR'] | hl7:delimiter[not(@nullFlavor)] | hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][tokenize(@qualifier,'\s')='SP']] | hl7:family[tokenize(@qualifier,'\s')='SP'] | hl7:suffix[not(@nullFlavor)] | hl7:validTime (rule-reference: d61732e46-true-d62016e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.3.10.2)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62107e5-true-d62118e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='RESP']/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:participantRole[@classCode = 'ASSIGNED'])]" priority="1041" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Inhoudsverantwoordelijke (Body))/d62107e5-true-d62118e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:time | hl7:participantRole[@classCode = 'ASSIGNED'] (rule-reference: d62107e5-true-d62118e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9031)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62123e35-true-d62166e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @nullFlavor] | self::hl7:addr | self::hl7:telecom | self::hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE'] | self::hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE'])]" priority="1040" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body))/d62123e35-true-d62166e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:id | hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @nullFlavor] | hl7:addr | hl7:telecom | hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE'] | hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] (rule-reference: d62123e35-true-d62166e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62123e57-true-d62211e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/*[not(@xsi:nil = 'true')][not(self::hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] | self::hl7:name)]" priority="1039" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body))/d62123e57-true-d62211e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] | hl7:name (rule-reference: d62123e57-true-d62211e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62123e74-true-d62249e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor] | self::hl7:desc)]" priority="1038" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body))/d62123e74-true-d62249e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:id | hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor] | hl7:desc (rule-reference: d62123e74-true-d62249e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62269e5-true-d62280e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='CST']/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:participantRole[@classCode = 'ASSIGNED'])]" priority="1037" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Dossierhouder)/d62269e5-true-d62280e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:time | hl7:participantRole[@classCode = 'ASSIGNED'] (rule-reference: d62269e5-true-d62280e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9032)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62285e36-true-d62340e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code | self::hl7:addr | self::hl7:telecom | self::hl7:playingEntity[@classCode = ('PSN', 'ORG')][@determinerCode = 'INSTANCE'] | self::hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE'])]" priority="1036" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body))/d62285e36-true-d62340e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:id | hl7:code | hl7:addr | hl7:telecom | hl7:playingEntity[@classCode = ('PSN', 'ORG')][@determinerCode = 'INSTANCE'] | hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] (rule-reference: d62285e36-true-d62340e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62285e66-true-d62382e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = ('PSN', 'ORG')][@determinerCode = 'INSTANCE']/*[not(@xsi:nil = 'true')][not(self::hl7:name)]" priority="1035" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body))/d62285e66-true-d62382e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:name (rule-reference: d62285e66-true-d62382e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62285e80-true-d62417e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] | self::hl7:desc)]" priority="1034" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Custodian Party (Body))/d62285e80-true-d62417e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:id | hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] | hl7:desc (rule-reference: d62285e80-true-d62417e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9041)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d152e8953-true-d62528e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/*[not(@xsi:nil = 'true')][not(self::hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']])]" priority="1033" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d152e8953-true-d62528e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']] (rule-reference: d152e8953-true-d62528e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62441e4-true-d62658e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207'] | self::hl7:id[not(@nullFlavor)] | self::hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:statusCode[@code = 'completed'] | self::hl7:effectiveTime[not(@nullFlavor)] | self::hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']] | self::hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter] | self::hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]] | self::hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]] | self::hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.209']]] | self::hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]] | self::hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.211']]])]" priority="1032" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d62441e4-true-d62658e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207'] | hl7:id[not(@nullFlavor)] | hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:statusCode[@code = 'completed'] | hl7:effectiveTime[not(@nullFlavor)] | hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']] | hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter] | hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]] | hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]] | hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.209']]] | hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]] | hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.211']]] (rule-reference: d62441e4-true-d62658e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62441e34-true-d62702e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/*[not(@xsi:nil = 'true')][not(self::hl7:time | self::hl7:participantRole[@classCode = 'ASSIGNED'])]" priority="1031" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d62441e34-true-d62702e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:time | hl7:participantRole[@classCode = 'ASSIGNED'] (rule-reference: d62441e34-true-d62702e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62707e35-true-d62750e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @nullFlavor] | self::hl7:addr | self::hl7:telecom | self::hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE'] | self::hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE'])]" priority="1030" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body))/d62707e35-true-d62750e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:id | hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @nullFlavor] | hl7:addr | hl7:telecom | hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE'] | hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] (rule-reference: d62707e35-true-d62750e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62707e57-true-d62795e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/*[not(@xsi:nil = 'true')][not(self::hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] | self::hl7:name)]" priority="1029" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body))/d62707e57-true-d62795e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] | hl7:name (rule-reference: d62707e57-true-d62795e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62707e74-true-d62833e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:participant[hl7:participantRole[@classCode = 'ASSIGNED']]/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/*[not(@xsi:nil = 'true')][not(self::hl7:id | self::hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor] | self::hl7:desc)]" priority="1028" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Responsible Party (Body))/d62707e74-true-d62833e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:id | hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor] | hl7:desc (rule-reference: d62707e74-true-d62833e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9030)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62853e6-true-d62864e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter]/*[not(@xsi:nil = 'true')][not(self::hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN'])]" priority="1027" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(part Encounter reference)/d62853e6-true-d62864e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN'] (rule-reference: d62853e6-true-d62864e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.32)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62853e20-true-d62880e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter]/hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN']/*[not(@xsi:nil = 'true')][not(self::hl7:id[not(@nullFlavor)])]" priority="1026" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(part Encounter reference)/d62853e20-true-d62880e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:id[not(@nullFlavor)] (rule-reference: d62853e20-true-d62880e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.32)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62890e6-true-d62901e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/*[not(@xsi:nil = 'true')][not(self::hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]])]" priority="1025" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(part Concern reference)/d62890e6-true-d62901e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]] (rule-reference: d62890e6-true-d62901e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62890e21-true-d62922e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]/*[not(@xsi:nil = 'true')][not(self::hl7:id[not(@nullFlavor)] | self::hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')])]" priority="1024" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(part Concern reference)/d62890e21-true-d62922e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:id[not(@nullFlavor)] | hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')] (rule-reference: d62890e21-true-d62922e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62441e50-true-d62987e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]]/*[not(@xsi:nil = 'true')][not(self::hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']])]" priority="1023" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d62441e50-true-d62987e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']] (rule-reference: d62441e50-true-d62987e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62939e6-true-d63059e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208'] | self::hl7:code[(@code = '61150-9' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:text[not(@nullFlavor)] | self::hl7:statusCode[@code = 'completed'] | self::hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]])]" priority="1022" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d62939e6-true-d63059e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208'] | hl7:code[(@code = '61150-9' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:text[not(@nullFlavor)] | hl7:statusCode[@code = 'completed'] | hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]] (rule-reference: d62939e6-true-d63059e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62939e30-true-d63158e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]]/*[not(@xsi:nil = 'true')][not(self::hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']])]" priority="1021" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d62939e30-true-d63158e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']] (rule-reference: d62939e30-true-d63158e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d63086e6-true-d63268e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213'] | self::hl7:id[not(@nullFlavor)] | self::hl7:code[(@code = '282291009' and @codeSystem = '2.16.840.1.113883.6.96')] | self::hl7:statusCode[@code = 'completed'] | self::hl7:effectiveTime | self::hl7:value | self::hl7:author[hl7:assignedAuthor])]" priority="1020" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d63086e6-true-d63268e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213'] | hl7:id[not(@nullFlavor)] | hl7:code[(@code = '282291009' and @codeSystem = '2.16.840.1.113883.6.96')] | hl7:statusCode[@code = 'completed'] | hl7:effectiveTime | hl7:value | hl7:author[hl7:assignedAuthor] (rule-reference: d63086e6-true-d63268e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d63086e44-true-d63309e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]/hl7:effectiveTime/*[not(@xsi:nil = 'true')][not(self::hl7:low | self::hl7:high)]" priority="1019" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d63086e44-true-d63309e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:low | hl7:high (rule-reference: d63086e44-true-d63309e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d63086e69-true-d63337e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]/hl7:value/*[not(@xsi:nil = 'true')][not(self::hl7:originalText)]" priority="1018" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d63086e69-true-d63337e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:originalText (rule-reference: d63086e69-true-d63337e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d63086e100-true-d63396e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:functionCode | self::hl7:time | self::hl7:assignedAuthor)]" priority="1017" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d63086e100-true-d63396e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:functionCode | hl7:time | hl7:assignedAuthor (rule-reference: d63086e100-true-d63396e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d63401e17-true-d63459e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id[not(@nullFlavor)] | self::hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] | self::hl7:addr | self::hl7:telecom | self::hl7:assignedPerson | self::hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']])]" priority="1016" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Author (Body))/d63401e17-true-d63459e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:id[not(@nullFlavor)] | hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] | hl7:addr | hl7:telecom | hl7:assignedPerson | hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']] (rule-reference: d63401e17-true-d63459e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d63464e25-true-d63499e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]" priority="1015" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Assigned Entity)/d63464e25-true-d63499e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:name (rule-reference: d63464e25-true-d63499e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d63464e35-true-d63539e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.208']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/*[not(@xsi:nil = 'true')][not(self::hl7:id[@root = '2.16.528.1.1007.3.3'] | self::hl7:id | self::hl7:name | self::hl7:telecom | self::hl7:addr | self::hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor])]" priority="1014" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Assigned Entity)/d63464e35-true-d63539e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:id[@root = '2.16.528.1.1007.3.3'] | hl7:id | hl7:name | hl7:telecom | hl7:addr | hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] (rule-reference: d63464e35-true-d63539e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62441e58-true-d63592e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.209']]]/*[not(@xsi:nil = 'true')][not(self::hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.209']])]" priority="1013" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d62441e58-true-d63592e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.209']] (rule-reference: d62441e58-true-d63592e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d63580e6-true-d63623e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.209']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.209']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.209'] | self::hl7:code[(@code = '61149-1' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:text[not(@nullFlavor)] | self::hl7:statusCode[@code = 'completed'])]" priority="1012" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d63580e6-true-d63623e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.209'] | hl7:code[(@code = '61149-1' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:text[not(@nullFlavor)] | hl7:statusCode[@code = 'completed'] (rule-reference: d63580e6-true-d63623e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62441e66-true-d63698e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]]/*[not(@xsi:nil = 'true')][not(self::hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']])]" priority="1011" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d62441e66-true-d63698e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']] (rule-reference: d62441e66-true-d63698e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d63650e6-true-d63770e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210'] | self::hl7:code[(@code = '51848-0' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:text[not(@nullFlavor)] | self::hl7:statusCode[@code = 'completed'] | self::hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]])]" priority="1010" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d63650e6-true-d63770e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210'] | hl7:code[(@code = '51848-0' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:text[not(@nullFlavor)] | hl7:statusCode[@code = 'completed'] | hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]] (rule-reference: d63650e6-true-d63770e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d63650e30-true-d63869e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]]/*[not(@xsi:nil = 'true')][not(self::hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']])]" priority="1009" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d63650e30-true-d63869e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']] (rule-reference: d63650e30-true-d63869e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d63797e6-true-d63979e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213'] | self::hl7:id[not(@nullFlavor)] | self::hl7:code[(@code = '282291009' and @codeSystem = '2.16.840.1.113883.6.96')] | self::hl7:statusCode[@code = 'completed'] | self::hl7:effectiveTime | self::hl7:value | self::hl7:author[hl7:assignedAuthor])]" priority="1008" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d63797e6-true-d63979e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213'] | hl7:id[not(@nullFlavor)] | hl7:code[(@code = '282291009' and @codeSystem = '2.16.840.1.113883.6.96')] | hl7:statusCode[@code = 'completed'] | hl7:effectiveTime | hl7:value | hl7:author[hl7:assignedAuthor] (rule-reference: d63797e6-true-d63979e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d63797e44-true-d64020e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]/hl7:effectiveTime/*[not(@xsi:nil = 'true')][not(self::hl7:low | self::hl7:high)]" priority="1007" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d63797e44-true-d64020e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:low | hl7:high (rule-reference: d63797e44-true-d64020e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d63797e69-true-d64048e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]/hl7:value/*[not(@xsi:nil = 'true')][not(self::hl7:originalText)]" priority="1006" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d63797e69-true-d64048e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:originalText (rule-reference: d63797e69-true-d64048e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d63797e100-true-d64107e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]/hl7:author[hl7:assignedAuthor]/*[not(@xsi:nil = 'true')][not(self::hl7:functionCode | self::hl7:time | self::hl7:assignedAuthor)]" priority="1005" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d63797e100-true-d64107e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:functionCode | hl7:time | hl7:assignedAuthor (rule-reference: d63797e100-true-d64107e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d64112e17-true-d64170e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/*[not(@xsi:nil = 'true')][not(self::hl7:id[not(@nullFlavor)] | self::hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] | self::hl7:addr | self::hl7:telecom | self::hl7:assignedPerson | self::hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']])]" priority="1004" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Author (Body))/d64112e17-true-d64170e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:id[not(@nullFlavor)] | hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] | hl7:addr | hl7:telecom | hl7:assignedPerson | hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']] (rule-reference: d64112e17-true-d64170e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d64175e25-true-d64210e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/*[not(@xsi:nil = 'true')][not(self::hl7:name)]" priority="1003" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Assigned Entity)/d64175e25-true-d64210e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:name (rule-reference: d64175e25-true-d64210e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d64175e35-true-d64250e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.210']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/*[not(@xsi:nil = 'true')][not(self::hl7:id[@root = '2.16.528.1.1007.3.3'] | self::hl7:id | self::hl7:name | self::hl7:telecom | self::hl7:addr | self::hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor])]" priority="1002" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(KEZO PART CDA Assigned Entity)/d64175e35-true-d64250e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:id[@root = '2.16.528.1.1007.3.3'] | hl7:id | hl7:name | hl7:telecom | hl7:addr | hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] (rule-reference: d64175e35-true-d64250e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d62441e74-true-d64303e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.211']]]/*[not(@xsi:nil = 'true')][not(self::hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.211']])]" priority="1001" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d62441e74-true-d64303e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.211']] (rule-reference: d62441e74-true-d64303e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

	<!--RULE d64291e6-true-d64334e0-->

   <axsl:template match="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.14']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.211']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.211']]/*[not(@xsi:nil = 'true')][not(self::hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.211'] | self::hl7:code[(@code = '18776-5' and @codeSystem = '2.16.840.1.113883.6.1')] | self::hl7:text[not(@nullFlavor)] | self::hl7:statusCode[@code = 'completed'])]" priority="1000" mode="M16">

		<!--ASSERT warning-->

      <axsl:choose>
         <axsl:when test="not(.)"/>
         <axsl:otherwise>
            <axsl:message>(Organizer Contactverslagen)/d64291e6-true-d64334e0: dit element '<axsl:text/>
               <axsl:value-of select="name(.)"/>
               <axsl:text/>' is niet gedefinieerd, of niet gedefinieerd met deze inhoud. Mogelijk betreft dit het templateId, code, of id. Verwacht in deze context: hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.211'] | hl7:code[(@code = '18776-5' and @codeSystem = '2.16.840.1.113883.6.1')] | hl7:text[not(@nullFlavor)] | hl7:statusCode[@code = 'completed'] (rule-reference: d64291e6-true-d64334e0) (not(.) / warning / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.14)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>
   <axsl:template match="text()" priority="-1" mode="M16"/>
   <axsl:template match="@*|node()" priority="-2" mode="M16">
      <axsl:apply-templates select="*" mode="M16"/>
   </axsl:template>

<!--PATTERN template-2.16.840.1.113883.2.4.3.11.60.66.10.207-2015-06-01T000000KEZO Contactverslag-->


	<!--RULE d152e9528-false-d80253e0-->

   <axsl:template match="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]" priority="1030" mode="M26">

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@classCode) = ('ACT')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO Contactverslag): de waarde van classCode MOET 'ACT' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@classCode"/>
               <axsl:text/>" (string(@classCode) = ('ACT') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="string(@moodCode) = ('EVN')"/>
         <axsl:otherwise>
            <axsl:message>(KEZO Contactverslag): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<axsl:text/>
               <axsl:value-of select="@moodCode"/>
               <axsl:text/>" (string(@moodCode) = ('EVN') / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']) &gt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO Contactverslag): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207'] is mandatory [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']) &gt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO Contactverslag): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207'] komt te vaak voor [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:id[not(@nullFlavor)]) &gt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO Contactverslag): element hl7:id[not(@nullFlavor)] is mandatory [min 1x]. (count(hl7:id[not(@nullFlavor)]) &gt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO Contactverslag): element hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')] is mandatory [min 1x]. (count(hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO Contactverslag): element hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')] komt te vaak voor [max 1x]. (count(hl7:code[(@code = '34900-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:statusCode[@code = 'completed']) &gt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO Contactverslag): element hl7:statusCode[@code = 'completed'] is mandatory [min 1x]. (count(hl7:statusCode[@code = 'completed']) &gt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:statusCode[@code = 'completed']) &lt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO Contactverslag): element hl7:statusCode[@code = 'completed'] komt te vaak voor [max 1x]. (count(hl7:statusCode[@code = 'completed']) &lt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:effectiveTime[not(@nullFlavor)]) &gt;= 1"/>
         <axsl:otherwise>
            <axsl:message>(KEZO Contactverslag): element hl7:effectiveTime[not(@nullFlavor)] is mandatory [min 1x]. (count(hl7:effectiveTime[not(@nullFlavor)]) &gt;= 1 / error / <axsl:apply-templates select="." mode="schematron-select-full-path"/> / https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.207)</axsl:message>
         </axsl:otherwise>
      </axsl:choose>

		<!--ASSERT error-->

      <axsl:choose>
         <axsl:when test="count(hl7:effectiveTime[not(@nullFlavor)]) &lt;= 1"/>
         <axsl:otherwise>
            <axsl: