<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9254
Name: MP CDA Medication Information
Description: MP CDA Medication Information
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" id="template-2.16.840.1.113883.2.4.3.11.60.20.77.10.9254-2018-12-06T143451">
   <title>MP CDA Medication Information</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9254
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]
Item: (MP CDA Medication Information)
-->
   <rule fpi="RULC-1" context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]" id="d152e4542-false-d13123e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9254" test="count(hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]) &gt;= 1">(MP CDA Medication Information): element hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']] is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9254" test="count(hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]) &lt;= 1">(MP CDA Medication Information): element hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9254
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]
Item: (MP CDA Medication Information)
-->
   <rule fpi="RULC-1" context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]" id="d152e4560-false-d13161e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9254" test="string(@classCode) = ('MANU') or not(@classCode)">(MP CDA Medication Information): de waarde van classCode MOET 'MANU' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9254" test="hl7:manufacturedMaterial/hl7:code/@code or hl7:manufacturedMaterial/pharm:ingredient">(MP CDA Medication Information): Als er geen gecodeerde medicatie is moet er minimaal één ingrediënt zijn.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9254" test="hl7:manufacturedMaterial/hl7:code/@code or hl7:manufacturedMaterial/pharm:desc">(MP CDA Medication Information): Geneesmiddel omschrijving (pharm:desc) verplicht opnemen wanneer de codering *niet* afdoende is om de samenstelling van het geneesmiddel te achterhalen.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9254" test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']) &gt;= 1">(MP CDA Medication Information): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254'] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9254" test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']) &lt;= 1">(MP CDA Medication Information): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254'] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9254" test="count(hl7:manufacturedMaterial) &gt;= 1">(MP CDA Medication Information): element hl7:manufacturedMaterial is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9254" test="count(hl7:manufacturedMaterial) &lt;= 1">(MP CDA Medication Information): element hl7:manufacturedMaterial komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9254
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']
Item: (MP CDA Medication Information)
-->
   <rule fpi="RULC-1" context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']" id="d152e4564-false-d13222e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9254" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(MP CDA Medication Information): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9254" test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.20.77.10.9254')">(MP CDA Medication Information): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9264
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial
Item: (MP CDA Medication Contents)
-->
   <rule fpi="RULC-1" context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial" id="d13235e101-false-d13253e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="string(@classCode) = ('MMAT') or not(@classCode)">(MP CDA Medication Contents): de waarde van classCode MOET 'MMAT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="string(@determinerCode) = ('KIND') or not(@determinerCode)">(MP CDA Medication Contents): de waarde van determinerCode MOET 'KIND' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="hl7:code/@code or hl7:name">(MP CDA Medication Contents): Geneesmiddel naam (name) verplicht opnemen wanneer de codering *niet* afdoende is om de samenstelling van het geneesmiddel te achterhalen</assert>
      <assert role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="not(hl7:name and hl7:code/@code)">(MP CDA Medication Contents): Geneesmiddel naam (name) niet opnemen wanneer de codering afdoende is om de samenstelling van het geneesmiddel te achterhalen. Geneesmiddel naam (name) is alleen toegestaan bij eigen productdefinities, zoals magistralen of 90 miljoen nummers.</assert>
      <assert role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="not(hl7:desc and hl7:code/@code)">(MP CDA Medication Contents): Geneesmiddel omschrijving (pharm:desc) niet opnemen wanneer de codering afdoende is om de samenstelling van het geneesmiddel te achterhalen. &gt;Geneesmiddel omschrijving (pharm:desc) is alleen toegestaan bij eigen productdefinities, zoals magistralen of 90 miljoen nummers.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="count(hl7:code | hl7:code[not(@codeSystem=('2.16.840.1.113883.2.4.4.1.750','2.16.840.1.113883.2.4.4.1.725','2.16.840.1.113883.2.4.4.1','2.16.840.1.113883.2.4.4.10','2.16.840.1.113883.2.4.4.7','2.16.840.1.113883.2.4.4.8'))]) &lt;= 1">(MP CDA Medication Contents): keuze (hl7:code  of  hl7:code[not(@codeSystem=('2.16.840.1.113883.2.4.4.1.750','2.16.840.1.113883.2.4.4.1.725','2.16.840.1.113883.2.4.4.1','2.16.840.1.113883.2.4.4.10','2.16.840.1.113883.2.4.4.7','2.16.840.1.113883.2.4.4.8'))]) bevat te veel elementen [max 1x]</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="count(hl7:code) &lt;= 1">(MP CDA Medication Contents): element hl7:code komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="count(hl7:code[not(@codeSystem=('2.16.840.1.113883.2.4.4.1.750','2.16.840.1.113883.2.4.4.1.725','2.16.840.1.113883.2.4.4.1','2.16.840.1.113883.2.4.4.10','2.16.840.1.113883.2.4.4.7','2.16.840.1.113883.2.4.4.8'))]) &lt;= 1">(MP CDA Medication Contents): element hl7:code[not(@codeSystem=('2.16.840.1.113883.2.4.4.1.750','2.16.840.1.113883.2.4.4.1.725','2.16.840.1.113883.2.4.4.1','2.16.840.1.113883.2.4.4.10','2.16.840.1.113883.2.4.4.7','2.16.840.1.113883.2.4.4.8'))] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="count(hl7:name) &lt;= 1">(MP CDA Medication Contents): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="count(pharm:desc) &lt;= 1">(MP CDA Medication Contents): element pharm:desc komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="count(pharm:formCode[@codeSystem = '2.16.840.1.113883.2.4.4.11']) &lt;= 1">(MP CDA Medication Contents): element pharm:formCode[@codeSystem = '2.16.840.1.113883.2.4.4.11'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9253
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial
Item: (MP CDA Medication Code)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9253
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/hl7:code
Item: (MP CDA Medication Code)
-->
   <rule fpi="RULC-1" context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/hl7:code" id="d13360e36-false-d13381e0">
      <extends rule="CE"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(MP CDA Medication Code): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.8.2.10-2015-04-01T000000.xml')//valueSet[1][conceptList/include[@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.8.2.9-2015-04-01T000000.xml')//valueSet[1][conceptList/include[@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.9.5.8-2015-04-01T000000.xml')//valueSet[1][conceptList/include[@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.9.5.10-2015-04-01T000000.xml')//valueSet[1][conceptList/include[@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.9.5.9-2015-04-01T000000.xml')//valueSet[1][conceptList/include[@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.9.5.13-2015-04-01T000000.xml')//valueSet[1][conceptList/include[@codeSystem = $theCodeSystem]])">(MP CDA Medication Code): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.40.2.8.2.10 SpecifiekeStofSNKCodelijst (2015-04-01T00:00:00) of 2.16.840.1.113883.2.4.3.11.60.40.2.8.2.9 SpecifiekeStofSSKCodelijst (2015-04-01T00:00:00) of 2.16.840.1.113883.2.4.3.11.60.40.2.9.5.8 VoorschriftProductGPKCodelijst (2015-04-01T00:00:00) of 2.16.840.1.113883.2.4.3.11.60.40.2.9.5.10 VoorschriftProductPRKCodelijst (2015-04-01T00:00:00) of 2.16.840.1.113883.2.4.3.11.60.40.2.9.5.9 VoorschriftProductHPKCodelijst (2015-04-01T00:00:00) of 2.16.840.1.113883.2.4.3.11.60.40.2.9.5.13 VoorschriftProductZICodelijst (2015-04-01T00:00:00)'.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="@code">(MP CDA Medication Code): attribute @code MOET aanwezig zijn.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="@codeSystem">(MP CDA Medication Code): attribute @codeSystem MOET aanwezig zijn.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="@displayName">(MP CDA Medication Code): attribute @displayName MOET aanwezig zijn.</assert>
      <assert role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="not(../pharm:ingredient)">(MP CDA Medication Code): Bij gecodeerde medicatie volgens de G-standaard mag ingredient geen waarde hebben. Ingredient is alleen toegestaan bij eigen productdefinities, zoals magistralen of 90 miljoen nummers.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="not(hl7:translation/@codeSystem=@codeSystem)">(MP CDA Medication Code): Medicatiecode mag geen translation hebben uit hetzelfde codesysteem.</assert>
      <let name="SNK" value="'2.16.840.1.113883.2.4.4.1.750'"/>
      <let name="SSK" value="'2.16.840.1.113883.2.4.4.1.725'"/>
      <let name="GPK" value="'2.16.840.1.113883.2.4.4.1'"/>
      <let name="PRK" value="'2.16.840.1.113883.2.4.4.10'"/>
      <let name="HPK" value="'2.16.840.1.113883.2.4.4.7'"/>
      <let name="ZI" value="'2.16.840.1.113883.2.4.4.8'"/>
      <let name="codeSystems1" value="$SNK, $SSK, $GPK, $PRK, $HPK"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="not(hl7:translation) or not(hl7:translation[not(@codeSystem=data($codeSystems1))])">(MP CDA Medication Code): Eventuele translation elementen moeten meer algemene alternatieve coderingen bevatten. Translations moet één van SNK, SSK, GPK, PRK, of HPK zijn (gevonden: <value-of select="hl7:translation[not(@codeSystem=data($codeSystems1))]/@codeSystem"/>).</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="@codeSystem!=$SNK or not(hl7:translation)">(MP CDA Medication Code): Een SNK code kan geen translation hebben. Eventuele translation elementen moeten meer algemene alternatieve coderingen bevatten.</assert>
      <let name="codeSystems2" value="$GPK, $PRK, $HPK, $ZI"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="@codeSystem!=$SSK or not(hl7:translation) or not(hl7:translation[@codeSystem = data($codeSystems2)])">(MP CDA Medication Code): Eventuele translation elementen moeten equivalente of meer algemene alternatieve coderingen bevatten. SSK kan alleen vertaald worden naar SNK.</assert>
      <let name="codeSystems3" value="$PRK, $HPK, $ZI"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="not(@codeSystem = $GPK) or not(hl7:translation) or not(hl7:translation[@codeSystem = data($codeSystems3)])">(MP CDA Medication Code): Eventuele translation elementen moeten equivalente of meer algemene alternatieve coderingen bevatten. GPK kan alleen vertaald worden naar SNK of SSK.</assert>
      <let name="codeSystems4" value="$HPK, $ZI"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="not(@codeSystem = $PRK) or not(hl7:translation) or not(hl7:translation[@codeSystem = data($codeSystems4)])">(MP CDA Medication Code): Eventuele translation elementen moeten equivalente of meer algemene alternatieve coderingen bevatten. PRK kan alleen vertaald worden naar SNK, SSK of GPK.</assert>
      <assert role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="not(@codeSystem = $PRK) or hl7:translation[@codeSystem = $GPK]">(MP CDA Medication Code): Bij PRK ook vertaling naar GPK opnemen</assert>
      <let name="codeSystems5" value="$ZI"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="not(@codeSystem = $HPK) or not(hl7:translation) or not(hl7:translation[@codeSystem = data($codeSystems5)])">(MP CDA Medication Code): Eventuele translation elementen moeten equivalente of meer algemene alternatieve coderingen bevatten. HPK kan alleen vertaald worden naar SNK, SSK, GPK of PRK.</assert>
      <assert role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="not(@codeSystem = $HPK) or (hl7:translation[@codeSystem = $GPK] and hl7:translation[@codeSystem = $PRK])">(MP CDA Medication Code): Bij HPK, indien beschikbaar, ook vertaling naar PRK én GPK opnemen. Indien niet beschikbaar is het toegestaan de HPK zonder vertaling te communiceren.</assert>
      <assert role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="not(@codeSystem = $ZI) or (hl7:translation[@codeSystem = $GPK] and hl7:translation[@codeSystem = $PRK] and hl7:translation[@codeSystem = $HPK])">(MP CDA Medication Code): Bij ZI-nummer ook vertaling naar HPK, en - indien beschikbaar - PRK én GPK opnemen. Indien niet beschikbaar is het toegestaan het ZI-nummer zonder (alle) vertaling(en) te communiceren.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9253
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/hl7:code/hl7:translation
Item: (MP CDA Medication Code)
-->
   <rule fpi="RULC-1" context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/hl7:code/hl7:translation" id="d13360e64-false-d13441e0">
      <extends rule="CE"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(MP CDA Medication Code): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9253
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/hl7:code[not(@codeSystem=('2.16.840.1.113883.2.4.4.1.750','2.16.840.1.113883.2.4.4.1.725','2.16.840.1.113883.2.4.4.1','2.16.840.1.113883.2.4.4.10','2.16.840.1.113883.2.4.4.7','2.16.840.1.113883.2.4.4.8'))]
Item: (MP CDA Medication Code)
-->
   <rule fpi="RULC-1" context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/hl7:code[not(@codeSystem=('2.16.840.1.113883.2.4.4.1.750','2.16.840.1.113883.2.4.4.1.725','2.16.840.1.113883.2.4.4.1','2.16.840.1.113883.2.4.4.10','2.16.840.1.113883.2.4.4.7','2.16.840.1.113883.2.4.4.8'))]" id="d13360e128-false-d13451e0">
      <extends rule="CE"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(MP CDA Medication Code): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="not(@nullFlavor) or (string-length(@nullFlavor) &gt; 0 and not(matches(@nullFlavor,'\s')))">(MP CDA Medication Code): attribuut @nullFlavor MOET datatype 'cs' hebben  - '<value-of select="@nullFlavor"/>'</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="(@code and @displayName) or not(@code)">(MP CDA Medication Code): Medicatiecode moet attribuut @displayName hebben tenzij er geen @code is (er moet dan een @nullFlavor zijn).</assert>
      <assert role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9253" test="../pharm:ingredient">(MP CDA Medication Code): Bij magistraal / eigen bereiding / eigen codering moet er minimaal één - volgens de G-standaard gecodeerd - ingrediënt worden opgenomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9264
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/hl7:name
Item: (MP CDA Medication Contents)
-->
   <rule fpi="RULC-1" context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/hl7:name" id="d13235e113-false-d13472e0">
      <extends rule="EN"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'EN')">(MP CDA Medication Contents): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:EN" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9264
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/pharm:desc
Item: (MP CDA Medication Contents)
-->
   <rule fpi="RULC-1" context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/pharm:desc" id="d13235e122-false-d13484e0">
      <extends rule="ED"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(MP CDA Medication Contents): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9264
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/pharm:formCode[@codeSystem = '2.16.840.1.113883.2.4.4.11']
Item: (MP CDA Medication Contents)
-->
   <rule fpi="RULC-1" context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/pharm:formCode[@codeSystem = '2.16.840.1.113883.2.4.4.11']" id="d13235e127-false-d13496e0">
      <extends rule="CE"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(MP CDA Medication Contents): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="@code">(MP CDA Medication Contents): attribute @code MOET aanwezig zijn.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(MP CDA Medication Contents): attribuut @code MOET datatype 'cs' hebben  - '<value-of select="@code"/>'</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="not(@displayName) or string-length(@displayName)&gt;0">(MP CDA Medication Contents): attribuut @displayName MOET datatype 'st' hebben  - '<value-of select="@displayName"/>'</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="string(@codeSystem) = ('2.16.840.1.113883.2.4.4.11')">(MP CDA Medication Contents): de waarde van codeSystem MOET '2.16.840.1.113883.2.4.4.11' zijn. Gevonden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="string(@codeSystemName) = ('G-Standaard Farmaceutische vormen (tabel 6)') or not(@codeSystemName)">(MP CDA Medication Contents): de waarde van codeSystemName MOET 'G-Standaard Farmaceutische vormen (tabel 6)' zijn. Gevonden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(MP CDA Medication Contents): attribuut @codeSystemName MOET datatype 'st' hebben  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9264" test="not(hl7:formcode and hl7:code/@code)">(MP CDA Medication Contents): Farmaceutische vorm niet opnemen wanneer de codering afdoende is om de samenstelling van het geneesmiddel te achterhalen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9106
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/pharm:ingredient[@classCode='INGR']
Item: (MP CDA Ingredient)
-->
   <rule fpi="RULC-1" context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/pharm:ingredient[@classCode='INGR']" id="d13536e4-false-d13541e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9106" test="string(@classCode) = ('INGR') or not(@classCode)">(MP CDA Ingredient): de waarde van classCode MOET 'INGR' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9106" test="count(pharm:quantity) &lt;= 1">(MP CDA Ingredient): element pharm:quantity komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9106" test="count(pharm:ingredient[@classCode='MMAT']) &lt;= 1">(MP CDA Ingredient): element pharm:ingredient[@classCode='MMAT'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9106
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/pharm:ingredient[@classCode='INGR']/pharm:quantity
Item: (MP CDA Ingredient)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9071
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/pharm:ingredient[@classCode='INGR']/pharm:quantity
Item: (MP Ingredient quantity)
-->
   <rule fpi="RULC-1" context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/pharm:ingredient[@classCode='INGR']/pharm:quantity">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="count(hl7:numerator[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]) &gt;= 1">(MP Ingredient quantity): element hl7:numerator[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')] is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="count(hl7:numerator[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]) &lt;= 1">(MP Ingredient quantity): element hl7:numerator[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="count(hl7:denominator[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]) &gt;= 1">(MP Ingredient quantity): element hl7:denominator[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')] is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="count(hl7:denominator[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]) &lt;= 1">(MP Ingredient quantity): element hl7:denominator[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9071
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/pharm:ingredient[@classCode='INGR']/pharm:quantity/hl7:numerator[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]
Item: (MP Ingredient quantity)
-->
   <rule fpi="RULC-1" context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/pharm:ingredient[@classCode='INGR']/pharm:quantity/hl7:numerator[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(MP Ingredient quantity): attribuut @unit MOET datatype 'cs' hebben  - '<value-of select="@unit"/>'</assert>
      <extends rule="PQ"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(MP Ingredient quantity): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest" value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="$UCUMtest='OK' or string-length($UCUMtest)=0">(MP Ingredient quantity): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
      <let name="xsiLocalName" value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS" value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="@nullFlavor or ($xsiLocalName='PQ' and $xsiLocalNS='urn:hl7-org:v3')">(MP Ingredient quantity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="not(@nullFlavor) or (string-length(@nullFlavor) &gt; 0 and not(matches(@nullFlavor,'\s')))">(MP Ingredient quantity): attribuut @nullFlavor MOET datatype 'cs' hebben  - '<value-of select="@nullFlavor"/>'</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="not(@value) or matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(MP Ingredient quantity): attribuut @value is geen geldig real getal <value-of select="@value"/>
      </assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="count(hl7:translation[@codeSystem='2.16.840.1.113883.2.4.4.1.900.2']) &lt;= 1">(MP Ingredient quantity): element hl7:translation[@codeSystem='2.16.840.1.113883.2.4.4.1.900.2'] komt te vaak voor [max 1x].</assert>
      <assert role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="not(@unit) or matches(string(@unit),'^1$|^[umcdk]?[mgl]+$|^\[drp\]$|^\[tsp_us\]$|^\[tbs_us\]$|^\[iU\]$')">(MP Ingredient quantity): De gevonden UCUM eenheid '<value-of select="@unit"/>' behoort niet tot de meest gebruikte. Is de UCUM eenheid correct?</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="not(exists(@value)) or hl7:translation[@codeSystem='2.16.840.1.113883.2.4.4.1.900.2']">(MP Ingredient quantity): Vertaling naar de G-Standaard basiseenheden (tabel 2 van de thesauraus) is verplicht.</assert>
      <assert role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="not(exists(@value)) or hl7:translation[@codeSystem='2.16.840.1.113883.2.4.4.1.900.2' and @value=../@value]">(MP Ingredient quantity): translation/@value in G-Standaard basiseenheden tabel 2 is niet gelijk aan dose(Check)Quantity/@value, controleer of dit klopt.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9021
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/pharm:ingredient[@classCode='INGR']/pharm:quantity/hl7:numerator[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]/hl7:translation[@codeSystem='2.16.840.1.113883.2.4.4.1.900.2']
Item: (Quantity unit and translation(s))
-->
   <rule fpi="RULC-1" context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/pharm:ingredient[@classCode='INGR']/pharm:quantity/hl7:numerator[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]/hl7:translation[@codeSystem='2.16.840.1.113883.2.4.4.1.900.2']">
      <extends rule="PQR"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9021" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQR')">(Quantity unit and translation(s)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQR" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9021" test="@value">(Quantity unit and translation(s)): attribute @value MOET aanwezig zijn.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9021" test="not(@value) or matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Quantity unit and translation(s)): attribuut @value is geen geldig real getal <value-of select="@value"/>
      </assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9021" test="@code">(Quantity unit and translation(s)): attribute @code MOET aanwezig zijn.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9021" test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Quantity unit and translation(s)): attribuut @code MOET datatype 'cs' hebben  - '<value-of select="@code"/>'</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9021" test="string(@codeSystem) = ('2.16.840.1.113883.2.4.4.1.900.2')">(Quantity unit and translation(s)): de waarde van codeSystem MOET '2.16.840.1.113883.2.4.4.1.900.2' zijn. Gevonden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9021" test="@displayName">(Quantity unit and translation(s)): attribute @displayName MOET aanwezig zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9071
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/pharm:ingredient[@classCode='INGR']/pharm:quantity/hl7:denominator[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]
Item: (MP Ingredient quantity)
-->
   <rule fpi="RULC-1" context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/pharm:ingredient[@classCode='INGR']/pharm:quantity/hl7:denominator[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(MP Ingredient quantity): attribuut @unit MOET datatype 'cs' hebben  - '<value-of select="@unit"/>'</assert>
      <extends rule="PQ"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(MP Ingredient quantity): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest" value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="$UCUMtest='OK' or string-length($UCUMtest)=0">(MP Ingredient quantity): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
      <let name="xsiLocalName" value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS" value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="@nullFlavor or ($xsiLocalName='PQ' and $xsiLocalNS='urn:hl7-org:v3')">(MP Ingredient quantity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="@value">(MP Ingredient quantity): attribute @value MOET aanwezig zijn.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="not(@value) or matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(MP Ingredient quantity): attribuut @value is geen geldig real getal <value-of select="@value"/>
      </assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="count(hl7:translation[@codeSystem='2.16.840.1.113883.2.4.4.1.900.2']) &lt;= 1">(MP Ingredient quantity): element hl7:translation[@codeSystem='2.16.840.1.113883.2.4.4.1.900.2'] komt te vaak voor [max 1x].</assert>
      <assert role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="not(@unit) or matches(string(@unit),'^1$|^[umcdk]?[mgl]+$|^\[drp\]$|^\[tsp_us\]$|^\[tbs_us\]$|^\[iU\]$')">(MP Ingredient quantity): De gevonden UCUM eenheid '<value-of select="@unit"/>' behoort niet tot de meest gebruikte. Is de UCUM eenheid correct?</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="not(exists(@value)) or hl7:translation[@codeSystem='2.16.840.1.113883.2.4.4.1.900.2']">(MP Ingredient quantity): Vertaling naar de G-Standaard basiseenheden (tabel 2 van de thesauraus) is verplicht.</assert>
      <assert role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9071" test="not(exists(@value)) or hl7:translation[@codeSystem='2.16.840.1.113883.2.4.4.1.900.2' and @value=../@value]">(MP Ingredient quantity): translation/@value in G-Standaard basiseenheden tabel 2 is niet gelijk aan dose(Check)Quantity/@value, controleer of dit klopt.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9021
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/pharm:ingredient[@classCode='INGR']/pharm:quantity/hl7:denominator[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]/hl7:translation[@codeSystem='2.16.840.1.113883.2.4.4.1.900.2']
Item: (Quantity unit and translation(s))
-->
   <rule fpi="RULC-1" context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/pharm:ingredient[@classCode='INGR']/pharm:quantity/hl7:denominator[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]/hl7:translation[@codeSystem='2.16.840.1.113883.2.4.4.1.900.2']">
      <extends rule="PQR"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9021" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQR')">(Quantity unit and translation(s)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQR" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9021" test="@value">(Quantity unit and translation(s)): attribute @value MOET aanwezig zijn.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9021" test="not(@value) or matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Quantity unit and translation(s)): attribuut @value is geen geldig real getal <value-of select="@value"/>
      </assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9021" test="@code">(Quantity unit and translation(s)): attribute @code MOET aanwezig zijn.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9021" test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Quantity unit and translation(s)): attribuut @code MOET datatype 'cs' hebben  - '<value-of select="@code"/>'</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9021" test="string(@codeSystem) = ('2.16.840.1.113883.2.4.4.1.900.2')">(Quantity unit and translation(s)): de waarde van codeSystem MOET '2.16.840.1.113883.2.4.4.1.900.2' zijn. Gevonden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9021" test="@displayName">(Quantity unit and translation(s)): attribute @displayName MOET aanwezig zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9073
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/pharm:ingredient[@classCode='INGR']/pharm:ingredient[@classCode='MMAT']
Item: (MP CDA Ingredient Material Kind)
-->
   <rule fpi="RULC-1" context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]/hl7:manufacturedMaterial/pharm:ingredient[@classCode='INGR']/pharm:ingredient[@classCode='MMAT']" id="d13840e5-false-d13845e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9073" test="string(@classCode) = ('MMAT') or not(@classCode)">(MP CDA Ingredient Material Kind): de waarde van classCode MOET 'MMAT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.20.77.10.9073" test="string(@determinerCode) = ('KIND') or not(@determinerCode)">(MP CDA Ingredient Material Kind): de waarde van determinerCode MOET 'KIND' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
   </rule>
</pattern>